/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml.wrapper;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.ho.yaml.exception.YamlException;
import org.ho.yaml.wrapper.DefaultSimpleTypeWrapper;
import org.ho.yaml.wrapper.ObjectWrapper;
import org.ho.yaml.wrapper.WrapperFactory;

public class DateWrapper
extends DefaultSimpleTypeWrapper
implements WrapperFactory {
    public static final String DATEFORMAT_YAML = "yyyy-MM-dd hh:mm:ss";
    public static final String DATEFORMAT_ISO8601 = "yyyy-MM-dd'T'hh:mm:ss.SSS'Z'";

    public DateWrapper() {
        super(Date.class);
    }

    public Class expectedArgType() {
        return String.class;
    }

    public ObjectWrapper makeWrapper() {
        DateWrapper dateWrapper = new DateWrapper();
        dateWrapper.setYamlConfig(this.config);
        return dateWrapper;
    }

    public void setObject(Object object) {
        if (object == null) {
            super.setObject(null);
        } else if (object instanceof Date) {
            super.setObject(object);
        } else {
            String string = (String)object;
            super.setObject(this.parseDate(string));
            if (!this.objectInitialized) {
                throw new YamlException("Can't instantiate " + this.getType() + " with literal " + string);
            }
        }
    }

    Date parseDate(String string) {
        DateFormat dateFormat = this.config.getDateFormatter();
        if (dateFormat != null) {
            try {
                return dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                throw new YamlException("Error parsing date: '" + string + "'", parseException);
            }
        }
        try {
            return new Date(Long.parseLong(string));
        }
        catch (NumberFormatException numberFormatException) {
            return new Date(string);
        }
    }

    public Object getOutputValue() {
        return this.formateDate((Date)this.getObject());
    }

    String formateDate(Date date) {
        DateFormat dateFormat = this.config.getDateFormatter();
        if (dateFormat == null) {
            return "" + date.getTime();
        }
        return "\"" + dateFormat.format(date) + "\"";
    }
}

