/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.DoubleCollection;
import bak.pcj.DoubleIterator;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.hash.DoubleHashFunction;
import bak.pcj.hash.Primes;
import bak.pcj.set.AbstractDoubleSet;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DoubleChainedHashSet
extends AbstractDoubleSet
implements DoubleSet,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private DoubleHashFunction keyhash;
    private int size;
    private transient double[][] data;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;

    private DoubleChainedHashSet(DoubleHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor < 0.0) {
            Exceptions.negativeArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk < 0) {
            Exceptions.negativeArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.data = new double[capacity][];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
        this.keyhash = keyhash;
    }

    private DoubleChainedHashSet(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultDoubleHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public DoubleChainedHashSet() {
        this(11);
    }

    public DoubleChainedHashSet(DoubleCollection c) {
        this();
        this.addAll(c);
    }

    public DoubleChainedHashSet(double[] a) {
        this();
        int i = 0;
        while (i < a.length) {
            this.add(a[i]);
            ++i;
        }
    }

    public DoubleChainedHashSet(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public DoubleChainedHashSet(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public DoubleChainedHashSet(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public DoubleChainedHashSet(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public DoubleChainedHashSet(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public DoubleChainedHashSet(DoubleHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public DoubleChainedHashSet(DoubleHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public DoubleChainedHashSet(DoubleHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public DoubleChainedHashSet(DoubleHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public DoubleChainedHashSet(DoubleHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public DoubleChainedHashSet(DoubleHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            double[][] newdata = new double[newcapacity][];
            int i = 0;
            while (i < this.data.length) {
                double[] list = this.data[i];
                if (list != null) {
                    int n = 0;
                    while (n < list.length) {
                        double v = list[n];
                        int index = Math.abs(this.keyhash.hash(v)) % newdata.length;
                        newdata[index] = this.addList(newdata[index], v);
                        ++n;
                    }
                }
                ++i;
            }
            this.data = newdata;
        }
    }

    private double[] addList(double[] list, double v) {
        if (list == null) {
            return new double[]{v};
        }
        double[] newlist = new double[list.length + 1];
        int i = 0;
        while (i < list.length) {
            newlist[i] = list[i];
            ++i;
        }
        newlist[list.length] = v;
        return newlist;
    }

    private double[] removeList(double[] list, int index) {
        if (list.length == 1) {
            return null;
        }
        double[] newlist = new double[list.length - 1];
        int n = 0;
        int i = 0;
        while (i < index) {
            newlist[n++] = list[i];
            ++i;
        }
        int i2 = index + 1;
        while (i2 < list.length) {
            newlist[n++] = list[i2];
            ++i2;
        }
        return newlist;
    }

    private int searchList(double[] list, double v) {
        int i = 0;
        while (i < list.length) {
            if (list[i] == v) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean add(double v) {
        this.ensureCapacity(this.size + 1);
        int index = Math.abs(this.keyhash.hash(v)) % this.data.length;
        double[] list = this.data[index];
        if (list == null) {
            this.data[index] = new double[]{v};
            ++this.size;
            return true;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i] == v) {
                return false;
            }
            ++i;
        }
        this.data[index] = this.addList(this.data[index], v);
        ++this.size;
        return true;
    }

    public DoubleIterator iterator() {
        return new DoubleIterator(){
            int currList = this.nextList(0);
            int currDouble = 0;
            int lastList = -1;
            int lastDouble;
            double lastValue;

            int nextList(int index) {
                while (index < DoubleChainedHashSet.this.data.length && DoubleChainedHashSet.this.data[index] == null) {
                    ++index;
                }
                return index < DoubleChainedHashSet.this.data.length ? index : -1;
            }

            public boolean hasNext() {
                return this.currList != -1;
            }

            public double next() {
                if (this.currList == -1) {
                    Exceptions.endOfIterator();
                }
                this.lastList = this.currList;
                this.lastDouble = this.currDouble;
                this.lastValue = DoubleChainedHashSet.this.data[this.currList][this.currDouble];
                if (this.currDouble == DoubleChainedHashSet.this.data[this.currList].length - 1) {
                    this.currList = this.nextList(this.currList + 1);
                    this.currDouble = 0;
                } else {
                    ++this.currDouble;
                }
                return this.lastValue;
            }

            public void remove() {
                if (this.lastList == -1) {
                    Exceptions.noElementToRemove();
                }
                if (this.currList == this.lastList) {
                    --this.currDouble;
                }
                ((DoubleChainedHashSet)DoubleChainedHashSet.this).data[this.lastList] = DoubleChainedHashSet.this.removeList(DoubleChainedHashSet.this.data[this.lastList], this.lastDouble);
                DoubleChainedHashSet.this.size--;
                this.lastList = -1;
            }
        };
    }

    public void trimToSize() {
    }

    public Object clone() {
        try {
            DoubleChainedHashSet c = (DoubleChainedHashSet)super.clone();
            c.data = new double[this.data.length][];
            System.arraycopy(this.data, 0, c.data, 0, this.data.length);
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(double v) {
        double[] list = this.data[Math.abs(this.keyhash.hash(v)) % this.data.length];
        if (list == null) {
            return false;
        }
        return this.searchList(list, v) != -1;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this.data.length) {
            double[] list = this.data[i];
            if (list != null) {
                int n = 0;
                while (n < list.length) {
                    h = (int)((double)h + list[n]);
                    ++n;
                }
            }
            ++i;
        }
        return h;
    }

    public boolean remove(double v) {
        int index = Math.abs(this.keyhash.hash(v)) % this.data.length;
        double[] list = this.data[index];
        if (list != null) {
            int lindex = this.searchList(list, v);
            if (lindex == -1) {
                return false;
            }
            this.data[index] = this.removeList(list, lindex);
            --this.size;
            return true;
        }
        return false;
    }

    public double[] toArray(double[] a) {
        if (a == null || a.length < this.size) {
            a = new double[this.size];
        }
        int p = 0;
        int i = 0;
        while (i < this.data.length) {
            double[] list = this.data[i];
            if (list != null) {
                int n = 0;
                while (n < list.length) {
                    a[p++] = list[n];
                    ++n;
                }
            }
            ++i;
        }
        return a;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.data.length);
        DoubleIterator i = this.iterator();
        while (i.hasNext()) {
            double x = i.next();
            s.writeDouble(x);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = new double[s.readInt()][];
        int i = 0;
        while (i < this.size) {
            double v = s.readDouble();
            int index = Math.abs(this.keyhash.hash(v)) % this.data.length;
            double[] list = this.data[index];
            this.data[index] = list == null ? new double[]{v} : this.addList(this.data[index], v);
            ++i;
        }
    }
}

