/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.ShortCollection;
import bak.pcj.hash.DefaultShortHashFunction;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ShortKeyShortMap;
import bak.pcj.map.ShortKeyShortMapIterator;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractShortKeyShortMap
implements ShortKeyShortMap {
    protected AbstractShortKeyShortMap() {
    }

    public void clear() {
        ShortKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public short remove(short key) {
        ShortKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            short value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultShort();
    }

    public void putAll(ShortKeyShortMap map) {
        ShortKeyShortMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(short key) {
        ShortKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public short get(short key) {
        ShortKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultShort();
    }

    public boolean containsValue(short value) {
        ShortKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShortKeyShortMap)) {
            return false;
        }
        ShortKeyShortMap map = (ShortKeyShortMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        ShortKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            short k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        ShortKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultShortHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultShortHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        ShortKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public short tget(short key) {
        short value = this.get(key);
        if (value == MapDefaults.defaultShort() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        ShortKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract ShortCollection values();

    public abstract short put(short var1, short var2);

    public abstract short lget();

    public abstract ShortSet keySet();

    public abstract ShortKeyShortMapIterator entries();
}

