/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.XCellEditor;
import org.openrdf.sesame.config.ui.XTableModel;
import org.openrdf.sesame.config.ui.util.Util;

public abstract class XTable
extends JTable {
    protected SystemConfig _config;
    protected XTableModel _model;
    protected String _value;

    public XTable(SystemConfig config) {
        this._config = config;
    }

    public void setXTableModel(XTableModel model) {
        this._model = model;
        this.setAutoCreateColumnsFromModel(false);
        this.setModel(model);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableCellRenderer renderer = this._createCellRenderer(i);
            TableCellEditor editor = this._createCellEditor(i);
            TableColumn column = new TableColumn(i, model.getColumnWidth(i), renderer, editor);
            JTableHeader header = new JTableHeader();
            DefaultTableCellRenderer headerRenderer = (DefaultTableCellRenderer)header.getDefaultRenderer();
            headerRenderer.setHorizontalAlignment(model.getColumnAlignment(i));
            column.setHeaderRenderer(headerRenderer);
            this.addColumn(column);
        }
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
    }

    protected abstract TableCellRenderer _createCellRenderer(int var1);

    protected abstract TableCellEditor _createCellEditor(int var1);

    public void editingStopped(ChangeEvent e) {
        this._value = this.getEditingColumn() == this._model.getIdentifyingColumn() ? (String)this.getCellEditor().getCellEditorValue() : this.getIdentifierForSelectedRow();
        super.editingStopped(e);
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        this._value = null;
        Object value = this.getValueAt(row, column);
        XCellEditor xCellEditor = (XCellEditor)editor;
        xCellEditor.setValue(value);
        return super.prepareEditor(editor, row, column);
    }

    public boolean editCellAt(int row, int column) {
        boolean editCellAt = super.editCellAt(row, column);
        this.requestFocus();
        return editCellAt;
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
    }

    public void tableChanged(TableModelEvent e) {
        int row = -1;
        if (e.getType() == 1) {
            row = e.getFirstRow();
        } else if (e.getType() == 0) {
            if (this._value != null) {
                row = this._model.getRowIndex(this._value);
            } else {
                row = this.getSelectedRow();
                if (row == -1) {
                    row = this.getEditingRow();
                }
                if (row == -1) {
                    row = 0;
                }
            }
        } else if (e.getType() == -1) {
            row = e.getFirstRow() - 1;
        }
        super.tableChanged(e);
        if (row != -1 && row + 1 <= this.getRowCount()) {
            this.setRowSelectionInterval(row, row);
            this._value = null;
        }
    }

    public void requestFocus() {
        Component component = this.getEditorComponent();
        if (component != null) {
            component.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public XTableModel getXTableModel() {
        return this._model;
    }

    public String getIdentifierForSelectedRow() {
        int row = this.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return (String)this.getValueAt(row, this._model.getIdentifyingColumn());
    }

    public void addNewRow() {
        int row = this.getSelectedRow() + 1;
        this._model.addNewRow(row);
        this.editCellAt(row, this._model.getIdentifyingColumn());
    }

    public abstract void removeRow();

    public boolean stopCellEditing() {
        int row = this.getEditingRow();
        if (row != -1) {
            if (this.getCellEditor().stopCellEditing()) {
                return !this._model.rowIsNew(row);
            }
            return false;
        }
        return true;
    }

    public void selectPreviousRowTo(int row) {
        if (--row == -1 && this.getRowCount() > 0) {
            row = 0;
        }
        if (row != -1) {
            this.setRowSelectionInterval(row, row);
        }
    }

    protected void _showWarningDialog(String warning, String title) {
        Util.showWarningDialog(this._getOwner(), warning, title);
    }

    protected Window _getOwner() {
        return Util.getOwner(this);
    }
}

