/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.health;

import com.yammer.metrics.core.HealthCheck;
import jeeves.monitor.HealthCheckFactory;
import jeeves.server.context.ServiceContext;
import jeeves.server.resources.Stats;

public class FreeConnectionsHealthCheck
implements HealthCheckFactory {
    public HealthCheck create(final ServiceContext context) {
        return new HealthCheck(this.getClass().getSimpleName()){

            protected HealthCheck.Result check() throws Exception {
                try {
                    Stats stats = new Stats(context);
                    int free = stats.maxActive - stats.numActive;
                    double fivePercent = Math.max(2.0, (double)stats.maxActive.intValue() * 0.01);
                    if ((double)free < fivePercent) {
                        return HealthCheck.Result.unhealthy((String)("There are insufficient free connections on databasemain-db.  Connections free:" + free));
                    }
                    return HealthCheck.Result.healthy();
                }
                catch (Exception e) {
                    return HealthCheck.Result.unhealthy((Throwable)e);
                }
            }
        };
    }
}

