/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.server.BaseConfigManager;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.ConfigManager;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLConfigManager
extends BaseConfigManager
implements ConfigManager {
    protected DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
    protected String filename = "DeployedServices.xml";

    public void loadRegistry() throws SOAPException {
        this.dds = null;
        try {
            File file = ServerHTTPUtils.getFileFromNameAndContext(this.filename, this.context);
            FileReader fileReader = new FileReader(file);
            Document document = null;
            Element element = null;
            try {
                document = this.xdb.parse(new InputSource(fileReader));
                element = document.getDocumentElement();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SOAPException(Constants.FAULT_CODE_SERVER, exception.getMessage());
            }
            NodeList nodeList = element.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "service");
            int n = nodeList.getLength();
            this.dds = new Hashtable();
            int n2 = 0;
            while (n2 < n) {
                Element element2 = (Element)nodeList.item(n2);
                DeploymentDescriptor deploymentDescriptor = DeploymentDescriptor.fromXML(element2);
                String string = deploymentDescriptor.getID();
                this.dds.put(string, deploymentDescriptor);
                ++n2;
            }
        }
        catch (Exception exception) {
            this.dds = new Hashtable();
            System.err.println("SOAP Service Manager: Unable to read '" + this.filename + "': assuming fresh start");
        }
    }

    public void saveRegistry() throws SOAPException {
        try {
            File file = ServerHTTPUtils.getFileFromNameAndContext(this.filename, this.context);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            Enumeration enumeration = this.dds.elements();
            printWriter.println("<deployedServices>");
            printWriter.println();
            while (enumeration.hasMoreElements()) {
                DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)enumeration.nextElement();
                deploymentDescriptor.toXML(printWriter);
                printWriter.println();
            }
            printWriter.println("</deployedServices>");
            printWriter.close();
        }
        catch (Exception exception) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error saving services registry: " + exception.getMessage());
        }
    }

    public void setOptions(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        String string = (String)hashtable.get("filename");
        if (string != null && !"".equals(string)) {
            this.filename = string;
        }
    }
}

