/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.TypeDeclarationsIRFactory;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;

public final class ConvertToTypedES6
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;

    public ConvertToTypedES6(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo bestJSDocInfo = NodeUtil.getBestJSDocInfo(n);
        switch (n.getType()) {
            case 105: {
                if (bestJSDocInfo == null) break;
                this.setTypeExpression(n, bestJSDocInfo.getReturnType());
                break;
            }
            case 33: 
            case 38: {
                JSTypeExpression parameterType;
                JSDocInfo parentDocInfo;
                if (parent == null) break;
                if (parent.isVar() || parent.isAssign() || parent.isExprResult()) {
                    if (bestJSDocInfo == null) break;
                    this.setTypeExpression(n, bestJSDocInfo.getType());
                    break;
                }
                if (!parent.isParamList() || (parentDocInfo = NodeUtil.getBestJSDocInfo(parent)) == null || (parameterType = parentDocInfo.getParameterType(n.getString())) == null) break;
                Node attachTypeExpr = n;
                if (parameterType.getRoot().getType() == 305) {
                    attachTypeExpr = Node.newString(173, n.getString());
                    n.getParent().replaceChild(n, attachTypeExpr);
                    this.compiler.reportCodeChange();
                }
                this.setTypeExpression(attachTypeExpr, parameterType);
                break;
            }
        }
    }

    private void setTypeExpression(Node n, JSTypeExpression type) {
        Node.TypeDeclarationNode node = TypeDeclarationsIRFactory.convert(type);
        if (node != null) {
            n.setDeclaredTypeExpression(node);
            this.compiler.reportCodeChange();
        }
    }
}

