/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.api.records.attachments.StoreUtils;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.exceptions.ServiceNotAllowedEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.services.NotInReadOnlyModeService;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

@Deprecated
public class Create
extends NotInReadOnlyModeService {
    boolean useEditTab = false;

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.useEditTab = params.getValue("editTab", "false").equals("true");
    }

    public Element serviceSpecificExec(Element params, ServiceContext context) throws Exception {
        String metadataUuid;
        String id;
        String uuid;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        String child = Util.getParam((Element)params, (String)"child", (String)"n");
        String isTemplate = Util.getParam((Element)params, (String)"template", (String)"n");
        boolean haveAllRights = Boolean.valueOf(Util.getParam((Element)params, (String)"fullPrivileges", (String)"false"));
        SettingManager sm = (SettingManager)gc.getBean(SettingManager.class);
        boolean generateUuid = sm.getValueAsBool("system/metadatacreate/generateUuid");
        try {
            uuid = Util.getParam((Element)params, (String)"uuid");
            id = dm.getMetadataId(uuid);
        }
        catch (BadInputEx x) {
            try {
                id = Util.getParam((Element)params, (String)"id");
                uuid = dm.getMetadataUuid(id);
            }
            catch (BadInputEx xx) {
                throw new Exception("Request must contain a UUID or an ID");
            }
        }
        if (!generateUuid) {
            metadataUuid = Util.getParam((Element)params, (String)"metadataUuid", (String)"");
            if (StringUtils.isEmpty((String)metadataUuid)) {
                metadataUuid = UUID.randomUUID().toString();
            } else if (StringUtils.isNotEmpty((String)dm.getMetadataId(metadataUuid))) {
                throw new Exception("The metadata UUID already exists. Choose another one");
            }
        } else {
            metadataUuid = UUID.randomUUID().toString();
        }
        String groupOwner = Util.getParam((Element)params, (String)"group");
        UserSession user = context.getUserSession();
        if (user.getProfile() != Profile.Administrator) {
            Specifications spec = Specifications.where((Specification)UserGroupSpecs.hasProfile((Profile)Profile.Editor)).and(UserGroupSpecs.hasUserId((int)user.getUserIdAsInt())).and(UserGroupSpecs.hasGroupId((Integer)Integer.valueOf(groupOwner)));
            List userGroups = ((UserGroupRepository)context.getBean(UserGroupRepository.class)).findAll((Specification)spec);
            if (userGroups.size() == 0) {
                throw new ServiceNotAllowedEx("Service not allowed. User needs to be Editor in group with id " + groupOwner);
            }
        }
        SettingManager settingManager = (SettingManager)gc.getBean(SettingManager.class);
        String newId = dm.createMetadata(context, id, groupOwner, settingManager.getSiteId(), context.getUserSession().getUserIdAsInt(), child.equals("n") ? null : uuid, isTemplate, haveAllRights, metadataUuid);
        dm.activateWorkflowIfConfigured(context, newId, groupOwner);
        try {
            StoreUtils.copyDataDir((ServiceContext)context, (int)Integer.parseInt(id), (int)Integer.parseInt(newId), (boolean)true);
        }
        catch (Exception e) {
            Log.warning((String)"geonetwork.datamanager", (Object)("Error while copying metadata resources. " + e.toString() + ". Metadata is created but without resources from record with id:" + id));
        }
        Element response = new Element("response");
        response.addContent((Content)new Element("JUSTCREATED").setText("true"));
        String sessionTabProperty = this.useEditTab ? "metadata.editing.tab" : "metadata.show";
        Element elCurrTab = params.getChild("currTab");
        if (elCurrTab != null) {
            context.getUserSession().setProperty(sessionTabProperty, (Object)elCurrTab.getText());
        }
        response.addContent((Content)new Element("id").setText(newId));
        return response;
    }
}

