/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.users;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.api.users.PasswordUpdateParameter;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.util.PasswordUtil;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/user", "/{portal}/api/0.1/user"})
@Api(value="users", tags={"users"}, description="User operations")
public class PasswordApi {
    public static final String LOGGER = "geonetwork.api.user";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    UserRepository userRepository;
    @Autowired
    SettingManager sm;

    @ApiOperation(value="Update user password", nickname="updatePassword", notes="Get a valid changekey by email first and then update your password.")
    @RequestMapping(value={"/{username}"}, method={RequestMethod.PATCH}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity<String> updatePassword(@ApiParam(value="The user name", required=true) @PathVariable String username, @ApiParam(value="The new password and a valid change key", required=true) @RequestBody PasswordUpdateParameter passwordAndChangeKey, HttpServletRequest request) throws Exception {
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale);
        ServiceContext context = ApiUtils.createServiceContext(request);
        User user = this.userRepository.findOneByUsername(username);
        if (user == null) {
            Log.warning((String)LOGGER, (Object)String.format("User update password. Can't find user '%s'", username));
            return new ResponseEntity((Object)String.format(messages.getString("user_password_notchanged"), XslUtil.encodeForJavaScript((String)username)), HttpStatus.PRECONDITION_FAILED);
        }
        if ("LDAP".equals(user.getSecurity().getAuthType())) {
            Log.warning((String)LOGGER, (Object)String.format("User '%s' is authenticated using LDAP. Password can't be sent by email.", username));
            return new ResponseEntity((Object)String.format(messages.getString("user_password_notchanged"), XslUtil.encodeForJavaScript((String)username)), HttpStatus.PRECONDITION_FAILED);
        }
        String scrambledPassword = user.getPassword();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String todaysDate = sdf.format(cal.getTime());
        boolean passwordMatches = PasswordUtil.encoder((ApplicationContext)ApplicationContextHolder.get()).matches((CharSequence)(scrambledPassword + todaysDate), passwordAndChangeKey.getChangeKey());
        if (!passwordMatches) {
            return new ResponseEntity((Object)String.format(messages.getString("user_password_invalid_changekey"), passwordAndChangeKey.getChangeKey(), XslUtil.encodeForJavaScript((String)username)), HttpStatus.PRECONDITION_FAILED);
        }
        user.getSecurity().setPassword(PasswordUtil.encode((ServiceContext)context, (String)passwordAndChangeKey.getPassword()));
        this.userRepository.save((Object)user);
        String adminEmail = this.sm.getValue("system/feedback/email");
        String subject = String.format(messages.getString("password_change_subject"), this.sm.getSiteName());
        String content = String.format(messages.getString("password_change_message"), this.sm.getSiteName(), adminEmail, this.sm.getSiteName());
        if (!MailUtil.sendMail((String)user.getEmail(), (String)subject, (String)content, null, (SettingManager)this.sm, (String)adminEmail, (String)"").booleanValue()) {
            return new ResponseEntity((Object)String.format(messages.getString("mail_error"), new Object[0]), HttpStatus.PRECONDITION_FAILED);
        }
        return new ResponseEntity((Object)String.format(messages.getString("user_password_changed"), XslUtil.encodeForJavaScript((String)username)), HttpStatus.CREATED);
    }

    @ApiOperation(value="Send user password reminder by email", nickname="sendPasswordByEmail", notes="An email is sent to the requested user with a link to reset his password. User MUST have an email to get the link. LDAP users will not be able to retrieve their password using this service.")
    @RequestMapping(value={"/actions/forgot-password"}, method={RequestMethod.PUT}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity<String> sendPasswordByEmail(@ApiParam(value="The user name", required=true) @RequestParam String username, HttpServletRequest request) throws Exception {
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        String language = locale.getISO3Language();
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale);
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        User user = this.userRepository.findOneByUsername(username);
        if (user == null) {
            Log.warning((String)LOGGER, (Object)String.format("User reset password. Can't find user '%s'", username));
            return new ResponseEntity((Object)String.format(messages.getString("user_password_sent"), XslUtil.encodeForJavaScript((String)username)), HttpStatus.CREATED);
        }
        if ("LDAP".equals(user.getSecurity().getAuthType())) {
            Log.warning((String)LOGGER, (Object)String.format("User '%s' is authenticated using LDAP. Password can't be sent by email.", username));
            return new ResponseEntity((Object)String.format(messages.getString("user_password_sent"), XslUtil.encodeForJavaScript((String)username)), HttpStatus.CREATED);
        }
        String email = user.getEmail();
        if (StringUtils.isEmpty((Object)email)) {
            Log.warning((String)LOGGER, (Object)String.format("User reset password. User '%s' has no email", username));
            return new ResponseEntity((Object)String.format(messages.getString("user_password_sent"), XslUtil.encodeForJavaScript((String)username)), HttpStatus.CREATED);
        }
        String adminEmail = this.sm.getValue("system/feedback/email");
        String scrambledPassword = user.getPassword();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String todaysDate = sdf.format(cal.getTime());
        String changeKey = PasswordUtil.encode((ServiceContext)serviceContext, (String)(scrambledPassword + todaysDate));
        String subject = String.format(messages.getString("password_forgotten_subject"), this.sm.getSiteName(), username);
        String content = String.format(messages.getString("password_forgotten_message"), this.sm.getSiteName(), this.sm.getSiteURL(language), username, changeKey, this.sm.getSiteName());
        if (!MailUtil.sendMail((String)email, (String)subject, (String)content, null, (SettingManager)this.sm, (String)adminEmail, (String)"").booleanValue()) {
            return new ResponseEntity((Object)String.format(messages.getString("mail_error"), new Object[0]), HttpStatus.PRECONDITION_FAILED);
        }
        return new ResponseEntity((Object)String.format(messages.getString("user_password_sent"), XslUtil.encodeForJavaScript((String)username)), HttpStatus.CREATED);
    }
}

