/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.template;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.xalan.xsltc.runtime.AttributeList;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.records.formatters.groovy.template.TNodeTextContent;
import org.fao.geonet.api.records.formatters.groovy.template.TRenderContext;
import org.fao.geonet.api.records.formatters.groovy.template.TextBlock;
import org.fao.geonet.api.records.formatters.groovy.template.TextContentParser;
import org.xml.sax.Attributes;

public abstract class TNode {
    protected static final Attributes EMPTY_ATTRIBUTES = new AttributeList();
    protected final TextBlock attributes;
    protected final TextBlock end;
    protected final String qName;
    protected final SystemInfo info;
    protected final TextContentParser textContentParser;
    private List<TNode> children = Lists.newArrayList();
    private long unparsedSize;

    public TNode(SystemInfo info, TextContentParser textContentParser, String qName, Attributes attributes) throws IOException {
        this.info = info;
        this.qName = qName;
        StringBuilder start = new StringBuilder();
        StringBuilder end = new StringBuilder();
        this.renderAttributes(attributes, start);
        end.append("</").append(qName).append(">");
        this.textContentParser = textContentParser;
        this.attributes = textContentParser.parse(start.toString());
        this.end = textContentParser.parse(end.toString());
    }

    public List<TNode> getChildren() {
        return this.children;
    }

    public void renderAttributes(Attributes attributes, Appendable appendable) throws IOException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            appendable.append(" ").append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append("\"");
        }
    }

    public void render(TRenderContext context) throws IOException {
        Optional<String> reasonToNotRender = this.canRender(context);
        if (reasonToNotRender.isPresent()) {
            this.addCannontRenderComment(context, reasonToNotRender);
        } else {
            Attributes customAttributes;
            context.append("<").append(this.qName);
            if (this.writeAttributes(context)) {
                this.attributes.render(context);
            }
            if ((customAttributes = this.customAttributes(context)) != null) {
                this.renderAttributes(customAttributes, context);
            }
            context.append(">");
            if (this.writeChildren(context)) {
                for (TNode child : this.children) {
                    this.appendCustomChildData(context, child);
                    child.render(context);
                }
            }
            this.end.render(context);
        }
    }

    public void addCannontRenderComment(TRenderContext context, Optional<String> reasonToNotRender) throws IOException {
        if (SystemInfo.getInfo((SystemInfo)this.info).isDevMode()) {
            context.append("<!-- ").append((CharSequence)reasonToNotRender.get()).append(" -->");
        }
    }

    protected boolean writeChildren(TRenderContext context) {
        return true;
    }

    protected boolean writeAttributes(TRenderContext context) {
        return true;
    }

    protected void appendCustomChildData(TRenderContext context, TNode nextChild) throws IOException {
    }

    protected Attributes customAttributes(TRenderContext context) {
        return null;
    }

    protected abstract Optional<String> canRender(TRenderContext var1);

    public void addChild(TNode node) {
        this.children.add(node);
    }

    public void setTextContent(String text) throws IOException {
        if (text.isEmpty()) {
            return;
        }
        this.addChild(new TNodeTextContent(this.info, this.textContentParser, this.textContentParser.parse(text)));
    }

    public long getUnparsedSize() {
        return this.unparsedSize;
    }

    public void setUnparsedSize(long unparsedSize) {
        this.unparsedSize = unparsedSize;
    }
}

