/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.extent;

import com.google.common.base.Optional;
import com.vividsolutions.jts.geom.Envelope;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.extent.MapRenderer;
import org.fao.geonet.api.regions.MetadataRegionDAO;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.region.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="recordExtent")
@ReadWriteController
public class MetadataExtentApi {
    public static final String MAP_SRS_PARAM = "mapsrs";
    public static final String GEOM_SRS_PARAM = "geomsrs";
    public static final String WIDTH_PARAM = "width";
    public static final String GEOM_PARAM = "geom";
    public static final String GEOM_TYPE_PARAM = "geomtype";
    public static final String HEIGHT_PARAM = "height";
    public static final String BACKGROUND_PARAM = "background";
    public static final String SETTING_BACKGROUND = "settings";
    @Autowired
    IMetadataManager metadataManager;
    @Autowired
    private ServiceManager serviceManager;
    @Value(value="${metadata.extentApi.disableFullUrlBackgroundMapServices:true}")
    private boolean disableFullUrlBackgroundMapServices;

    public static AffineTransform worldToScreenTransform(Envelope mapExtent, Dimension screenSize) {
        return MapRenderer.worldToScreenTransform(mapExtent, screenSize);
    }

    @ApiOperation(value="Get record extents as image", notes="A rendering of the geometry as a png. If no background is specified the image will be transparent. In getMap the envelope of the geometry is calculated then it is expanded by a factor.  That factor is the size of the map.  This allows the map to be slightly bigger than the geometry allowing some context to be shown. This parameter allows different factors to be chosen per scale level.\nProportion is the proportion of the world that the geometry covers (bounds of WGS84)/(bounds of geometry in WGS84)\n\nNamed backgrounds allow the background parameter to be a simple key and the complete URL will be looked up from this list of named backgrounds\n", nickname="getRecordExtents")
    @RequestMapping(value={"/{metadataUuid}/extents.png"}, produces={"image/png"}, method={RequestMethod.GET})
    public HttpEntity<byte[]> getRecordExtentAsImage(@ApiParam(value="Record UUID.", required=true) @PathVariable(value="metadataUuid") String metadataUuid, @RequestParam(value="mapsrs", defaultValue="EPSG:4326") String srs, @ApiParam(value="(optional) width of the image that is created. Only one of width and height are permitted") @RequestParam(value="width", required=false, defaultValue="300") Integer width, @ApiParam(value="(optional) height of the image that is created. Only one of width and height are permitted") @RequestParam(value="height", required=false) Integer height, @ApiParam(value="(optional) URL for loading a background image for regions or a key that references the namedBackgrounds (configured in config-spring-geonetwork.xml). A WMS Getmap request is the typical example. The URL must be parameterized with the following parameters: minx, maxx, miny, maxy, width, height") @RequestParam(value="background", required=false, defaultValue="settings") String background, @ApiParam(value="(optional) Fill color with format RED,GREEN,BLUE,ALPHA") @RequestParam(value="", required=false, defaultValue="0,0,0,50") String fillColor, @ApiParam(value="(optional) Stroke color with format RED,GREEN,BLUE,ALPHA") @RequestParam(value="", required=false, defaultValue="0,0,0,255") String strokeColor, @ApiIgnore NativeWebRequest nativeWebRequest, @ApiIgnore HttpServletRequest request) throws Exception {
        Long lastModified;
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        ServiceContext context = ApiUtils.createServiceContext(request);
        if (width != null && height != null) {
            throw new BadParameterEx(WIDTH_PARAM, (Object)"Only one of width and height can be defined currently.  Future versions may support this but it is not supported at the moment");
        }
        if (width == null && height == null) {
            throw new BadParameterEx(WIDTH_PARAM, (Object)"One of width or height parameters must be included in the request");
        }
        if (background != null && background.startsWith("http") && this.disableFullUrlBackgroundMapServices) {
            throw new BadParameterEx(BACKGROUND_PARAM, (Object)"Background layers from provided are not supported, use a preconfigured background layers map service.");
        }
        String outputFileName = metadataUuid + "-extent.png";
        String regionId = "metadata:@id" + metadata.getId();
        MetadataRegionDAO dao = (MetadataRegionDAO)((Object)ApplicationContextHolder.get().getBean(MetadataRegionDAO.class));
        Request searchRequest = dao.createSearchRequest(context);
        searchRequest.id(regionId);
        Optional lastModifiedOption = searchRequest.getLastModified();
        if (lastModifiedOption.isPresent() && (lastModified = (Long)lastModifiedOption.get()) != null && nativeWebRequest.checkNotModified(lastModified.longValue())) {
            return null;
        }
        MapRenderer renderer = new MapRenderer(context);
        BufferedImage image = renderer.render(regionId, srs, width, height, background, null, null, null, fillColor, strokeColor);
        if (image == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "png", out);
            HttpHeaders headers = new HttpHeaders();
            headers.add((Object)"Content-Disposition", (Object)("inline; filename=\"" + outputFileName + "\""));
            headers.add((Object)"Cache-Control", (Object)"no-cache");
            headers.add((Object)"Content-Type", (Object)"image/png");
            HttpEntity httpEntity = new HttpEntity((Object)out.toByteArray(), (MultiValueMap)headers);
            return httpEntity;
        }
    }
}

