/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.editing.AjaxEditUtils;
import org.fao.geonet.api.records.formatters.XsltFormatter;
import org.fao.geonet.api.records.model.validation.Report;
import org.fao.geonet.api.records.model.validation.Reports;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.MetadataValidationId;
import org.fao.geonet.domain.MetadataValidationStatus;
import org.fao.geonet.domain.Schematron;
import org.fao.geonet.events.history.RecordValidationTriggeredEvent;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.SchematronRepository;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="recordValidate")
@PreAuthorize(value="hasRole('Editor')")
@ReadWriteController
public class MetadataValidateApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    MetadataValidationRepository metadataValidationRepository;
    public static final String EL_ACTIVE_PATTERN = "active-pattern";
    public static final String EL_FIRED_RULE = "fired-rule";
    public static final String EL_FAILED_ASSERT = "failed-assert";
    public static final String EL_SUCCESS_REPORT = "successful-report";
    public static final String ATT_CONTEXT = "context";
    public static final String DEFAULT_CONTEXT = "??";

    @ApiOperation(value="Validate a record", notes="User MUST be able to edit the record to validate it. FIXME : id MUST be the id of the current metadata record in session ?", nickname="validate")
    @RequestMapping(value={"/{metadataUuid}/validate/internal"}, method={RequestMethod.PUT}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=201, message="Validation report."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public Reports validateRecord(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Validation status. Should be provided only in case of SUBTEMPLATE validation. If provided for another type, throw a BadParameter Exception", required=false) @RequestParam(required=false) Boolean isvalid, HttpServletRequest request, @ApiParam(hidden=true) @ApiIgnore HttpSession session) throws Exception {
        Element errorReport;
        boolean validSet;
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        DataManager dataManager = (DataManager)appContext.getBean(DataManager.class);
        String id = String.valueOf(metadata.getId());
        String schemaName = dataManager.getMetadataSchema(id);
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        boolean isSubtemplate = metadata.getDataInfo().getType() == MetadataType.SUB_TEMPLATE;
        boolean bl = validSet = isvalid != null;
        if (!isSubtemplate && validSet) {
            throw new BadParameterEx("Parameter isvalid can't be set if it is not a Subtemplate. You cannot force validation of a metadata or a template.");
        }
        if (isSubtemplate && !validSet) {
            throw new BadParameterEx("Parameter isvalid MUST be set for subtemplate.");
        }
        if (isSubtemplate) {
            MetadataValidation metadataValidation = new MetadataValidation().setId(new MetadataValidationId(metadata.getId(), "subtemplate")).setStatus(isvalid != false ? MetadataValidationStatus.VALID : MetadataValidationStatus.INVALID).setRequired(Boolean.valueOf(true)).setNumTests(0).setNumFailures(0);
            this.metadataValidationRepository.save((Object)metadataValidation);
            dataManager.indexMetadata("" + metadata.getId(), true, null);
            new RecordValidationTriggeredEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(ApiUtils.getUserSession(request.getSession()).getUserIdAsInt()), metadataValidation.getStatus().getCode()).publish((ApplicationContext)appContext);
            return new Reports();
        }
        try {
            errorReport = new AjaxEditUtils(context).validateMetadataEmbedded(ApiUtils.getUserSession(session), id, locale.getISO3Language());
        }
        catch (NullPointerException e) {
            throw new BadParameterEx(String.format("To validate a record, the record MUST be in edition.", new Object[0]), (Object)metadataUuid);
        }
        MetadataValidateApi.restructureReportToHavePatternRuleHierarchy(errorReport);
        Element elResp = new Element("root");
        elResp.addContent((Content)new Element("id").setText(id));
        elResp.addContent((Content)new Element("language").setText(locale.getISO3Language()));
        elResp.addContent((Content)new Element("schema").setText(dataManager.getMetadataSchema(id)));
        elResp.addContent((Content)errorReport);
        Element schematronTranslations = new Element("schematronTranslations");
        SchematronRepository schematronRepository = (SchematronRepository)context.getBean(SchematronRepository.class);
        List schematrons = schematronRepository.findAllBySchemaName(schemaName);
        MetadataSchema metadataSchema = dataManager.getSchema(schemaName);
        Path schemaDir = metadataSchema.getSchemaDir();
        SAXBuilder builder = new SAXBuilder();
        for (Schematron schematron : schematrons) {
            Document document;
            String rule = schematron.getRuleName();
            Path file = schemaDir.resolve("loc").resolve(locale.getISO3Language()).resolve(rule + ".xml");
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            try (InputStream in = IO.newInputStream((Path)file);){
                document = builder.build(in);
            }
            Element element = document.getRootElement();
            Element s = new Element(rule);
            element.detach();
            s.addContent((Content)element);
            schematronTranslations.addContent((Content)s);
        }
        elResp.addContent((Content)schematronTranslations);
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)context.getBean(GeonetworkDataDirectory.class);
        Path validateXsl = dataDirectory.getWebappDir().resolve("xslt/services/metadata/validate.xsl");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("rootTag", "reports");
        List<Element> elementList = XsltFormatter.getSchemaLocalization(metadata.getDataInfo().getSchemaId(), locale.getISO3Language());
        for (Element e : elementList) {
            elResp.addContent((Content)e);
        }
        Element transform = Xml.transform((Element)elResp, (Path)validateXsl, params);
        Reports response = (Reports)Xml.unmarshall((Element)transform, Reports.class);
        List<Report> reports = response.getReport();
        if (reports != null) {
            int value = 1;
            for (Report report : reports) {
                if (report.getSuccess().equals(report.getTotal())) continue;
                value = 0;
            }
            new RecordValidationTriggeredEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(ApiUtils.getUserSession(request.getSession()).getUserIdAsInt()), Integer.toString(value)).publish((ApplicationContext)appContext);
        }
        return response;
    }

    public static void restructureReportToHavePatternRuleHierarchy(Element errorReport) {
        Iterator patternFilter = errorReport.getDescendants((Filter)new ElementFilter(EL_ACTIVE_PATTERN, Geonet.Namespaces.SVRL));
        ArrayList patterns = Lists.newArrayList((Iterator)patternFilter);
        for (Element pattern : patterns) {
            Element parentElement = pattern.getParentElement();
            Element currentRule = null;
            List children = parentElement.getChildren();
            int index = children.indexOf(pattern) + 1;
            while (index < children.size() && !((Element)children.get(index)).getName().equals(EL_ACTIVE_PATTERN)) {
                Element next = (Element)children.get(index);
                if (EL_FIRED_RULE.equals(next.getName())) {
                    currentRule = next;
                    next.detach();
                    pattern.addContent((Content)next);
                    continue;
                }
                if (currentRule == null) {
                    currentRule = new Element(EL_FIRED_RULE, Geonet.Namespaces.SVRL).setAttribute(ATT_CONTEXT, DEFAULT_CONTEXT);
                    pattern.addContent((Content)currentRule);
                }
                next.detach();
                currentRule.addContent((Content)next);
            }
            if (!pattern.getChildren().isEmpty()) continue;
            pattern.detach();
        }
    }
}

