/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import java.util.List;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.config.layout.HeaderFooter;
import org.mapfish.print.utils.PJsonObject;

public class Page {
    protected List<Block> items;
    private String pageSize = "A4";
    private HeaderFooter header = null;
    private HeaderFooter footer = null;
    private String marginLeft = "40";
    private String marginRight = "40";
    private String marginTop = "20";
    private String marginBottom = "20";
    private String backgroundPdf = null;
    private boolean landscape = false;
    private String condition = null;

    public void render(PJsonObject params, RenderingContext context) throws DocumentException {
        if (this.isVisible(context, params)) {
            final Document doc = context.getDocument();
            context.setCurrentPageParams(params);
            doc.setPageSize(this.getPageSizeRect(context, params));
            doc.setMargins((float)this.getMarginLeft(context, params), (float)this.getMarginRight(context, params), (float)(this.getMarginTop(context, params) + (this.header != null ? this.header.getHeight() : 0)), (float)(this.getMarginBottom(context, params) + (this.footer != null ? this.footer.getHeight() : 0)));
            context.getCustomBlocks().setBackgroundPdf(PDFUtils.evalString(context, params, this.backgroundPdf, null));
            if (doc.isOpen()) {
                doc.newPage();
            } else {
                doc.open();
            }
            context.getCustomBlocks().setHeader(this.header, params);
            context.getCustomBlocks().setFooter(this.footer, params);
            for (int i = 0; i < this.items.size(); ++i) {
                Block block = this.items.get(i);
                if (!block.isVisible(context, params)) continue;
                block.render(params, new Block.PdfElement(){

                    @Override
                    public void add(Element element) throws DocumentException {
                        doc.add(element);
                    }
                }, context);
            }
        }
    }

    public Rectangle getPageSizeRect(RenderingContext context, PJsonObject params) {
        Rectangle result = PageSize.getRectangle((String)this.getPageSize(context, params));
        if (this.landscape) {
            return result.rotate();
        }
        return result;
    }

    protected boolean isVisible(RenderingContext context, PJsonObject params) {
        return Block.testCondition(context, params, this.condition);
    }

    public void setCondition(String condition) {
        this.condition = condition;
        if (condition != null && !Block.CONDITION_REGEXP.matcher(condition).matches()) {
            throw new InvalidValueException("condition", condition);
        }
    }

    public List<Block> getItems() {
        return this.items;
    }

    public void setItems(List<Block> items) {
        this.items = items;
    }

    public String getPageSize(RenderingContext context, PJsonObject params) {
        return PDFUtils.evalString(context, params, this.pageSize, null);
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
        try {
            PageSize.getRectangle((String)pageSize);
        }
        catch (RuntimeException e) {
            throw new InvalidValueException("pageSize", pageSize);
        }
    }

    public void setHeader(HeaderFooter header) {
        this.header = header;
    }

    public void setFooter(HeaderFooter footer) {
        this.footer = footer;
    }

    public int getMarginLeft(RenderingContext context, PJsonObject params) {
        return Integer.parseInt(PDFUtils.evalString(context, params, this.marginLeft, null));
    }

    public int getMarginRight(RenderingContext context, PJsonObject params) {
        return Integer.parseInt(PDFUtils.evalString(context, params, this.marginRight, null));
    }

    public int getMarginTop(RenderingContext context, PJsonObject params) {
        return Integer.parseInt(PDFUtils.evalString(context, params, this.marginTop, null));
    }

    public int getMarginBottom(RenderingContext context, PJsonObject params) {
        return Integer.parseInt(PDFUtils.evalString(context, params, this.marginBottom, null));
    }

    public void setMarginLeft(String marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setMarginRight(String marginRight) {
        this.marginRight = marginRight;
    }

    public void setMarginTop(String marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginBottom(String marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setBackgroundPdf(String backgroundPdf) {
        this.backgroundPdf = backgroundPdf;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    public void validate() {
        if (this.items == null) {
            throw new InvalidValueException("items", "null");
        }
        if (this.items.size() < 1) {
            throw new InvalidValueException("items", "[]");
        }
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).validate();
        }
        if (this.header != null) {
            this.header.validate();
        }
        if (this.footer != null) {
            this.footer.validate();
        }
    }
}

