/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.PdfPTable;
import java.util.ArrayList;
import org.mapfish.print.InvalidJsonValueException;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.config.layout.ColumnDef;
import org.mapfish.print.config.layout.ColumnDefs;
import org.mapfish.print.config.layout.TableConfig;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class AttributesBlock
extends Block {
    private String source;
    private ColumnDefs columnDefs = new ColumnDefs();
    private TableConfig tableConfig = null;

    @Override
    public void render(PJsonObject params, Block.PdfElement target, RenderingContext context) throws DocumentException {
        PJsonObject sourceJson = params.optJSONObject(this.source);
        if (sourceJson == null) {
            sourceJson = context.getGlobalParams().optJSONObject(this.source);
        }
        if (sourceJson == null || sourceJson.size() == 0) {
            return;
        }
        PJsonArray data = sourceJson.optJSONArray("data");
        PJsonArray firstLine = sourceJson.getJSONArray("columns");
        ArrayList<Integer> columnWidths = ((ColumnDef)this.columnDefs.values().iterator().next()).getColumnWeight() > 0 ? new ArrayList<Integer>() : null;
        int nbCols = 0;
        for (int colNum = 0; colNum < firstLine.size(); ++colNum) {
            String name = firstLine.getString(colNum);
            ColumnDef colDef = (ColumnDef)this.columnDefs.get(name);
            if (colDef != null && colDef.isVisible(context, params)) {
                ++nbCols;
                if (columnWidths == null) continue;
                columnWidths.add(colDef.getColumnWeight());
                continue;
            }
            context.addError(new InvalidJsonValueException(firstLine, name, "Unknown column"));
        }
        PdfPTable table = new PdfPTable(nbCols);
        table.setWidthPercentage(100.0f);
        if (columnWidths != null) {
            int[] array = new int[columnWidths.size()];
            for (int i = 0; i < columnWidths.size(); ++i) {
                array[i] = (Integer)columnWidths.get(i);
            }
            table.setWidths(array);
        }
        int nbRows = data.size() + 1;
        for (int colNum = 0; colNum < firstLine.size(); ++colNum) {
            String name = firstLine.getString(colNum);
            ColumnDef colDef = (ColumnDef)this.columnDefs.get(name);
            if (colDef == null || !colDef.isVisible(context, params)) continue;
            table.addCell(colDef.createHeaderPdfCell(params, context, colNum, nbRows, nbCols, this.tableConfig));
        }
        table.setHeaderRows(1);
        for (int rowNum = 0; rowNum < data.size(); ++rowNum) {
            PJsonObject row = data.getJSONObject(rowNum);
            int realColNum = 0;
            for (int colNum = 0; colNum < firstLine.size(); ++colNum) {
                String name = firstLine.getString(colNum);
                ColumnDef colDef = (ColumnDef)this.columnDefs.get(name);
                if (colDef == null || !colDef.isVisible(context, params)) continue;
                table.addCell(colDef.createContentPdfCell(row, context, rowNum + 1, realColNum, nbRows, nbCols, this.tableConfig));
                ++realColNum;
            }
        }
        table.setSpacingAfter((float)this.spacingAfter);
        target.add((Element)table);
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setColumnDefs(ColumnDefs columnDefs) {
        this.columnDefs = columnDefs;
    }

    public void setTableConfig(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.source == null) {
            throw new InvalidValueException("source", "null");
        }
        if (this.columnDefs == null) {
            throw new InvalidValueException("columnDefs", "null");
        }
        this.columnDefs.validate();
        if (this.tableConfig != null) {
            this.tableConfig.validate();
        }
    }
}

