/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc16.SVNUpdateClient16;
import org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbDir;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbCollectTargets;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbCreateSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbInsertTarget;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnWcDbShared {
    public static void begingReadTransaction(SVNWCDbRoot root) throws SVNException {
        root.getSDb().beginTransaction(SqlJetTransactionMode.READ_ONLY);
    }

    public static void begingWriteTransaction(SVNWCDbRoot root) throws SVNException {
        root.getSDb().beginTransaction(SqlJetTransactionMode.WRITE);
    }

    public static void commitTransaction(SVNWCDbRoot root) throws SVNException {
        root.getSDb().commit();
    }

    public static void rollbackTransaction(SVNWCDbRoot root) throws SVNException {
        root.getSDb().rollback();
    }

    protected static void nodeNotFound(File absolutePath) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)absolutePath);
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean doesNodeExists(SVNWCDbRoot wcDbRoot, File relpath) throws SVNException {
        SVNSqlJetStatement stmt = null;
        try {
            stmt = wcDbRoot.getSDb().getStatement(SVNWCDbStatements.DOES_NODE_EXIST);
            stmt.bindf("is", wcDbRoot.getWcId(), relpath);
            boolean bl = stmt.next();
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.reset();
            }
        }
    }

    protected static void nodeNotFound(SVNWCDbRoot root, File relPath) throws SVNException {
        SvnWcDbShared.nodeNotFound(root.getAbsPath(relPath));
    }

    protected static void sqliteError(SqlJetException e) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void collectTargets(SVNWCDbRoot root, File relpath, SVNDepth depth, Collection<String> changelists) throws SVNException {
        SVNSqlJetStatement stmt;
        block13: {
            SVNSqlJetDb tmpDb = root.getSDb().getTemporaryDb();
            stmt = null;
            try {
                stmt = new SVNWCDbCreateSchema(tmpDb, SVNWCDbCreateSchema.TARGETS_LIST, -1);
                try {
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
                stmt = new SVNWCDbInsertTarget(tmpDb, new SVNWCDbCollectTargets(root.getSDb(), root.getWcId(), relpath, depth, changelists));
                try {
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
                if (depth != SVNDepth.FILES && depth != SVNDepth.IMMEDIATES) break block13;
                stmt = new SVNWCDbInsertTarget(tmpDb, new SVNWCDbCollectTargets(root.getSDb(), root.getWcId(), relpath, SVNDepth.EMPTY, changelists));
                try {
                    stmt.done();
                }
                finally {
                    stmt.reset();
                }
            }
            catch (Throwable throwable) {
                SvnWcDbStatementUtil.reset(stmt);
                throw throwable;
            }
        }
        SvnWcDbStatementUtil.reset(stmt);
    }

    public static Structure<StructureFields.AdditionInfo> scanAddition(SVNWCDb db, File localAbsPath) throws SVNException {
        SVNWCDb.ReposInfo reposInfo;
        SVNWCDb.DirParsedInfo parsed = db.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        Structure<StructureFields.AdditionInfo> additionInfo = SvnWcDbShared.scanAddition(pdh.getWCRoot(), localRelpath, new StructureFields.AdditionInfo[0]);
        if (additionInfo.hasField(StructureFields.AdditionInfo.reposRootUrl)) {
            reposInfo = db.fetchReposInfo(pdh.getWCRoot().getSDb(), additionInfo.lng(StructureFields.AdditionInfo.reposId));
            additionInfo.set(StructureFields.AdditionInfo.reposRootUrl, SVNURL.parseURIEncoded(reposInfo.reposRootUrl));
            additionInfo.set(StructureFields.AdditionInfo.reposUuid, reposInfo.reposUuid);
        }
        if (additionInfo.hasField(StructureFields.AdditionInfo.originalRootUrl) && additionInfo.lng(StructureFields.AdditionInfo.originalReposId) >= 0L) {
            reposInfo = db.fetchReposInfo(pdh.getWCRoot().getSDb(), additionInfo.lng(StructureFields.AdditionInfo.originalReposId));
            additionInfo.set(StructureFields.AdditionInfo.originalRootUrl, SVNURL.parseURIEncoded(reposInfo.reposRootUrl));
            additionInfo.set(StructureFields.AdditionInfo.originalUuid, reposInfo.reposUuid);
        }
        return additionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Structure<StructureFields.AdditionInfo> scanAddition(SVNWCDbRoot root, File localRelpath, StructureFields.AdditionInfo ... fields) throws SVNException {
        Object info = Structure.obtain(StructureFields.AdditionInfo.class, fields);
        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalRevision, -1L);
        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalReposId, -1L);
        SvnWcDbShared.begingReadTransaction(root);
        File buildRelpath = SVNFileUtil.createFilePath("");
        File currentRelpath = localRelpath;
        SVNSqlJetStatement stmt = null;
        try {
            File reposPrefixPath = SVNFileUtil.createFilePath("");
            stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
            stmt.bindf("is", root.getWcId(), localRelpath);
            if (!stmt.next()) {
                SvnWcDbStatementUtil.reset(stmt);
                SvnWcDbShared.nodeNotFound(root, localRelpath);
            }
            ISVNWCDb.SVNWCDbStatus presence = SvnWcDbStatementUtil.getColumnPresence(stmt);
            long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
            if (opDepth == 0L || presence != ISVNWCDb.SVNWCDbStatus.Normal && presence != ISVNWCDb.SVNWCDbStatus.Incomplete) {
                SvnWcDbStatementUtil.reset(stmt);
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Expected node ''{0}'' to be added.", (Object)root.getAbsPath(localRelpath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalRevision, SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision));
            ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.status, (Object)ISVNWCDb.SVNWCDbStatus.Added);
            currentRelpath = localRelpath;
            int i = SVNWCUtils.relpathDepth(localRelpath);
            while ((long)i > opDepth) {
                reposPrefixPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(currentRelpath)), reposPrefixPath);
                currentRelpath = SVNFileUtil.getFileDir(currentRelpath);
                --i;
            }
            ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.opRootRelPath, currentRelpath);
            ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.opRootAbsPath, root.getAbsPath(currentRelpath));
            if (((Structure)info).hasField(StructureFields.AdditionInfo.originalReposRelPath) || ((Structure)info).hasField(StructureFields.AdditionInfo.originalRootUrl) || ((Structure)info).hasField(StructureFields.AdditionInfo.originalUuid) || ((Structure)info).hasField(StructureFields.AdditionInfo.originalRevision) && ((Structure)info).lng((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalRevision) == -1L || ((Structure)info).hasField(StructureFields.AdditionInfo.status)) {
                if (!localRelpath.equals(currentRelpath)) {
                    SvnWcDbStatementUtil.reset(stmt);
                    stmt.bindf("is", root.getWcId(), currentRelpath);
                    if (!stmt.next()) {
                        SvnWcDbStatementUtil.reset(stmt);
                        SvnWcDbShared.nodeNotFound(root, currentRelpath);
                    }
                    if (((Structure)info).hasField(StructureFields.AdditionInfo.originalRevision) && ((Structure)info).lng((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalRevision) == -1L) {
                        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalRevision, SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision));
                    }
                }
                ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalReposRelPath, SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.repos_path));
                if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.repos_id) && (((Structure)info).hasField(StructureFields.AdditionInfo.status) || ((Structure)info).hasField(StructureFields.AdditionInfo.originalReposId))) {
                    ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalReposId, SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id));
                    if (SvnWcDbStatementUtil.getColumnBoolean(stmt, SVNWCDbSchema.NODES__Fields.moved_here)) {
                        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.status, (Object)ISVNWCDb.SVNWCDbStatus.MovedHere);
                    } else {
                        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.status, (Object)ISVNWCDb.SVNWCDbStatus.Copied);
                    }
                }
            }
            block3: while (true) {
                SvnWcDbStatementUtil.reset(stmt);
                reposPrefixPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(currentRelpath)), reposPrefixPath);
                currentRelpath = SVNFileUtil.getFileDir(currentRelpath);
                stmt.bindf("is", root.getWcId(), currentRelpath);
                if (!stmt.next()) break;
                opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                i = SVNWCUtils.relpathDepth(currentRelpath);
                while (true) {
                    if ((long)i <= opDepth) continue block3;
                    reposPrefixPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(currentRelpath)), reposPrefixPath);
                    currentRelpath = SVNFileUtil.getFileDir(currentRelpath);
                    --i;
                }
                break;
            }
            SvnWcDbStatementUtil.reset(stmt);
            buildRelpath = reposPrefixPath;
            if (((Structure)info).hasField(StructureFields.AdditionInfo.reposRelPath) || ((Structure)info).hasField(StructureFields.AdditionInfo.reposId)) {
                Structure<StructureFields.NodeInfo> baseInfo = SvnWcDbShared.getDepthInfo(root, currentRelpath, 0L, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposId);
                ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.reposRelPath, SVNFileUtil.createFilePath((File)baseInfo.get(StructureFields.NodeInfo.reposRelPath), buildRelpath));
                ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.reposId, baseInfo.lng(StructureFields.NodeInfo.reposId));
                baseInfo.release();
            }
        }
        catch (Throwable throwable) {
            SvnWcDbStatementUtil.reset(stmt);
            SvnWcDbShared.commitTransaction(root);
            throw throwable;
        }
        SvnWcDbStatementUtil.reset(stmt);
        SvnWcDbShared.commitTransaction(root);
        return info;
    }

    public static Structure<StructureFields.DeletionInfo> scanDeletion(SVNWCDb db, File localAbsPath) throws SVNException {
        SVNWCDb.DirParsedInfo parsed = db.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        return SvnWcDbShared.scanDeletion(pdh.getWCRoot(), localRelpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Structure<StructureFields.DeletionInfo> scanDeletion(SVNWCDbRoot root, File localRelpath) throws SVNException {
        Object info = Structure.obtain(StructureFields.DeletionInfo.class);
        ISVNWCDb.SVNWCDbStatus childPresence = ISVNWCDb.SVNWCDbStatus.BaseDeleted;
        boolean childHasBase = false;
        boolean foundMovedTo = false;
        long opDepth = 0L;
        long localOpDepth = 0L;
        File currentRelPath = localRelpath;
        File childRelpath = null;
        SvnWcDbShared.begingReadTransaction(root);
        SVNSqlJetStatement stmt = null;
        try {
            while (true) {
                stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_DELETION_INFO);
                stmt.bindf("is", root.getWcId(), SVNFileUtil.getFilePath(currentRelPath));
                if (!stmt.next()) {
                    try {
                        if (currentRelPath == localRelpath) {
                            SvnWcDbShared.nodeNotFound(root, localRelpath);
                        }
                        if (!childHasBase) return info;
                        ((Structure)info).set((StructureFields.DeletionInfo)StructureFields.DeletionInfo.baseDelRelPath, childRelpath);
                        return info;
                    }
                    finally {
                        SvnWcDbStatementUtil.reset(stmt);
                    }
                }
                SVNSqlJetStatement baseStmt = null;
                try {
                    ISVNWCDb.SVNWCDbStatus workPresence = SvnWcDbStatementUtil.getColumnPresence(stmt);
                    if (currentRelPath.equals(localRelpath) && workPresence != ISVNWCDb.SVNWCDbStatus.NotPresent && workPresence != ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Expected node ''{0}'' to be deleted.", (Object)root.getAbsPath(localRelpath));
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    assert (workPresence == ISVNWCDb.SVNWCDbStatus.Normal || workPresence == ISVNWCDb.SVNWCDbStatus.NotPresent || workPresence == ISVNWCDb.SVNWCDbStatus.BaseDeleted || workPresence == ISVNWCDb.SVNWCDbStatus.Incomplete);
                    baseStmt = stmt.getJoinedStatement("nodes_base");
                    boolean haveBase = false;
                    boolean bl = haveBase = baseStmt != null && baseStmt.next() && !SvnWcDbStatementUtil.isColumnNull(baseStmt, SVNWCDbSchema.NODES__Fields.presence);
                    if (haveBase) {
                        ISVNWCDb.SVNWCDbStatus basePresence = SvnWcDbStatementUtil.getColumnPresence(baseStmt);
                        assert (basePresence == ISVNWCDb.SVNWCDbStatus.Normal || basePresence == ISVNWCDb.SVNWCDbStatus.NotPresent || basePresence == ISVNWCDb.SVNWCDbStatus.Incomplete);
                        if (basePresence == ISVNWCDb.SVNWCDbStatus.Incomplete) {
                            basePresence = ISVNWCDb.SVNWCDbStatus.Normal;
                        }
                    }
                    if (!foundMovedTo && !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.moved_to)) {
                        foundMovedTo = true;
                        ((Structure)info).set((StructureFields.DeletionInfo)StructureFields.DeletionInfo.baseDelRelPath, currentRelPath);
                        ((Structure)info).set((StructureFields.DeletionInfo)StructureFields.DeletionInfo.movedToRelPath, SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.moved_to));
                    }
                    opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                    if (currentRelPath.equals(localRelpath)) {
                        localOpDepth = opDepth;
                    }
                    if (!((Structure)info).hasValue(StructureFields.DeletionInfo.workDelRelPath) && (opDepth < localOpDepth && opDepth > 0L || childPresence == ISVNWCDb.SVNWCDbStatus.NotPresent)) {
                        ((Structure)info).set((StructureFields.DeletionInfo)StructureFields.DeletionInfo.workDelRelPath, childRelpath);
                        ((Structure)info).set((StructureFields.DeletionInfo)StructureFields.DeletionInfo.workDelAbsPath, root.getAbsPath(childRelpath));
                    }
                    childRelpath = currentRelPath;
                    childPresence = workPresence;
                    childHasBase = haveBase;
                    currentRelPath = SVNFileUtil.getFileDir(currentRelPath);
                }
                catch (Throwable throwable) {
                    SvnWcDbStatementUtil.reset(stmt);
                    SvnWcDbStatementUtil.reset(baseStmt);
                    throw throwable;
                }
                SvnWcDbStatementUtil.reset(stmt);
                SvnWcDbStatementUtil.reset(baseStmt);
            }
        }
        finally {
            SvnWcDbShared.commitTransaction(root);
            SvnWcDbStatementUtil.reset(stmt);
        }
    }

    public static Structure<StructureFields.NodeInfo> getBaseInfo(SVNWCDbRoot wcroot, File localRelPath, StructureFields.NodeInfo ... fields) throws SVNException {
        return SvnWcDbShared.getDepthInfo(wcroot, localRelPath, 0L, fields);
    }

    public static Structure<StructureFields.NodeInfo> getBaseInfo(SVNWCDb db, File localAbsPath, StructureFields.NodeInfo ... fields) throws SVNException {
        SVNWCDb.DirParsedInfo parsed = db.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        return SvnWcDbShared.getDepthInfo(pdh.getWCRoot(), localRelpath, 0L, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Structure<StructureFields.NodeInfo> getDepthInfo(SVNWCDbRoot wcroot, File localRelPath, long opDepth, StructureFields.NodeInfo ... fields) throws SVNException {
        Object info;
        block33: {
            info = Structure.obtain(StructureFields.NodeInfo.class, fields);
            SVNSqlJetStatement stmt = wcroot.getSDb().getStatement(((Structure)info).hasField(StructureFields.NodeInfo.lock) ? SVNWCDbStatements.SELECT_BASE_NODE_WITH_LOCK : SVNWCDbStatements.SELECT_BASE_NODE);
            try {
                stmt.bindf("isi", wcroot.getWcId(), SVNFileUtil.getFilePath(localRelPath), opDepth);
                if (stmt.next()) {
                    ISVNWCDb.SVNWCDbKind node_kind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
                    if (((Structure)info).hasField(StructureFields.NodeInfo.kind)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.kind, (Object)node_kind);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.status)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.status, (Object)SvnWcDbStatementUtil.getColumnPresence(stmt));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.reposId)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposId, SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.revision)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.revision, SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.reposRelPath)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposRelPath, SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.repos_path));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.lock)) {
                        SVNSqlJetStatement lockStmt = stmt.getJoinedStatement(SVNWCDbSchema.LOCK);
                        ISVNWCDb.SVNWCDbLock lock = SvnWcDbStatementUtil.getLockFromColumns(lockStmt, SVNWCDbSchema.LOCK__Fields.lock_token, SVNWCDbSchema.LOCK__Fields.lock_owner, SVNWCDbSchema.LOCK__Fields.lock_comment, SVNWCDbSchema.LOCK__Fields.lock_date);
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.lock, lock);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.reposRootUrl) || ((Structure)info).hasField(StructureFields.NodeInfo.reposUuid)) {
                        if (SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.repos_id)) {
                            if (((Structure)info).hasField(StructureFields.NodeInfo.reposRootUrl)) {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposRootUrl, null);
                            }
                            if (((Structure)info).hasField(StructureFields.NodeInfo.reposUuid)) {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposUuid, null);
                            }
                        } else {
                            Structure<StructureFields.RepositoryInfo> repositoryInfo = wcroot.getDb().fetchRepositoryInfo(wcroot.getSDb(), SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id));
                            repositoryInfo.from(new StructureFields.RepositoryInfo[]{StructureFields.RepositoryInfo.reposRootUrl, StructureFields.RepositoryInfo.reposUuid}).into((Structure)info, new StructureFields.NodeInfo[]{StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid});
                            repositoryInfo.release();
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedRev)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedRev, SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.changed_revision));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedDate)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedDate, SvnWcDbStatementUtil.getColumnDate(stmt, SVNWCDbSchema.NODES__Fields.changed_date));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedAuthor)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedAuthor, SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.changed_author));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.depth)) {
                        if (node_kind != ISVNWCDb.SVNWCDbKind.Dir) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.depth, SVNDepth.UNKNOWN);
                        } else {
                            String depth_str = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.depth);
                            if (depth_str == null) {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.depth, SVNDepth.UNKNOWN);
                            } else {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.depth, SvnWcDbStatementUtil.parseDepth(depth_str));
                            }
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.checksum)) {
                        if (node_kind != ISVNWCDb.SVNWCDbKind.File) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.checksum, null);
                        } else {
                            try {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.checksum, SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.NODES__Fields.checksum));
                            }
                            catch (SVNException e) {
                                SVNErrorMessage err = SVNErrorMessage.create(e.getErrorMessage().getErrorCode(), "The node ''{0}'' has a corrupt checksum value.", (Object)wcroot.getAbsPath(localRelPath));
                                SVNErrorManager.error(err, SVNLogType.WC);
                            }
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.target)) {
                        if (node_kind != ISVNWCDb.SVNWCDbKind.Symlink) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.target, null);
                        } else {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.target, SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.symlink_target));
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.updateRoot)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.updateRoot, SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.file_external) != null);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.hadProps)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.hadProps, SvnWcDbStatementUtil.hasColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties));
                    }
                    break block33;
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)wcroot.getAbsPath(localRelPath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            finally {
                stmt.reset();
            }
        }
        return info;
    }

    protected static Structure<StructureFields.NodeInfo> readInfo(SVNWCDbRoot wcRoot, File localRelPath, StructureFields.NodeInfo ... fields) throws SVNException {
        return SvnWcDbShared.readInfo(wcRoot, localRelPath, false, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Structure<StructureFields.NodeInfo> readInfo(SVNWCDbRoot wcRoot, File localRelPath, boolean isAdditionMode, StructureFields.NodeInfo ... fields) throws SVNException {
        Object info;
        block65: {
            info = Structure.obtain(StructureFields.NodeInfo.class, fields);
            SVNSqlJetStatement stmtInfo = null;
            SVNSqlJetStatement stmtActual = null;
            try {
                stmtInfo = wcRoot.getSDb().getStatement(((Structure)info).hasField(StructureFields.NodeInfo.lock) ? SVNWCDbStatements.SELECT_NODE_INFO_WITH_LOCK : SVNWCDbStatements.SELECT_NODE_INFO);
                stmtInfo.bindf("is", wcRoot.getWcId(), localRelPath);
                boolean haveInfo = stmtInfo.next();
                boolean haveActual = false;
                if (((Structure)info).hasField(StructureFields.NodeInfo.changelist) || ((Structure)info).hasField(StructureFields.NodeInfo.conflicted) || ((Structure)info).hasField(StructureFields.NodeInfo.propsMod)) {
                    stmtActual = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
                    stmtActual.bindf("is", wcRoot.getWcId(), localRelPath);
                    haveActual = stmtActual.next();
                }
                if (haveInfo) {
                    long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.op_depth);
                    ISVNWCDb.SVNWCDbKind nodeKind = SvnWcDbStatementUtil.getColumnKind(stmtInfo, SVNWCDbSchema.NODES__Fields.kind);
                    if (((Structure)info).hasField(StructureFields.NodeInfo.status)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.status, (Object)SvnWcDbStatementUtil.getColumnPresence(stmtInfo));
                        if (opDepth != 0L) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.status, (Object)SVNWCDb.getWorkingStatus((ISVNWCDb.SVNWCDbStatus)((Object)((Structure)info).get((StructureFields.NodeInfo)StructureFields.NodeInfo.status))));
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.kind)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.kind, (Object)nodeKind);
                    }
                    ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposId, opDepth != 0L ? -1L : SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_id));
                    if (((Structure)info).hasField(StructureFields.NodeInfo.revision)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.revision, opDepth != 0L ? -1L : SvnWcDbStatementUtil.getColumnRevNum(stmtInfo, SVNWCDbSchema.NODES__Fields.revision));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.reposRelPath)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposRelPath, opDepth != 0L ? null : SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_path)));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedDate)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedDate, SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_date)));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedRev)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedRev, SvnWcDbStatementUtil.getColumnRevNum(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_revision));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedAuthor)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedAuthor, SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_author));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.recordedTime)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.recordedTime, SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.last_mod_time));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.depth)) {
                        if (nodeKind != ISVNWCDb.SVNWCDbKind.Dir) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.depth, SVNDepth.UNKNOWN);
                        } else {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.depth, SvnWcDbStatementUtil.getColumnDepth(stmtInfo, SVNWCDbSchema.NODES__Fields.depth));
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.checksum)) {
                        if (nodeKind != ISVNWCDb.SVNWCDbKind.File) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.checksum, null);
                        } else {
                            try {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.checksum, SvnWcDbStatementUtil.getColumnChecksum(stmtInfo, SVNWCDbSchema.NODES__Fields.checksum));
                            }
                            catch (SVNException e) {
                                SVNErrorMessage err = SVNErrorMessage.create(e.getErrorMessage().getErrorCode(), "The node ''{0}'' has a corrupt checksum value.", (Object)wcRoot.getAbsPath(localRelPath));
                                SVNErrorManager.error(err, SVNLogType.WC);
                            }
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.recordedSize)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.recordedSize, SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.translated_size));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.target)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.target, SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.symlink_target)));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changelist) && haveActual) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changelist, SvnWcDbStatementUtil.getColumnText(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.changelist));
                    }
                    ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.originalReposId, opDepth == 0L ? -1L : SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_id));
                    if (((Structure)info).hasField(StructureFields.NodeInfo.originalRevision)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.originalRevision, opDepth == 0L ? -1L : SvnWcDbStatementUtil.getColumnRevNum(stmtInfo, SVNWCDbSchema.NODES__Fields.revision));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.originalReposRelpath)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.originalReposRelpath, opDepth == 0L ? null : SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_path)));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.propsMod)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.propsMod, haveActual && !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.properties));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.hadProps)) {
                        byte[] props = SvnWcDbStatementUtil.getColumnBlob(stmtInfo, SVNWCDbSchema.NODES__Fields.properties);
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.hadProps, props != null && props.length > 2);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.conflicted)) {
                        if (haveActual) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.conflicted, !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data));
                        } else {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.conflicted, false);
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.lock)) {
                        if (opDepth == 0L) {
                            SVNSqlJetStatement stmtBaseLock = stmtInfo.getJoinedStatement(SVNWCDbSchema.LOCK.toString());
                            ISVNWCDb.SVNWCDbLock lock = SvnWcDbStatementUtil.getLockFromColumns(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_token, SVNWCDbSchema.LOCK__Fields.lock_owner, SVNWCDbSchema.LOCK__Fields.lock_comment, SVNWCDbSchema.LOCK__Fields.lock_date);
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.lock, lock);
                        } else {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.lock, null);
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.haveWork)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.haveWork, opDepth != 0L);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.opRoot)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.opRoot, opDepth > 0L && opDepth == (long)SVNWCUtils.relpathDepth(localRelPath));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.haveBase) || ((Structure)info).hasField(StructureFields.NodeInfo.haveMoreWork)) {
                        if (((Structure)info).hasField(StructureFields.NodeInfo.haveMoreWork)) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.haveMoreWork, false);
                        }
                        while (opDepth != 0L && (haveInfo = stmtInfo.next())) {
                            opDepth = SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.op_depth);
                            if (!((Structure)info).hasField(StructureFields.NodeInfo.haveMoreWork)) continue;
                            if (opDepth > 0L) {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.haveMoreWork, true);
                            }
                            if (((Structure)info).hasField(StructureFields.NodeInfo.haveBase)) continue;
                        }
                        if (((Structure)info).hasField(StructureFields.NodeInfo.haveBase)) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.haveBase, opDepth == 0L);
                        }
                    }
                    break block65;
                }
                if (haveActual) {
                    if (SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Corrupt data for ''{0}''", (Object)wcRoot.getAbsPath(localRelPath));
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.conflicted, true);
                    if (((Structure)info).hasField(StructureFields.NodeInfo.opRoot)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.opRoot, false);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.status)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.status, (Object)ISVNWCDb.SVNWCDbStatus.Normal);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.kind)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.kind, (Object)ISVNWCDb.SVNWCDbKind.Unknown);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.revision)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.revision, -1L);
                    }
                    ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposId, -1L);
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedRev)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedRev, -1L);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.depth)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.depth, SVNDepth.UNKNOWN);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.originalRevision)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.originalRevision, -1L);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.originalReposId)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.originalReposId, -1L);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changelist)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changelist, stmtActual.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.changelist));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.originalRevision)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.originalRevision, -1L);
                    }
                } else {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)wcRoot.getAbsPath(localRelPath));
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            finally {
                try {
                    if (stmtInfo != null) {
                        stmtInfo.reset();
                    }
                }
                catch (SVNException e) {}
                try {
                    if (stmtActual != null) {
                        stmtActual.reset();
                    }
                }
                catch (SVNException e) {}
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void canonicalizeURLs(SVNWCDbRoot wcRoot, boolean updateExternalProperties, final SVNExternalsStore store, final boolean omitDefaultPort) throws SVNException {
        HashMap<String, String> values = new HashMap<String, String>();
        try {
            SvnWcDbShared.begingWriteTransaction(wcRoot);
            ISqlJetTable repositoryTable = wcRoot.getSDb().getDb().getTable(SVNWCDbSchema.REPOSITORY.toString());
            ISqlJetCursor cursor = repositoryTable.open();
            while (!cursor.eof()) {
                String newUrl;
                String oldUrl = cursor.getString(SVNWCDbSchema.REPOSITORY__Fields.root.toString());
                SVNURL canonicalUrl = SVNUpdateClient16.canonicalizeURL(SVNURL.parseURIEncoded(oldUrl), omitDefaultPort);
                if (canonicalUrl != null && !oldUrl.equals(newUrl = canonicalUrl.toString())) {
                    values.put(SVNWCDbSchema.REPOSITORY__Fields.root.toString(), newUrl);
                    cursor.updateByFieldNames(values);
                }
                cursor.next();
            }
            cursor.close();
        }
        catch (SqlJetException e) {
            SvnWcDbShared.rollbackTransaction(wcRoot);
        }
        finally {
            SvnWcDbShared.commitTransaction(wcRoot);
        }
        if (updateExternalProperties) {
            final HashMap newPropertyValues = new HashMap();
            SvnWcDbProperties.readPropertiesRecursively(wcRoot, new File(""), SVNDepth.INFINITY, false, false, null, new ISvnObjectReceiver<SVNProperties>(){

                @Override
                public void receive(SvnTarget target, SVNProperties object) throws SVNException {
                    String externalsPropertyValue = object.getStringValue("svn:externals");
                    if (externalsPropertyValue != null) {
                        String newValue = SVNUpdateClient16.canonicalizeExtenrals(externalsPropertyValue, omitDefaultPort);
                        if (!externalsPropertyValue.equals(newValue)) {
                            object.put("svn:externals", newValue);
                            newPropertyValues.put(target.getFile(), object);
                        }
                        if (store != null) {
                            store.addExternal(target.getFile(), externalsPropertyValue, newValue);
                        }
                    }
                }
            });
            for (File path : newPropertyValues.keySet()) {
                wcRoot.getDb().opSetProps(path, (SVNProperties)newPropertyValues.get(path), null, false, null);
            }
        }
    }
}

