/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import java.util.concurrent.TimeUnit;

public class ReplicaConsistencyException
extends OperationFailureException {
    final ReplicaConsistencyPolicy consistencyPolicy;

    public ReplicaConsistencyException(ReplicaConsistencyPolicy consistencyPolicy, boolean unknownMaster) {
        super(null, false, "Unable to achieve consistency despite waiting for " + consistencyPolicy.getTimeout(TimeUnit.MILLISECONDS) + " ms." + (unknownMaster ? " The node is not currently in contact with a master." : ""), null);
        this.consistencyPolicy = consistencyPolicy;
    }

    public ReplicaConsistencyException(String message, ReplicaConsistencyPolicy consistencyPolicy) {
        super(null, false, message, null);
        this.consistencyPolicy = consistencyPolicy;
    }

    private ReplicaConsistencyException(String message, ReplicaConsistencyException cause) {
        super(message, cause);
        this.consistencyPolicy = cause.consistencyPolicy;
    }

    public OperationFailureException wrapSelf(String msg) {
        return new ReplicaConsistencyException(msg, this);
    }

    public ReplicaConsistencyPolicy getConsistencyPolicy() {
        return this.consistencyPolicy;
    }
}

