/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.configuration.provider.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.ServiceDirectory.CollectionDescriptionDBO;
import org.jzkit.ServiceDirectory.CollectionInfoTypeDBO;
import org.jzkit.ServiceDirectory.InformationLandscapeDBO;
import org.jzkit.ServiceDirectory.SearchServiceDescriptionDBO;
import org.jzkit.configuration.api.Configuration;
import org.jzkit.configuration.api.ConfigurationException;
import org.jzkit.configuration.api.RecordMappingInformationDBO;
import org.jzkit.configuration.api.RecordTransformerTypeInformationDBO;
import org.jzkit.configuration.api.SearchServiceDTO;
import org.jzkit.search.provider.iface.JZKitPluginMetadata;
import org.jzkit.search.util.Profile.CrosswalkDBO;
import org.jzkit.search.util.Profile.ProfileDBO;
import org.jzkit.search.util.QueryBuilder.QueryBuilder;
import org.springframework.context.ApplicationContext;

public class InMemoryImpl
implements Configuration,
Serializable {
    private Hashtable collection_descriptions = new Hashtable();
    private Hashtable service_descriptions = new Hashtable();
    private Hashtable profiles = new Hashtable();
    private Hashtable crosswalks = new Hashtable();
    private Hashtable landscapes = new Hashtable();
    private List record_converter_types = new ArrayList();
    private List record_converter_mappings = new ArrayList();
    private Hashtable app_settings = new Hashtable();
    private Hashtable infotypes = new Hashtable();
    private Map backend_plugins = null;
    protected ApplicationContext ctx = null;
    protected transient Log log = LogFactory.getLog(InMemoryImpl.class);

    public void initialise() {
        this.log.debug((Object)" -- initialising");
        this.log.debug((Object)" -- Scanning classpath for jzkit backend plugins");
        this.backend_plugins = this.ctx.getBeansOfType(JZKitPluginMetadata.class);
        if (this.backend_plugins != null) {
            for (Map.Entry e : this.backend_plugins.entrySet()) {
                this.log.debug((Object)("Registered: " + e.getKey() + " = " + e.getValue()));
            }
        }
        this.log.debug((Object)" -- Scanning classpath for jzkit query builders");
        Map qb_plugins = this.ctx.getBeansOfType(QueryBuilder.class);
        if (qb_plugins != null) {
            for (Map.Entry e : qb_plugins.entrySet()) {
                this.log.debug((Object)("Registered QueryBuilder: " + e.getKey() + " = " + e.getValue()));
            }
        }
    }

    public void close() {
    }

    public void registerCollectionDescription(CollectionDescriptionDBO collection_description) {
        this.collection_descriptions.put(collection_description.getCode(), collection_description);
    }

    public void registerServiceDescription(SearchServiceDescriptionDBO service_description) {
        if (service_description != null) {
            this.service_descriptions.put(service_description.getCode(), service_description);
            this.log.debug((Object)("Registering any collections from service " + service_description.getCode()));
            if (service_description.getCollections() != null) {
                for (CollectionDescriptionDBO coll : service_description.getCollections()) {
                    coll.setSearchServiceDescription(service_description);
                    this.registerCollectionDescription(coll);
                    this.log.debug((Object)(" - " + coll.getCode()));
                }
            } else {
                this.log.error((Object)"get collections returned null");
            }
        } else {
            this.log.error((Object)"register collection passed null collection description");
        }
    }

    public String toString() {
        return "IRDirectoryServiceInMemoryImpl:" + this.hashCode();
    }

    public CollectionDescriptionDBO lookupCollectionDescription(String collection_code) {
        return (CollectionDescriptionDBO)this.collection_descriptions.get(collection_code);
    }

    public SearchServiceDescriptionDBO lookupSearchService(String service_id) {
        return (SearchServiceDescriptionDBO)this.service_descriptions.get(service_id);
    }

    public InformationLandscapeDBO lookupLandscape(String landscape_code) {
        return (InformationLandscapeDBO)this.landscapes.get(landscape_code);
    }

    public Iterator enumerateVisibleCollections() {
        return this.collection_descriptions.values().iterator();
    }

    public Iterator enumerateRepositories() {
        return this.service_descriptions.values().iterator();
    }

    public void registerProfile(ProfileDBO p) {
        this.log.debug((Object)("Register profile : " + p));
        this.profiles.put(p.getCode(), p);
    }

    public ProfileDBO lookupProfile(String profile_code) {
        return (ProfileDBO)this.profiles.get(profile_code);
    }

    public Iterator enumerateProfiles() throws ConfigurationException {
        return this.profiles.values().iterator();
    }

    public void registerSearchService(SearchServiceDescriptionDBO ssd) {
        this.service_descriptions.put(ssd.getCode(), ssd);
    }

    public void registerCrosswalk(CrosswalkDBO cw) {
        this.crosswalks.put(cw.getSourceNamespace(), cw);
    }

    public CrosswalkDBO lookupCrosswalk(String source_namespace) {
        return (CrosswalkDBO)this.crosswalks.get(source_namespace);
    }

    public Iterator enumerateCrosswalks() {
        return this.crosswalks.values().iterator();
    }

    public void registerRecordModelConverterType(RecordTransformerTypeInformationDBO info) {
        this.log.debug((Object)("Calling register with " + info.getType() + " " + info.getClassname()));
        this.record_converter_types.add(info);
    }

    public Iterator getRegisteredConverterTypes() {
        return this.record_converter_types.iterator();
    }

    public void registerRecordModelMapping(String fromspec, String tospec, String type, String resource) {
        RecordMappingInformationDBO info = new RecordMappingInformationDBO(fromspec, tospec, type, resource);
        this.log.debug((Object)("Calling register with " + info));
        this.record_converter_mappings.add(info);
    }

    public Iterator getRegisteredRecordMappings() {
        return this.record_converter_mappings.iterator();
    }

    public void registerLandscape(InformationLandscapeDBO landscape) {
        this.landscapes.put(landscape.getCode(), landscape);
    }

    public Iterator enumerateLandscapes() {
        return this.landscapes.values().iterator();
    }

    public String getAppProperty(String name) {
        return (String)this.app_settings.get(name);
    }

    public void setAppProperty(String name, String value) {
        this.app_settings.put(name, value);
    }

    public Iterator getAppPropertyNames() {
        return this.app_settings.keySet().iterator();
    }

    public CollectionInfoTypeDBO lookupOrCreateCollectionInfoType(String namespace, String code) {
        CollectionInfoTypeDBO result = (CollectionInfoTypeDBO)this.infotypes.get(namespace + ":" + code);
        if (result == null) {
            result = new CollectionInfoTypeDBO(namespace, code);
            this.infotypes.put(namespace + ":" + code, result);
        }
        return result;
    }

    public Iterator enumerateInfoTypes() {
        return this.infotypes.values().iterator();
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.log.debug((Object)"setApplicationContext...");
        this.ctx = ctx;
    }

    public void tagCollection(String collection_id, String posting_namespace, String tag) {
        this.log.debug((Object)("tagCollection(" + collection_id + "," + posting_namespace + "," + tag + ")"));
    }

    public Map getBackendPlugins() {
        return this.backend_plugins;
    }

    public void addOrUpdate(SearchServiceDTO svc) throws ConfigurationException {
        throw new RuntimeException("Not impleemented");
    }
}

