/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.harvester.wfsfeatures.worker;

import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.fao.geonet.harvester.wfsfeatures.model.WFSHarvesterParameter;
import org.w3c.dom.Document;

public class WFSHarvesterRouteBuilder
extends RouteBuilder {
    public static final String LOGGER_NAME = "geonetwork.harvest.wfs.features";
    public static final String MESSAGE_HARVEST_WFS_FEATURES = "harvest-wfs-features";
    public static final String MESSAGE_DELETE_WFS_FEATURES = "delete-wfs-features";
    private boolean startsFromXMLConfigurationFile = false;

    public boolean isStartsFromXMLConfigurationFile() {
        return this.startsFromXMLConfigurationFile;
    }

    public void setStartsFromXMLConfigurationFile(boolean isStartingFromXMLConfigurationFile) {
        this.startsFromXMLConfigurationFile = isStartingFromXMLConfigurationFile;
    }

    public void configure() throws Exception {
        ((OnExceptionDefinition)this.onException(Exception.class).handled(true).log(LoggingLevel.ERROR, LOGGER_NAME, "Exception occured: ${exception.message}")).log(LoggingLevel.ERROR, LOGGER_NAME, "Harvesting task terminated due to previous exception (Exchange ${exchangeId}).");
        JaxbDataFormat jaxb = new JaxbDataFormat(false);
        jaxb.setContextPath(WFSHarvesterParameter.class.getPackage().getName());
        XPathBuilder xPathWfsConfigBuilder = new XPathBuilder("//wfs");
        ((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("file:src/test/resources/?fileName=wfs.xml&noop=true").id("harvest-wfs-start-from-file")).autoStartup(this.startsFromXMLConfigurationFile).log(LoggingLevel.INFO, LOGGER_NAME, "Harvest features from XML configuration file.")).convertBodyTo(Document.class)).log(LoggingLevel.DEBUG, LOGGER_NAME, "Content is: ${body}")).split((Expression)xPathWfsConfigBuilder).parallelProcessing().executorServiceRef("harvest-wfs-thread-pool").unmarshal((DataFormatDefinition)jaxb)).setProperty("configuration", (Expression)this.simple("${body}"))).log(LoggingLevel.INFO, LOGGER_NAME, "#${property.CamelSplitIndex}. Harvesting ${property.configuration.url} - start (Exchange ${exchangeId}).")).beanRef("WFSFeatureIndexer", "initialize(*, true)")).to("direct:delete-wfs-featuretype-features")).to("direct:index-wfs")).log(LoggingLevel.INFO, LOGGER_NAME, "#${property.CamelSplitIndex}. Harvesting ${property.configuration.url} - end (Exchange ${exchangeId}).")).end().log(LoggingLevel.DEBUG, LOGGER_NAME, "All WFS harvested.");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("activemq:queue:harvest-wfs-features?concurrentConsumers=5").id("harvest-wfs-start-from-message")).log(LoggingLevel.INFO, LOGGER_NAME, "Harvest features message received.")).log(LoggingLevel.INFO, LOGGER_NAME, "${body}")).setProperty("configuration", (Expression)this.simple("${body.parameters}"))).beanRef("WFSFeatureIndexer", "initialize(*, true)")).to("direct:delete-wfs-featuretype-features")).to("direct:index-wfs");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("activemq:queue:delete-wfs-features?concurrentConsumers=5").id("harvest-wfs-delete-features-from-message")).log(LoggingLevel.INFO, LOGGER_NAME, "Delete features message received.")).setProperty("url", (Expression)this.simple("${body.parameters.url}"))).setProperty("typeName", (Expression)this.simple("${body.parameters.typeName}"))).to("direct:delete-wfs-featuretype-features");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:delete-wfs-featuretype-features").id("harvest-wfs-delete-features")).log(LoggingLevel.INFO, "Removing features from ${property.url}#${property.typeName} ...")).beanRef("WFSFeatureIndexer", "deleteFeatures")).log(LoggingLevel.INFO, "All features from ${property.url}#${property.typeName} removed.");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:index-wfs").id(MESSAGE_HARVEST_WFS_FEATURES)).log(LoggingLevel.INFO, "Indexing features from ${property.url}#${property.typeName} ...")).beanRef("WFSFeatureIndexer", "indexFeatures", false)).log(LoggingLevel.INFO, "All features from ${property.url}#${property.typeName} indexed.");
    }
}

