/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.config.discovery;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.ClientConfig;
import io.searchbox.client.config.exception.CouldNotConnectException;
import io.searchbox.cluster.NodesInfo;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeChecker
extends AbstractScheduledService {
    private static final Logger log = LoggerFactory.getLogger(NodeChecker.class);
    private static final String PUBLISH_ADDRESS_KEY = "http_address";
    private static final String PUBLISH_ADDRESS_KEY_V5 = "publish_address";
    private static final Pattern INETSOCKETADDRESS_PATTERN = Pattern.compile("(?:inet\\[)?(?:(?:[^:]+)?\\/)?([^:]+):(\\d+)\\]?");
    private final NodesInfo action;
    protected JestClient client;
    protected AbstractScheduledService.Scheduler scheduler;
    protected String defaultScheme;
    protected Set<String> bootstrapServerList;
    protected Set<String> discoveredServerList;

    public NodeChecker(JestClient jestClient, ClientConfig clientConfig) {
        this.action = ((NodesInfo.Builder)new NodesInfo.Builder().withHttp().addNode(clientConfig.getDiscoveryFilter())).build();
        this.client = jestClient;
        this.defaultScheme = clientConfig.getDefaultSchemeForDiscoveredNodes();
        this.scheduler = AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)clientConfig.getDiscoveryFrequency(), (TimeUnit)clientConfig.getDiscoveryFrequencyTimeUnit());
        this.bootstrapServerList = ImmutableSet.copyOf(clientConfig.getServerList());
        this.discoveredServerList = new LinkedHashSet<String>();
    }

    protected void runOneIteration() throws Exception {
        JestResult result;
        try {
            result = this.client.execute(this.action);
        }
        catch (CouldNotConnectException cnce) {
            log.error("Connect exception executing NodesInfo!", (Throwable)cnce);
            this.removeNodeAndUpdateServers(cnce.getHost());
            return;
        }
        catch (Exception e) {
            log.error("Error executing NodesInfo!", (Throwable)e);
            this.client.setServers(this.bootstrapServerList);
            return;
        }
        if (result.isSucceeded()) {
            LinkedHashSet<String> httpHosts = new LinkedHashSet<String>();
            JsonObject jsonMap = result.getJsonObject();
            JsonObject nodes = (JsonObject)jsonMap.get("nodes");
            if (nodes != null) {
                for (Map.Entry entry : nodes.entrySet()) {
                    String httpAddress;
                    JsonObject http;
                    int majorVersion;
                    JsonObject host = ((JsonElement)entry.getValue()).getAsJsonObject();
                    JsonElement addressElement = null;
                    if (host.has("version") && (majorVersion = Integer.parseInt((String)Splitter.on((char)'.').splitToList((CharSequence)host.get("version").getAsString()).get(0))) >= 5 && (http = host.getAsJsonObject("http")) != null && http.has(PUBLISH_ADDRESS_KEY_V5)) {
                        addressElement = http.get(PUBLISH_ADDRESS_KEY_V5);
                    }
                    if (addressElement == null && host.has(PUBLISH_ADDRESS_KEY)) {
                        addressElement = host.get(PUBLISH_ADDRESS_KEY);
                    }
                    if (addressElement == null || addressElement.isJsonNull() || (httpAddress = this.getHttpAddress(addressElement.getAsString())) == null) continue;
                    httpHosts.add(httpAddress);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Discovered {} HTTP hosts: {}", (Object)httpHosts.size(), (Object)Joiner.on((char)',').join(httpHosts));
            }
            this.discoveredServerList = httpHosts;
            this.client.setServers(this.discoveredServerList);
        } else {
            log.warn("NodesInfo request resulted in error: {}", (Object)result.getErrorMessage());
            this.client.setServers(this.bootstrapServerList);
        }
    }

    protected void removeNodeAndUpdateServers(String hostToRemove) {
        log.warn("Removing host {}", (Object)hostToRemove);
        this.discoveredServerList.remove(hostToRemove);
        if (log.isInfoEnabled()) {
            log.info("Discovered server pool is now: {}", (Object)Joiner.on((char)',').join(this.discoveredServerList));
        }
        if (!this.discoveredServerList.isEmpty()) {
            this.client.setServers(this.discoveredServerList);
        } else {
            this.client.setServers(this.bootstrapServerList);
        }
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return this.scheduler;
    }

    protected ScheduledExecutorService executor() {
        final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.serviceName()).build());
        this.addListener(new Service.Listener(){

            public void terminated(Service.State from) {
                executor.shutdown();
            }

            public void failed(Service.State from, Throwable failure) {
                executor.shutdown();
            }
        }, MoreExecutors.directExecutor());
        return executor;
    }

    protected String getHttpAddress(String httpAddress) {
        Matcher resolvedMatcher = INETSOCKETADDRESS_PATTERN.matcher(httpAddress);
        if (resolvedMatcher.matches()) {
            return this.defaultScheme + resolvedMatcher.group(1) + ":" + resolvedMatcher.group(2);
        }
        return null;
    }
}

