/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.AbstractDoubleCollection;
import bak.pcj.DoubleCollection;
import bak.pcj.DoubleIterator;
import bak.pcj.hash.Primes;
import bak.pcj.map.AbstractObjectKeyDoubleMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ObjectKeyDoubleMap;
import bak.pcj.map.ObjectKeyDoubleMapIterator;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;

public class ObjectKeyDoubleOpenHashMap
extends AbstractObjectKeyDoubleMap
implements ObjectKeyDoubleMap,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private int size;
    private transient Object[] keys;
    private transient double[] values;
    private transient byte[] states;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED = 1;
    private static final byte REMOVED = 2;
    private transient int used;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient Set ckeys;
    private transient DoubleCollection cvalues;
    private transient boolean hasLastValue;
    private transient double lastValue;

    private ObjectKeyDoubleOpenHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk <= 0) {
            Exceptions.negativeOrZeroArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        capacity = Primes.nextPrime(capacity);
        this.keys = new Object[capacity];
        this.values = new double[capacity];
        this.states = new byte[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.used = 0;
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
        this.hasLastValue = false;
    }

    public ObjectKeyDoubleOpenHashMap() {
        this(11);
    }

    public ObjectKeyDoubleOpenHashMap(ObjectKeyDoubleMap map) {
        this();
        this.putAll(map);
    }

    public ObjectKeyDoubleOpenHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public ObjectKeyDoubleOpenHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public ObjectKeyDoubleOpenHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public ObjectKeyDoubleOpenHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public ObjectKeyDoubleOpenHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private static int hash(Object key) {
        return key == null ? 0 : key.hashCode();
    }

    private static boolean keyeq(Object k1, Object k2) {
        return k1 == null ? k2 == null : k1.equals(k2);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.keys.length * (1.0 + this.growthFactor)) : this.keys.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            Object[] newkeys = new Object[newcapacity];
            double[] newvalues = new double[newcapacity];
            byte[] newstates = new byte[newcapacity];
            this.used = 0;
            int i = 0;
            while (i < this.keys.length) {
                if (this.states[i] == 1) {
                    ++this.used;
                    Object k = this.keys[i];
                    double v = this.values[i];
                    int h = Math.abs(ObjectKeyDoubleOpenHashMap.hash(k));
                    int n = h % newcapacity;
                    if (newstates[n] == 1) {
                        int c = 1 + h % (newcapacity - 2);
                        do {
                            if ((n -= c) >= 0) continue;
                            n += newcapacity;
                        } while (newstates[n] != 0);
                    }
                    newstates[n] = 1;
                    newvalues[n] = v;
                    newkeys[n] = k;
                }
                ++i;
            }
            this.keys = newkeys;
            this.values = newvalues;
            this.states = newstates;
        }
    }

    public Set keySet() {
        if (this.ckeys == null) {
            this.ckeys = new KeySet();
        }
        return this.ckeys;
    }

    public double lget() {
        if (!this.hasLastValue) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public double put(Object key, double value) {
        int i;
        block5: {
            int h = Math.abs(ObjectKeyDoubleOpenHashMap.hash(key));
            i = h % this.keys.length;
            if (this.states[i] == 1) {
                if (ObjectKeyDoubleOpenHashMap.keyeq(this.keys[i], key)) {
                    double oldValue = this.values[i];
                    this.values[i] = value;
                    return oldValue;
                }
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) < 0) {
                        i += this.keys.length;
                    }
                    if (this.states[i] == 0 || this.states[i] == 2) break block5;
                } while (this.states[i] != 1 || !ObjectKeyDoubleOpenHashMap.keyeq(this.keys[i], key));
                double oldValue = this.values[i];
                this.values[i] = value;
                return oldValue;
            }
        }
        if (this.states[i] == 0) {
            ++this.used;
        }
        this.states[i] = 1;
        this.keys[i] = key;
        this.values[i] = value;
        ++this.size;
        this.ensureCapacity(this.used);
        return MapDefaults.defaultDouble();
    }

    public DoubleCollection values() {
        if (this.cvalues == null) {
            this.cvalues = new ValueCollection();
        }
        return this.cvalues;
    }

    public Object clone() {
        try {
            ObjectKeyDoubleOpenHashMap c = (ObjectKeyDoubleOpenHashMap)super.clone();
            c.keys = new Object[this.keys.length];
            System.arraycopy(this.keys, 0, c.keys, 0, this.keys.length);
            c.values = new double[this.values.length];
            System.arraycopy(this.values, 0, c.values, 0, this.values.length);
            c.states = new byte[this.states.length];
            System.arraycopy(this.states, 0, c.states, 0, this.states.length);
            c.cvalues = null;
            c.ckeys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    public ObjectKeyDoubleMapIterator entries() {
        return new ObjectKeyDoubleMapIterator(){
            int nextEntry = this.nextEntry(0);
            int lastEntry = -1;

            int nextEntry(int index) {
                while (index < ObjectKeyDoubleOpenHashMap.this.keys.length && ObjectKeyDoubleOpenHashMap.this.states[index] != 1) {
                    ++index;
                }
                return index;
            }

            public boolean hasNext() {
                return this.nextEntry < ObjectKeyDoubleOpenHashMap.this.keys.length;
            }

            public void next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.nextEntry(this.nextEntry + 1);
            }

            public void remove() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToRemove();
                }
                ((ObjectKeyDoubleOpenHashMap)ObjectKeyDoubleOpenHashMap.this).states[this.lastEntry] = 2;
                ObjectKeyDoubleOpenHashMap.this.size--;
                this.lastEntry = -1;
            }

            public Object getKey() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return ObjectKeyDoubleOpenHashMap.this.keys[this.lastEntry];
            }

            public double getValue() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return ObjectKeyDoubleOpenHashMap.this.values[this.lastEntry];
            }
        };
    }

    public void clear() {
        Arrays.fill(this.states, (byte)0);
        Arrays.fill(this.keys, null);
        this.size = 0;
        this.used = 0;
    }

    public boolean containsKey(Object key) {
        int h = Math.abs(ObjectKeyDoubleOpenHashMap.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && ObjectKeyDoubleOpenHashMap.keyeq(this.keys[i], key)) {
                this.hasLastValue = true;
                this.lastValue = this.values[i];
                return true;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                this.hasLastValue = false;
                return false;
            } while (this.states[i] != 1 || !ObjectKeyDoubleOpenHashMap.keyeq(this.keys[i], key));
            this.hasLastValue = true;
            this.lastValue = this.values[i];
            return true;
        }
        this.hasLastValue = false;
        return false;
    }

    public boolean containsValue(double value) {
        int i = 0;
        while (i < this.states.length) {
            if (this.states[i] == 1 && this.values[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public double get(Object key) {
        int h = Math.abs(ObjectKeyDoubleOpenHashMap.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && ObjectKeyDoubleOpenHashMap.keyeq(this.keys[i], key)) {
                return this.values[i];
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return MapDefaults.defaultDouble();
            } while (this.states[i] != 1 || !ObjectKeyDoubleOpenHashMap.keyeq(this.keys[i], key));
            return this.values[i];
        }
        return MapDefaults.defaultDouble();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public double remove(Object key) {
        int h = Math.abs(ObjectKeyDoubleOpenHashMap.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && ObjectKeyDoubleOpenHashMap.keyeq(this.keys[i], key)) {
                double oldValue = this.values[i];
                this.states[i] = 2;
                this.keys[i] = null;
                --this.size;
                return oldValue;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return MapDefaults.defaultDouble();
            } while (this.states[i] != 1 || !ObjectKeyDoubleOpenHashMap.keyeq(this.keys[i], key));
            double oldValue = this.values[i];
            this.states[i] = 2;
            this.keys[i] = null;
            --this.size;
            return oldValue;
        }
        return MapDefaults.defaultDouble();
    }

    public int size() {
        return this.size;
    }

    public double tget(Object key) {
        int h = Math.abs(ObjectKeyDoubleOpenHashMap.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && ObjectKeyDoubleOpenHashMap.keyeq(this.keys[i], key)) {
                return this.values[i];
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                Exceptions.noSuchMapping(key);
            } while (this.states[i] != 1 || !ObjectKeyDoubleOpenHashMap.keyeq(this.keys[i], key));
            return this.values[i];
        }
        Exceptions.noSuchMapping(key);
        throw new RuntimeException();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.keys.length);
        ObjectKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeObject(i.getKey());
            s.writeDouble(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.keys = new Object[s.readInt()];
        this.states = new byte[this.keys.length];
        this.values = new double[this.keys.length];
        this.used = this.size;
        int n = 0;
        while (n < this.size) {
            Object key = s.readObject();
            double value = s.readDouble();
            int h = Math.abs(ObjectKeyDoubleOpenHashMap.hash(key));
            int i = h % this.keys.length;
            if (this.states[i] != 0) {
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) >= 0) continue;
                    i += this.keys.length;
                } while (this.states[i] != 0);
            }
            this.states[i] = 1;
            this.keys[i] = key;
            this.values[i] = value;
            ++n;
        }
    }

    private class ValueCollection
    extends AbstractDoubleCollection {
        private ValueCollection() {
        }

        public void clear() {
            ObjectKeyDoubleOpenHashMap.this.clear();
        }

        public boolean contains(double v) {
            return ObjectKeyDoubleOpenHashMap.this.containsValue(v);
        }

        public DoubleIterator iterator() {
            return new DoubleIterator(this){
                int nextEntry;
                int lastEntry;
                private final /* synthetic */ ValueCollection this$1;
                {
                    this.this$1 = this$1;
                    this.nextEntry = this.nextEntry(0);
                    this.lastEntry = -1;
                }

                int nextEntry(int index) {
                    while (index < ObjectKeyDoubleOpenHashMap.access$200(ValueCollection.access$700(this.this$1)).length && ObjectKeyDoubleOpenHashMap.access$300(ValueCollection.access$700(this.this$1))[index] != 1) {
                        ++index;
                    }
                    return index;
                }

                public boolean hasNext() {
                    return this.nextEntry < ObjectKeyDoubleOpenHashMap.access$200(ValueCollection.access$700(this.this$1)).length;
                }

                public double next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return ObjectKeyDoubleOpenHashMap.access$500(ValueCollection.access$700(this.this$1))[this.lastEntry];
                }

                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    ObjectKeyDoubleOpenHashMap.access$300((ObjectKeyDoubleOpenHashMap)ValueCollection.access$700((ValueCollection)this.this$1))[this.lastEntry] = 2;
                    ObjectKeyDoubleOpenHashMap.access$410(ValueCollection.access$700(this.this$1));
                    this.lastEntry = -1;
                }
            };
        }

        public int size() {
            return ObjectKeyDoubleOpenHashMap.this.size;
        }

        static /* synthetic */ ObjectKeyDoubleOpenHashMap access$700(ValueCollection x0) {
            return x0.ObjectKeyDoubleOpenHashMap.this;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public void clear() {
            ObjectKeyDoubleOpenHashMap.this.clear();
        }

        public boolean contains(Object v) {
            return ObjectKeyDoubleOpenHashMap.this.containsKey(v);
        }

        public Iterator iterator() {
            return new Iterator(this){
                int nextEntry;
                int lastEntry;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                    this.nextEntry = this.nextEntry(0);
                    this.lastEntry = -1;
                }

                int nextEntry(int index) {
                    while (index < ObjectKeyDoubleOpenHashMap.access$200(KeySet.access$600(this.this$1)).length && ObjectKeyDoubleOpenHashMap.access$300(KeySet.access$600(this.this$1))[index] != 1) {
                        ++index;
                    }
                    return index;
                }

                public boolean hasNext() {
                    return this.nextEntry < ObjectKeyDoubleOpenHashMap.access$200(KeySet.access$600(this.this$1)).length;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return ObjectKeyDoubleOpenHashMap.access$200(KeySet.access$600(this.this$1))[this.lastEntry];
                }

                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    ObjectKeyDoubleOpenHashMap.access$300((ObjectKeyDoubleOpenHashMap)KeySet.access$600((KeySet)this.this$1))[this.lastEntry] = 2;
                    ObjectKeyDoubleOpenHashMap.access$200((ObjectKeyDoubleOpenHashMap)KeySet.access$600((KeySet)this.this$1))[this.lastEntry] = null;
                    ObjectKeyDoubleOpenHashMap.access$410(KeySet.access$600(this.this$1));
                    this.lastEntry = -1;
                }
            };
        }

        public boolean remove(Object v) {
            boolean result = ObjectKeyDoubleOpenHashMap.this.containsKey(v);
            if (result) {
                ObjectKeyDoubleOpenHashMap.this.remove(v);
            }
            return result;
        }

        public int size() {
            return ObjectKeyDoubleOpenHashMap.this.size;
        }

        static /* synthetic */ ObjectKeyDoubleOpenHashMap access$600(KeySet x0) {
            return x0.ObjectKeyDoubleOpenHashMap.this;
        }
    }
}

