/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.ShortCollection;
import bak.pcj.adapter.ShortIteratorToIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class ShortCollectionToCollectionAdapter
extends AbstractCollection {
    protected ShortCollection collection;

    public ShortCollectionToCollectionAdapter(ShortCollection collection) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
    }

    public boolean add(Object o) {
        if (o == null) {
            Exceptions.nullElementNotAllowed();
        }
        return this.collection.add((Short)o);
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(Object o) {
        try {
            return this.collection.contains((Short)o);
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public Iterator iterator() {
        return new ShortIteratorToIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(Object o) {
        try {
            return this.collection.remove((Short)o);
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.retainAll(c);
    }

    public int size() {
        return this.collection.size();
    }

    public int hashCode() {
        return this.collection.hashCode();
    }
}

