/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.languages;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import java.io.File;
import java.nio.file.Path;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.utils.Log;

public class LanguageDetector {
    private static LanguageDetector instance;
    private static boolean profilesLoaded;
    private static boolean languageLevelSupported;
    private static String upgradeMessage;

    private LanguageDetector() {
    }

    public static synchronized LanguageDetector getInstance() throws Exception {
        if (!languageLevelSupported) {
            throw new Exception(upgradeMessage);
        }
        if (instance == null) {
            instance = new LanguageDetector();
        }
        return instance;
    }

    public static void init(Path path) throws Exception {
        if (!languageLevelSupported) {
            throw new Exception(upgradeMessage);
        }
        if (!profilesLoaded) {
            DetectorFactory.loadProfile((File)path.toFile());
            profilesLoaded = true;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public String detect(ServiceContext srvContext, String input) throws Exception {
        if (!languageLevelSupported) {
            throw new Exception(upgradeMessage);
        }
        Detector detector = DetectorFactory.create();
        detector.append(input);
        String detectedLanguage = detector.detect();
        if (detectedLanguage.length() > 2) {
            detectedLanguage = detectedLanguage.substring(0, 2);
        }
        String iso639_2 = srvContext.getBean(IsoLanguagesMapper.class).iso639_1_to_iso639_2(detectedLanguage);
        Log.debug((String)"LanguageDetector", (Object)("detected language: " + iso639_2 + " for text:" + input));
        return iso639_2;
    }

    static {
        profilesLoaded = false;
        languageLevelSupported = false;
        String javaVersion = System.getProperty("java.version");
        if (StringUtils.isNotEmpty((String)javaVersion) && javaVersion.startsWith("1.5")) {
            upgradeMessage = "You are running on Java " + javaVersion + ", auto-detecting languages is disabled. Upgrade to at least 1.6.";
            Log.warning((String)"LanguageDetector", (Object)upgradeMessage);
        } else {
            languageLevelSupported = true;
        }
    }
}

