/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.MetadataSourceInfo;
import org.fao.geonet.domain.Operation;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.Setting;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.User_;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.OperationRepository;
import org.fao.geonet.repository.SettingRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

public class AccessManager {
    @Autowired
    SettingRepository settingRepository;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    OperationRepository operationRepository;
    @Autowired
    OperationAllowedRepository operationAllowedRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    UserRepository userRepository;

    public Set<Operation> getOperations(ServiceContext context, String mdId, String ip) throws Exception {
        return this.getOperations(context, mdId, ip, null);
    }

    public Set<Operation> getOperations(ServiceContext context, String mdId, String ip, Collection<Operation> operations) throws Exception {
        HashSet<Operation> results;
        if (this.isOwner(context, mdId)) {
            results = new HashSet(this.operationRepository.findAll());
        } else {
            results = operations == null ? new HashSet<Operation>(this.getAllOperations(context, mdId, ip)) : new HashSet<Operation>(operations);
            UserSession us = context.getUserSession();
            if (us != null && us.isAuthenticated() && us.getProfile() == Profile.Editor && us.getProfile() == Profile.Reviewer) {
                results.add(this.operationRepository.findReservedOperation(ReservedOperation.view));
            }
        }
        return results;
    }

    public Set<String> getOperationNames(ServiceContext context, String mdId, String ip, Collection<Operation> operations) throws Exception {
        HashSet<String> names = new HashSet<String>();
        for (Operation op : this.getOperations(context, mdId, ip, operations)) {
            names.add(op.getName());
        }
        return names;
    }

    public Set<Operation> getAllOperations(ServiceContext context, String mdId, String ip) throws Exception {
        HashSet<Operation> operations = new HashSet<Operation>();
        Set<Integer> groups = this.getUserGroups(context.getUserSession(), ip, false);
        for (OperationAllowed opAllow : this.operationAllowedRepository.findByMetadataId(mdId)) {
            if (!groups.contains(opAllow.getId().getGroupId())) continue;
            operations.add((Operation)this.operationRepository.findOne((Serializable)Integer.valueOf(opAllow.getId().getOperationId())));
        }
        return operations;
    }

    public Set<Integer> getUserGroups(UserSession usrSess, String ip, boolean editingGroupsOnly) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        HashSet<Integer> hs = new HashSet<Integer>();
        hs.add(ReservedGroup.all.getId());
        if (ip != null && this.isIntranet(ip)) {
            hs.add(ReservedGroup.intranet.getId());
        }
        if (usrSess != null && usrSess.isAuthenticated()) {
            hs.add(ReservedGroup.guest.getId());
            if (Profile.Administrator == usrSess.getProfile()) {
                List allGroupIds = this.groupRepository.findIds();
                hs.addAll(allGroupIds);
            } else {
                Specification spec = UserGroupSpecs.hasUserId((int)usrSess.getUserIdAsInt());
                if (editingGroupsOnly) {
                    spec = Specifications.where((Specification)spec).and(UserGroupSpecs.hasProfile((Profile)Profile.Editor));
                }
                hs.addAll(this.userGroupRepository.findGroupIds(spec));
            }
        }
        return hs;
    }

    public static List<Integer> getGroups(UserSession session, Profile profile) throws SQLException {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        UserGroupRepository userGroupRepository = (UserGroupRepository)applicationContext.getBean(UserGroupRepository.class);
        Specifications spec = Specifications.where((Specification)UserGroupSpecs.hasUserId((int)session.getUserIdAsInt()));
        spec = spec.and(UserGroupSpecs.hasProfile((Profile)profile));
        return userGroupRepository.findGroupIds((Specification)spec);
    }

    public Set<Integer> getReviewerGroups(UserSession usrSess) throws Exception {
        HashSet<Integer> hs = new HashSet<Integer>();
        if (usrSess != null && usrSess.isAuthenticated()) {
            Specification spec = UserGroupSpecs.hasUserId((int)usrSess.getUserIdAsInt());
            spec = Specifications.where((Specification)spec).and(UserGroupSpecs.hasProfile((Profile)Profile.Reviewer));
            hs.addAll(this.userGroupRepository.findGroupIds(spec));
        }
        return hs;
    }

    public Set<Integer> getVisibleGroups(int userId) throws Exception {
        HashSet<Integer> hs = new HashSet<Integer>();
        User user = (User)this.userRepository.findOne((Serializable)Integer.valueOf(userId));
        if (user == null) {
            return hs;
        }
        Profile profile = user.getProfile();
        List groupIds = profile == Profile.Administrator ? this.groupRepository.findIds() : this.userGroupRepository.findGroupIds(UserGroupSpecs.hasUserId((int)user.getId()));
        hs.addAll(groupIds);
        return hs;
    }

    public boolean canEdit(ServiceContext context, String id) throws Exception {
        return this.isOwner(context, id) || this.hasEditPermission(context, id);
    }

    public boolean canReview(ServiceContext context, String id) throws Exception {
        if (!this.isUserAuthenticated(context.getUserSession())) {
            return false;
        }
        AbstractMetadata info = context.getBean(IMetadataUtils.class).findOne(id);
        if (info == null) {
            return false;
        }
        MetadataSourceInfo sourceInfo = info.getSourceInfo();
        return this.isOwner(context, sourceInfo) || this.hasReviewPermission(context, info);
    }

    public boolean canChangeStatus(ServiceContext context, String id) throws Exception {
        return this.hasOnwershipReviewPermission(context, id) || this.hasReviewPermission(context, id);
    }

    public boolean isOwner(ServiceContext context, String id) throws Exception {
        AbstractMetadata info = this.metadataUtils.findOne(id);
        if (info == null) {
            return false;
        }
        MetadataSourceInfo sourceInfo = info.getSourceInfo();
        return this.isOwner(context, sourceInfo);
    }

    public boolean isOwner(ServiceContext context, MetadataSourceInfo sourceInfo) throws Exception {
        UserSession us = context.getUserSession();
        if (!this.isUserAuthenticated(us)) {
            return false;
        }
        Profile profile = us.getProfile();
        if (profile == Profile.Administrator) {
            return true;
        }
        if (us.getUserIdAsInt() == sourceInfo.getOwner().intValue()) {
            return true;
        }
        if (profile != Profile.Reviewer && profile != Profile.UserAdmin) {
            return false;
        }
        Integer groupOwner = sourceInfo.getGroupOwner();
        if (groupOwner == null) {
            return false;
        }
        for (Integer userGroup : this.getReviewerGroups(us)) {
            if (userGroup.intValue() != groupOwner.intValue()) continue;
            return true;
        }
        return false;
    }

    private String join(Set<Integer> set, String delim) {
        StringBuilder sb = new StringBuilder();
        String loopDelim = "";
        for (Integer s : set) {
            sb.append(loopDelim);
            sb.append(s + "");
            loopDelim = delim;
        }
        return sb.toString();
    }

    public Element getContentReviewers(ServiceContext context, Set<Integer> metadataIds) throws Exception {
        List results = this.userRepository.findAllByGroupOwnerNameAndProfile(metadataIds, Profile.Reviewer, SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{User_.name}));
        Element resultEl = new Element("results");
        for (Pair integerUserPair : results) {
            User user = (User)integerUserPair.two();
            resultEl.addContent((Content)new Element("record").addContent((Content)new Element("userid").setText(user.getId() + "")).addContent((Content)new Element("name").setText(user.getName())).addContent((Content)new Element("surname").setText(user.getSurname())).addContent((Content)new Element("email").setText(user.getEmail())));
        }
        return resultEl;
    }

    public boolean isVisibleToAll(String metadataId) throws Exception {
        AbstractMetadata metadata = this.metadataUtils.findOne(metadataId);
        if (metadata == null) {
            return false;
        }
        Group allGroup = this.groupRepository.findReservedGroup(ReservedGroup.all);
        int opId = ReservedOperation.view.getId();
        return this.hasPermission(metadata, allGroup, opId);
    }

    public boolean canDownload(ServiceContext context, String id) throws Exception {
        if (this.isOwner(context, id)) {
            return true;
        }
        int downloadId = ReservedOperation.download.getId();
        Set<Operation> ops = this.getOperations(context, id, context.getIpAddress());
        for (Operation op : ops) {
            if (op.getId() != downloadId) continue;
            return true;
        }
        return false;
    }

    public boolean canDynamic(ServiceContext context, String id) throws Exception {
        if (this.isOwner(context, id)) {
            return true;
        }
        int dynamicId = ReservedOperation.dynamic.getId();
        Set<Operation> ops = this.getOperations(context, id, context.getIpAddress());
        for (Operation op : ops) {
            if (op.getId() != dynamicId) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(AbstractMetadata metadata, Group group, int opId) {
        return this.operationAllowedRepository.findOneById_GroupIdAndId_MetadataIdAndId_OperationId(group.getId(), metadata.getId(), opId) != null;
    }

    public boolean hasEditPermission(ServiceContext context, String id) throws Exception {
        return this.hasEditingPermissionWithProfile(context, id, Profile.Editor);
    }

    public boolean hasReviewPermission(ServiceContext context, String id) throws Exception {
        if (!this.isUserAuthenticated(context.getUserSession())) {
            return false;
        }
        AbstractMetadata info = context.getBean(IMetadataUtils.class).findOne(id);
        if (info == null) {
            return false;
        }
        return this.hasReviewPermission(context, info);
    }

    public boolean hasReviewPermission(ServiceContext context, AbstractMetadata metadata) throws Exception {
        UserSession us = context.getUserSession();
        if (!this.isUserAuthenticated(us)) {
            return false;
        }
        Specifications hasUserIdAndGroupAndProfile = Specifications.where((Specification)UserGroupSpecs.hasProfile((Profile)Profile.Reviewer)).and(UserGroupSpecs.hasGroupId((Integer)metadata.getSourceInfo().getGroupOwner())).and(UserGroupSpecs.hasUserId((int)us.getUserIdAsInt()));
        UserGroupRepository userGroupRepo = context.getBean(UserGroupRepository.class);
        long count = userGroupRepo.count((Specification)hasUserIdAndGroupAndProfile);
        return count > 0L;
    }

    private boolean hasEditingPermissionWithProfile(ServiceContext context, String id, Profile profile) throws Exception {
        UserSession us = context.getUserSession();
        if (!this.isUserAuthenticated(us)) {
            return false;
        }
        List allOpAlloweds = this.operationAllowedRepository.findAll((Specification)Specifications.where((Specification)OperationAllowedSpecs.hasMetadataId((String)id)).and(OperationAllowedSpecs.hasOperation((ReservedOperation)ReservedOperation.editing)));
        if (allOpAlloweds.isEmpty()) {
            return false;
        }
        Specifications spec = Specifications.where((Specification)UserGroupSpecs.hasProfile((Profile)profile)).and(UserGroupSpecs.hasUserId((int)us.getUserIdAsInt()));
        ArrayList<Integer> opAlloweds = new ArrayList<Integer>();
        for (OperationAllowed opAllowed : allOpAlloweds) {
            opAlloweds.add(opAllowed.getId().getGroupId());
        }
        return !this.userGroupRepository.findAll((Specification)(spec = spec.and(UserGroupSpecs.hasGroupIds(opAlloweds)))).isEmpty();
    }

    public boolean hasOnwershipReviewPermission(ServiceContext context, String id) throws Exception {
        UserSession us = context.getUserSession();
        if (!this.isUserAuthenticated(us)) {
            return false;
        }
        UserGroupRepository userGroupRepository = context.getBean(UserGroupRepository.class);
        IMetadataUtils metadataUtils = context.getBean(IMetadataUtils.class);
        Specifications spec = Specifications.where((Specification)UserGroupSpecs.hasProfile((Profile)Profile.Reviewer)).and(UserGroupSpecs.hasUserId((int)us.getUserIdAsInt()));
        ArrayList<Integer> opAlloweds = new ArrayList<Integer>();
        opAlloweds.add(metadataUtils.findOne(id).getSourceInfo().getGroupOwner());
        spec = spec.and(UserGroupSpecs.hasGroupIds(opAlloweds));
        return !userGroupRepository.findAll((Specification)spec).isEmpty();
    }

    public int getPrivilegeId(String name) {
        Operation op = this.operationRepository.findByName(name);
        if (op == null) {
            throw new IllegalArgumentException("No Operation/privilege found with name: " + name);
        }
        return op.getId();
    }

    public String getPrivilegeName(int id) {
        return ((Operation)this.operationRepository.findOne((Serializable)Integer.valueOf(id))).getName();
    }

    public boolean isIntranet(String ip) {
        if (ip.startsWith("0:0:0:0:0:0:0:1") || ip.equals("127.0.0.1")) {
            return true;
        }
        String ipv6LinkLocalPrefix = "fe80:";
        if (ip.toLowerCase().startsWith(ipv6LinkLocalPrefix)) {
            return true;
        }
        if (ip.indexOf(58) >= 0) {
            return false;
        }
        Setting network = (Setting)this.settingRepository.findOne((Serializable)((Object)"system/intranet/network"));
        Setting netmask = (Setting)this.settingRepository.findOne((Serializable)((Object)"system/intranet/netmask"));
        try {
            if (network != null && netmask != null && StringUtils.isNotEmpty((String)network.getValue()) && StringUtils.isNotEmpty((String)netmask.getValue())) {
                long lIntranetNet = this.getAddress(network.getValue());
                long lIntranetMask = this.getAddress(netmask.getValue());
                long lAddress = this.getAddress(ip.split(",")[0]);
                return (lAddress & lIntranetMask) == (lIntranetNet & lIntranetMask);
            }
        }
        catch (Exception nfe) {
            Log.error((String)"geonetwork.accessmanager", (Object)("isIntranet error: " + nfe.getMessage()), (Throwable)nfe);
        }
        return false;
    }

    private long getAddress(String ip) {
        if (ip.trim().equals("?")) {
            return 0L;
        }
        StringTokenizer st = new StringTokenizer(ip, ".");
        if (!st.hasMoreElements()) {
            return 0L;
        }
        long a1 = Integer.parseInt(st.nextToken());
        if (!st.hasMoreElements()) {
            return 0L;
        }
        long a2 = Integer.parseInt(st.nextToken());
        if (!st.hasMoreElements()) {
            return 0L;
        }
        long a3 = Integer.parseInt(st.nextToken());
        if (!st.hasMoreElements()) {
            return 0L;
        }
        long a4 = Integer.parseInt(st.nextToken());
        return a1 << 24 | a2 << 16 | a3 << 8 | a4;
    }

    private boolean isUserAuthenticated(UserSession us) {
        return us != null && us.isAuthenticated();
    }
}

