/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;

public abstract class StoreUtils {
    public static void copyDataDir(ServiceContext context, int oldMetadataId, int newMetadataId, boolean newApproved) throws Exception {
        IMetadataUtils metadataUtils = context.getBean(IMetadataUtils.class);
        String oldUuid = metadataUtils.getMetadataUuid(String.valueOf(oldMetadataId));
        String newUuid = metadataUtils.getMetadataUuid(String.valueOf(newMetadataId));
        StoreUtils.copyDataDir(context, oldUuid, newUuid, newApproved);
    }

    public static void copyDataDir(ServiceContext context, String oldUuid, String newUuid, boolean newApproved) throws Exception {
        Store store = context.getBean("resourceStore", Store.class);
        for (MetadataResourceVisibility visibility : MetadataResourceVisibility.values()) {
            List<MetadataResource> resources = store.getResources(context, oldUuid, visibility, null, (Boolean)true);
            for (MetadataResource resource : resources) {
                Store.ResourceHolder holder = store.getResource(context, oldUuid, visibility, resource.getFilename(), true);
                Throwable throwable = null;
                try {
                    store.putResource(context, newUuid, holder.getPath(), visibility, (Boolean)newApproved);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (holder == null) continue;
                    if (throwable != null) {
                        try {
                            holder.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    holder.close();
                }
            }
        }
    }

    private static List<MetadataResource> exceptMetadataResource(List<MetadataResource> l, List<MetadataResource> r) {
        HashMap<String, MetadataResource> rMap = new HashMap<String, MetadataResource>();
        for (MetadataResource mr : r) {
            rMap.put(mr.getId(), mr);
        }
        ArrayList<MetadataResource> results = new ArrayList<MetadataResource>(l);
        Iterator itResults = results.iterator();
        while (itResults.hasNext()) {
            MetadataResource mCheck;
            MetadataResource m = (MetadataResource)itResults.next();
            if (!rMap.containsKey(m.getId()) || !(mCheck = (MetadataResource)rMap.get(m.getId())).getFilename().equals(m.getFilename()) || !mCheck.getMetadataUuid().equals(m.getMetadataUuid()) || !mCheck.getVisibility().equals((Object)m.getVisibility())) continue;
            itResults.remove();
        }
        return results;
    }

    public static void replaceDataDir(ServiceContext context, String sourceUuid, String targetUuid, boolean sourceApproved, boolean targetApproved) throws Exception {
        Store store = context.getBean("resourceStore", Store.class);
        for (MetadataResourceVisibility visibility : MetadataResourceVisibility.values()) {
            Throwable throwable;
            Store.ResourceHolder holder;
            List<MetadataResource> sourceResources = store.getResources(context, sourceUuid, visibility, null, (Boolean)sourceApproved);
            List<MetadataResource> targetResources = store.getResources(context, targetUuid, visibility, null, (Boolean)targetApproved);
            List<MetadataResource> targetDeleteResources = StoreUtils.exceptMetadataResource(targetResources, sourceResources);
            List<MetadataResource> targetAddResources = StoreUtils.exceptMetadataResource(sourceResources, targetResources);
            List<MetadataResource> targetUpdateResources = StoreUtils.exceptMetadataResource(targetResources, targetDeleteResources);
            for (MetadataResource resource : targetAddResources) {
                holder = store.getResource(context, sourceUuid, visibility, resource.getFilename(), sourceApproved);
                throwable = null;
                try {
                    store.putResource(context, targetUuid, holder.getPath(), visibility, (Boolean)targetApproved);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (holder == null) continue;
                    if (throwable != null) {
                        try {
                            holder.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    holder.close();
                }
            }
            for (MetadataResource resource : targetUpdateResources) {
                holder = store.getResource(context, sourceUuid, visibility, resource.getFilename(), sourceApproved);
                throwable = null;
                try {
                    store.putResource(context, targetUuid, holder.getPath(), visibility, (Boolean)targetApproved);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (holder == null) continue;
                    if (throwable != null) {
                        try {
                            holder.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    holder.close();
                }
            }
            for (MetadataResource resource : targetDeleteResources) {
                store.delResource(context, targetUuid, visibility, resource.getFilename(), targetApproved);
            }
        }
    }

    public static void extract(ServiceContext context, String metadataUuid, List<MetadataResource> resources, Path destinationDir, boolean approved) throws Exception {
        Store store = context.getBean("resourceStore", Store.class);
        Files.createDirectories(destinationDir, new FileAttribute[0]);
        for (MetadataResource resource : resources) {
            Store.ResourceHolder holder = store.getResource(context, metadataUuid, resource.getVisibility(), resource.getFilename(), approved);
            Throwable throwable = null;
            try {
                InputStream inputStream = Files.newInputStream(holder.getPath(), new OpenOption[0]);
                Throwable throwable2 = null;
                try {
                    Files.copy(inputStream, destinationDir.resolve(resource.getFilename()), new CopyOption[0]);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable2 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (holder == null) continue;
                if (throwable != null) {
                    try {
                        holder.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                holder.close();
            }
        }
    }
}

