/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.transaction.Transactional;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ContextAwareTask;
import org.fao.geonet.domain.Address;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatusId;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.UserGroupId_;
import org.fao.geonet.exceptions.TaskExecutionException;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.UserSavedSelectionRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.MetadataStatusSpecs;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.utils.Log;
import org.springframework.context.ApplicationContext;

public class MergeUsersByUsernameDatabaseMigration
implements ContextAwareTask {
    @Override
    @Transactional
    public void run(ApplicationContext applicationContext) throws TaskExecutionException {
        UserRepository userRepository = (UserRepository)applicationContext.getBean(UserRepository.class);
        List duplicatedUsernamesList = userRepository.findDuplicatedUsernamesCaseInsensitive();
        Log.debug((String)"jeeves", (Object)("Found these duplicated usernames: " + duplicatedUsernamesList));
        try {
            for (String duplicatedUsername : duplicatedUsernamesList) {
                this.mergeUsers(applicationContext, duplicatedUsername);
            }
        }
        catch (Exception e) {
            Log.error((String)"jeeves", (Object)"Exception merging users", (Throwable)e);
            throw new TaskExecutionException(e);
        }
    }

    private void mergeUsers(ApplicationContext applicationContext, String duplicatedUsername) throws Exception {
        UserRepository userRepository = (UserRepository)applicationContext.getBean(UserRepository.class);
        List duplicatedUserList = userRepository.findByUsernameIgnoreCase(duplicatedUsername);
        duplicatedUserList.sort(Comparator.comparing(User::getProfile));
        User greatestProfileUser = (User)duplicatedUserList.get(0);
        User userToKeep = (User)userRepository.findOne((Serializable)Integer.valueOf(greatestProfileUser.getId()));
        HashSet emails = new HashSet();
        HashSet addresses = new HashSet();
        this.mergeGroups(applicationContext, duplicatedUserList, userToKeep);
        this.transferMetadata(applicationContext, duplicatedUserList, userToKeep);
        this.transferSavedSelections(applicationContext, duplicatedUserList, userToKeep);
        User tempUser = new User();
        for (int i = duplicatedUserList.size() - 1; i >= 0; --i) {
            User duplicatedUser = (User)duplicatedUserList.get(i);
            addresses.addAll(duplicatedUser.getAddresses());
            this.mergeUser(tempUser, duplicatedUser);
            emails.addAll(duplicatedUser.getEmailAddresses());
        }
        this.mergeUser(userToKeep, tempUser);
        duplicatedUserList.remove(greatestProfileUser);
        userRepository.delete((Iterable)duplicatedUserList);
        userRepository.flush();
        userToKeep.setUsername(userToKeep.getUsername().toLowerCase());
        userRepository.save((Object)userToKeep);
    }

    private void transferSavedSelections(ApplicationContext applicationContext, List<User> duplicatedUserList, User userToKeep) {
        UserSavedSelectionRepository userSavedSelectionRepository = (UserSavedSelectionRepository)applicationContext.getBean(UserSavedSelectionRepository.class);
        for (int i = 1; i < duplicatedUserList.size(); ++i) {
            userSavedSelectionRepository.deleteAllByUser(Integer.valueOf(duplicatedUserList.get(i).getId()));
        }
    }

    void transferMetadata(ApplicationContext applicationContext, List<User> oldMetadataOwnerList, User newMetadataOwner) throws Exception {
        MetadataRepository metadataRepository = (MetadataRepository)applicationContext.getBean(MetadataRepository.class);
        DataManager dataManager = (DataManager)applicationContext.getBean(DataManager.class);
        MetadataStatusRepository metadataStatusRepository = (MetadataStatusRepository)applicationContext.getBean(MetadataStatusRepository.class);
        for (int i = 1; i < oldMetadataOwnerList.size(); ++i) {
            User oldOwner = oldMetadataOwnerList.get(i);
            List metadataList = metadataRepository.findAll(MetadataSpecs.isOwnedByUser((int)oldOwner.getId()));
            for (Metadata metadata : metadataList) {
                dataManager.updateMetadataOwner(metadata.getId(), Integer.toString(newMetadataOwner.getId()), Integer.toString(metadata.getSourceInfo().getGroupOwner()));
            }
            List metadataStatusList = metadataStatusRepository.findAll(MetadataStatusSpecs.hasUserId((int)oldOwner.getId()));
            for (MetadataStatus metadataStatus : metadataStatusList) {
                MetadataStatusId metadataStatusId = metadataStatus.getId();
                MetadataStatusId newMetadataStatusId = new MetadataStatusId();
                newMetadataStatusId.setUserId(newMetadataOwner.getId());
                newMetadataStatusId.setMetadataId(metadataStatusId.getMetadataId());
                newMetadataStatusId.setChangeDate(metadataStatusId.getChangeDate());
                metadataStatusId.setStatusId(metadataStatusId.getStatusId());
                MetadataStatus newMetadataStatus = new MetadataStatus();
                newMetadataStatus.setId(newMetadataStatusId);
                newMetadataStatus.setChangeMessage(metadataStatus.getChangeMessage());
                newMetadataStatus.setStatusValue(metadataStatus.getStatusValue());
                metadataStatusRepository.save((Object)newMetadataStatus);
            }
            metadataStatusRepository.deleteAllById_UserId(Integer.valueOf(oldOwner.getId()));
            metadataStatusRepository.save((Iterable)metadataStatusList);
            dataManager.indexMetadata(Lists.transform((List)metadataList, (Function)new Function<Metadata, String>(){

                @Nonnull
                public String apply(@Nullable Metadata input) {
                    return String.valueOf(input.getId());
                }
            }));
        }
    }

    void mergeGroups(ApplicationContext applicationContext, List<User> duplicatedUserList, User userToKeep) {
        GroupRepository groupRepository = (GroupRepository)applicationContext.getBean(GroupRepository.class);
        UserGroupRepository userGroupRepository = (UserGroupRepository)applicationContext.getBean(UserGroupRepository.class);
        HashSet<String> listOfAddedProfiles = new HashSet<String>();
        ArrayList<UserGroup> mergedUserGroups = new ArrayList<UserGroup>();
        ArrayList<Integer> userIdList = new ArrayList<Integer>(duplicatedUserList.size());
        for (int i = 0; i < duplicatedUserList.size(); ++i) {
            User userToProcess = duplicatedUserList.get(i);
            userIdList.add(userToProcess.getId());
            List userGroupsToProcess = userGroupRepository.findAll(UserGroupSpecs.hasUserId((int)userToProcess.getId()));
            if (Log.isDebugEnabled((String)"jeeves")) {
                Log.debug((String)"jeeves", (Object)("Groups of user {" + userToProcess.getId() + " - " + userToProcess.getUsername() + "}: " + userGroupsToProcess.size()));
                Log.debug((String)"jeeves", (Object)userGroupsToProcess);
            }
            for (UserGroup ug : userGroupsToProcess) {
                String key = ug.getProfile().name() + "#" + ug.getGroup().getId();
                if (listOfAddedProfiles.contains(key)) continue;
                listOfAddedProfiles.add(key);
            }
        }
        for (String key : listOfAddedProfiles) {
            String[] splitKey = StringUtils.split((String)key, (String)"#");
            String profileName = splitKey[0];
            Integer groupId = Integer.valueOf(splitKey[1]);
            Group group = (Group)groupRepository.findOne((Serializable)groupId);
            Profile profile = Profile.findProfileIgnoreCase((String)profileName);
            UserGroup userGroup = new UserGroup().setGroup(group).setProfile(profile).setUser(userToKeep);
            mergedUserGroups.add(userGroup);
        }
        userGroupRepository.deleteAllByIdAttribute(UserGroupId_.userId, userIdList);
        userGroupRepository.save(mergedUserGroups);
    }

    public User mergeUser(User toOverwrite, User toKeep) {
        ArrayList otherAddresses;
        if (StringUtils.isNotBlank((String)toKeep.getSurname())) {
            toOverwrite.setSurname(toKeep.getSurname());
        }
        if (StringUtils.isNotBlank((String)toKeep.getName())) {
            toOverwrite.setName(toKeep.getName());
        }
        if (StringUtils.isNotBlank((String)toKeep.getOrganisation())) {
            toOverwrite.setOrganisation(toKeep.getOrganisation());
        }
        if (StringUtils.isNotBlank((String)toKeep.getKind())) {
            toOverwrite.setKind(toKeep.getKind());
        }
        if (StringUtils.isNotBlank((String)toKeep.getProfile().name())) {
            toOverwrite.setProfile(toKeep.getProfile());
        }
        if (!toKeep.getEmailAddresses().isEmpty()) {
            toOverwrite.getEmailAddresses().clear();
            toOverwrite.getEmailAddresses().addAll(toKeep.getEmailAddresses());
        }
        if (!(otherAddresses = new ArrayList(toKeep.getAddresses())).isEmpty()) {
            block0: for (Address address : toOverwrite.getAddresses()) {
                boolean found = false;
                Iterator iterator2 = otherAddresses.iterator();
                while (iterator2.hasNext()) {
                    Address otherAddress = (Address)iterator2.next();
                    if (otherAddress.getId() != address.getId()) continue;
                    address.mergeAddress(otherAddress, false);
                    found = true;
                    iterator2.remove();
                    continue block0;
                }
            }
            toOverwrite.getAddresses().addAll(otherAddresses);
        }
        toOverwrite.getSecurity().mergeSecurity(toKeep.getSecurity(), false);
        return toOverwrite;
    }
}

