/*
 * Decompiled with CFR 0.152.
 */
package jeeves.transaction;

import java.util.Collection;
import javax.annotation.Nullable;
import javax.persistence.RollbackException;
import jeeves.transaction.AfterCommitTransactionListener;
import jeeves.transaction.AfterRollbackTransactionListener;
import jeeves.transaction.BeforeCommitTransactionListener;
import jeeves.transaction.BeforeRollbackTransactionListener;
import jeeves.transaction.NewTransactionListener;
import jeeves.transaction.TransactionTask;
import org.fao.geonet.utils.Log;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TransactionManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <V> V runInTransaction(String name, ApplicationContext context, TransactionRequirement transactionRequirement, CommitBehavior commitBehavior, boolean readOnly, TransactionTask<V> action) {
        V result;
        Throwable[] exception;
        block81: {
            boolean isCommitted;
            boolean isRolledBack;
            boolean isNewTransaction;
            TransactionStatus status;
            PlatformTransactionManager transactionManager;
            block77: {
                transactionManager = (PlatformTransactionManager)context.getBean(PlatformTransactionManager.class);
                exception = new Throwable[1];
                status = null;
                isNewTransaction = false;
                isRolledBack = false;
                isCommitted = false;
                result = null;
                DefaultTransactionDefinition definition = new DefaultTransactionDefinition(transactionRequirement.propagationId);
                definition.setName(name);
                definition.setReadOnly(readOnly);
                status = transactionManager.getTransaction((TransactionDefinition)definition);
                isNewTransaction = status.isNewTransaction();
                if (isNewTransaction) {
                    try {
                        TransactionManager.fireNewTransaction(context, transactionManager, status);
                    }
                    catch (Throwable t) {
                        Log.warning((String)"jeeves", (Object)"New transaction:", (Throwable)t);
                    }
                }
                result = action.doInTransaction(status);
                try {
                    if (readOnly && !isRolledBack) {
                        try {
                            TransactionManager.doRollback(context, transactionManager, status);
                            break block77;
                        }
                        finally {
                            isRolledBack = true;
                        }
                    }
                    if (isRolledBack || !isNewTransaction && commitBehavior != CommitBehavior.ALWAYS_COMMIT) break block77;
                    try {
                        TransactionManager.doCommit(context, transactionManager, status);
                    }
                    finally {
                        isCommitted = true;
                    }
                }
                catch (TransactionSystemException e) {
                    if (!(e.getOriginalException() instanceof RollbackException)) {
                        Log.error((String)"jeeves", (Object)"ERROR committing transaction, will try to rollback", (Throwable)e);
                        if (isRolledBack) break block77;
                        try {
                            TransactionManager.doRollback(context, transactionManager, status);
                        }
                        finally {
                            isRolledBack = true;
                        }
                    }
                    Log.debug((String)"jeeves", (Object)"ERROR committing transaction, will try to rollback", (Exception)((Object)e));
                    if (isRolledBack) break block77;
                    try {
                        TransactionManager.doRollback(context, transactionManager, status);
                    }
                    finally {
                        isRolledBack = true;
                    }
                }
                catch (Throwable t) {
                    Log.error((String)"jeeves", (Object)"ERROR committing transaction, will try to rollback", (Throwable)t);
                    if (isRolledBack) break block77;
                    try {
                        TransactionManager.doRollback(context, transactionManager, status);
                    }
                    finally {
                        isRolledBack = true;
                    }
                }
            }
            Log.debug((String)"jeeves", (Object)("Run in transaction completed:" + (isRolledBack ? " rolled back" : "") + (isCommitted ? " committed" : "")));
            if (!isRolledBack && !isCommitted) {
                Log.warning((String)"jeeves", (Object)"Run in transaction did not complete cleanly, transaction not committed or rolledback");
            }
            break block81;
            catch (Throwable e) {
                block79: {
                    try {
                        Log.error((String)"jeeves", (Object)"Error occurred within a transaction", (Throwable)e);
                        if (exception[0] == null) {
                            exception[0] = e;
                        }
                        try {
                            TransactionManager.doRollback(context, transactionManager, status);
                        }
                        finally {
                            isRolledBack = true;
                        }
                    }
                    catch (Throwable throwable) {
                        block80: {
                            try {
                                if (readOnly && !isRolledBack) {
                                    try {
                                        TransactionManager.doRollback(context, transactionManager, status);
                                        break block80;
                                    }
                                    finally {
                                        isRolledBack = true;
                                    }
                                }
                                if (isRolledBack || !isNewTransaction && commitBehavior != CommitBehavior.ALWAYS_COMMIT) break block80;
                                try {
                                    TransactionManager.doCommit(context, transactionManager, status);
                                }
                                finally {
                                    isCommitted = true;
                                }
                            }
                            catch (TransactionSystemException e2) {
                                if (!(e2.getOriginalException() instanceof RollbackException)) {
                                    Log.error((String)"jeeves", (Object)"ERROR committing transaction, will try to rollback", (Throwable)e2);
                                    if (isRolledBack) break block80;
                                    try {
                                        TransactionManager.doRollback(context, transactionManager, status);
                                        break block80;
                                    }
                                    finally {
                                        isRolledBack = true;
                                    }
                                }
                                Log.debug((String)"jeeves", (Object)"ERROR committing transaction, will try to rollback", (Exception)((Object)e2));
                                if (isRolledBack) break block80;
                                try {
                                    TransactionManager.doRollback(context, transactionManager, status);
                                }
                                finally {
                                    isRolledBack = true;
                                }
                            }
                            catch (Throwable t) {
                                Log.error((String)"jeeves", (Object)"ERROR committing transaction, will try to rollback", (Throwable)t);
                                if (isRolledBack) break block80;
                                try {
                                    TransactionManager.doRollback(context, transactionManager, status);
                                }
                                finally {
                                    isRolledBack = true;
                                }
                            }
                        }
                        Log.debug((String)"jeeves", (Object)("Run in transaction completed:" + (isRolledBack ? " rolled back" : "") + (isCommitted ? " committed" : "")));
                        if (!isRolledBack && !isCommitted) {
                            Log.warning((String)"jeeves", (Object)"Run in transaction did not complete cleanly, transaction not committed or rolledback");
                        }
                        throw throwable;
                    }
                    try {
                        if (readOnly && !isRolledBack) {
                            try {
                                TransactionManager.doRollback(context, transactionManager, status);
                                break block79;
                            }
                            finally {
                                isRolledBack = true;
                            }
                        }
                        if (isRolledBack || !isNewTransaction && commitBehavior != CommitBehavior.ALWAYS_COMMIT) break block79;
                        try {
                            TransactionManager.doCommit(context, transactionManager, status);
                        }
                        finally {
                            isCommitted = true;
                        }
                    }
                    catch (TransactionSystemException e3) {
                        if (!(e3.getOriginalException() instanceof RollbackException)) {
                            Log.error((String)"jeeves", (Object)"ERROR committing transaction, will try to rollback", (Throwable)e3);
                            if (isRolledBack) break block79;
                            try {
                                TransactionManager.doRollback(context, transactionManager, status);
                                break block79;
                            }
                            finally {
                                isRolledBack = true;
                            }
                        }
                        Log.debug((String)"jeeves", (Object)"ERROR committing transaction, will try to rollback", (Exception)((Object)e3));
                        if (isRolledBack) break block79;
                        try {
                            TransactionManager.doRollback(context, transactionManager, status);
                        }
                        finally {
                            isRolledBack = true;
                        }
                    }
                    catch (Throwable t) {
                        Log.error((String)"jeeves", (Object)"ERROR committing transaction, will try to rollback", (Throwable)t);
                        if (isRolledBack) break block79;
                        try {
                            TransactionManager.doRollback(context, transactionManager, status);
                        }
                        finally {
                            isRolledBack = true;
                        }
                    }
                }
                Log.debug((String)"jeeves", (Object)("Run in transaction completed:" + (isRolledBack ? " rolled back" : "") + (isCommitted ? " committed" : "")));
                if (!isRolledBack && !isCommitted) {
                    Log.warning((String)"jeeves", (Object)"Run in transaction did not complete cleanly, transaction not committed or rolledback");
                }
            }
        }
        if (exception[0] != null) {
            if (exception[0] instanceof RuntimeException) {
                throw (RuntimeException)exception[0];
            }
            if (exception[0] instanceof Error) {
                throw (Error)exception[0];
            }
            throw new RuntimeException("Run in transaction '" + action + "': " + exception[0].getLocalizedMessage(), exception[0]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doCommit(ApplicationContext context, PlatformTransactionManager transactionManager, TransactionStatus status) {
        try {
            TransactionManager.fireBeforeCommit(context, transactionManager, status);
        }
        catch (Throwable t) {
            Log.warning((String)"jeeves", (Object)"Commit transaction - before:", (Throwable)t);
        }
        if (status == null || status.isCompleted()) {
            Log.debug((String)"jeeves", (Object)"transactionManager.commit called unexpectedly when transaction is already completed ");
        }
        try {
            transactionManager.commit(status);
        }
        finally {
            try {
                TransactionManager.fireAfterCommit(context, transactionManager, status);
            }
            catch (Throwable t) {
                Log.warning((String)"jeeves", (Object)"Commit transaction - after:", (Throwable)t);
            }
        }
    }

    private static void fireAfterCommit(ApplicationContext context, PlatformTransactionManager transactionManager, @Nullable TransactionStatus status) throws Throwable {
        Throwable afterCommitFailure = null;
        Collection listeners = context.getBeansOfType(AfterCommitTransactionListener.class).values();
        for (AfterCommitTransactionListener listener : listeners) {
            try {
                listener.afterCommit(status);
            }
            catch (Throwable t) {
                Log.debug((String)"jeeves", (Object)("Listener " + listener.toString() + " newTransaction callback failed: " + t));
                afterCommitFailure = t;
            }
        }
        if (afterCommitFailure != null) {
            throw afterCommitFailure;
        }
    }

    private static void fireBeforeCommit(ApplicationContext context, PlatformTransactionManager transactionManager, @Nullable TransactionStatus status) throws Throwable {
        Throwable beforeCommitFailure = null;
        Collection listeners = context.getBeansOfType(BeforeCommitTransactionListener.class).values();
        for (BeforeCommitTransactionListener listener : listeners) {
            try {
                listener.beforeCommit(status);
            }
            catch (Throwable t) {
                Log.debug((String)"jeeves", (Object)("Listener " + listener.toString() + " newTransaction callback failed: " + t));
                beforeCommitFailure = t;
            }
        }
        if (beforeCommitFailure != null) {
            throw beforeCommitFailure;
        }
    }

    private static void fireNewTransaction(ApplicationContext context, PlatformTransactionManager transactionManager, @Nullable TransactionStatus status) throws Throwable {
        Throwable newTransactionFailure = null;
        Collection listeners = context.getBeansOfType(NewTransactionListener.class).values();
        for (NewTransactionListener listener : listeners) {
            try {
                listener.newTransaction(status);
            }
            catch (Throwable t) {
                Log.debug((String)"jeeves", (Object)("Listener " + listener.toString() + " newTransaction callback failed: " + t));
                newTransactionFailure = t;
            }
        }
        if (newTransactionFailure != null) {
            throw newTransactionFailure;
        }
    }

    private static void fireAfterRollback(ApplicationContext context, PlatformTransactionManager transactionManager, @Nullable TransactionStatus status) throws Throwable {
        Throwable afterRollbackFailure = null;
        Collection listeners = context.getBeansOfType(AfterRollbackTransactionListener.class).values();
        for (AfterRollbackTransactionListener listener : listeners) {
            try {
                listener.afterRollback(status);
            }
            catch (Throwable t) {
                Log.debug((String)"jeeves", (Object)("Listener " + listener.toString() + " afterRollback callback failed: " + t));
                afterRollbackFailure = t;
            }
        }
        if (afterRollbackFailure != null) {
            throw afterRollbackFailure;
        }
    }

    private static void fireBeforeRollback(ApplicationContext context, PlatformTransactionManager transactionManager, @Nullable TransactionStatus status) throws Throwable {
        Throwable beforeRollbackFailure = null;
        Collection listeners = context.getBeansOfType(BeforeRollbackTransactionListener.class).values();
        for (BeforeRollbackTransactionListener listener : listeners) {
            try {
                listener.beforeRollback(status);
            }
            catch (Throwable t) {
                Log.debug((String)"jeeves", (Object)("Listener " + listener.toString() + " beforeRollback callback failed: " + t));
                beforeRollbackFailure = t;
            }
        }
        if (beforeRollbackFailure != null) {
            throw beforeRollbackFailure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRollback(ApplicationContext context, PlatformTransactionManager transactionManager, @Nullable TransactionStatus status) {
        if (status == null || status.isCompleted()) {
            return;
        }
        try {
            TransactionManager.fireBeforeRollback(context, transactionManager, status);
        }
        catch (Throwable t) {
            Log.warning((String)"jeeves", (Object)"Rolling back transaction - before:", (Throwable)t);
        }
        try {
            transactionManager.rollback(status);
        }
        catch (Throwable t) {
            Log.error((String)"jeeves", (Object)"ERROR rolling back transaction", (Throwable)t);
        }
        finally {
            try {
                TransactionManager.fireAfterRollback(context, transactionManager, status);
            }
            catch (Throwable t) {
                Log.warning((String)"jeeves", (Object)"Rolling back transaction - after:", (Throwable)t);
            }
        }
    }

    public static enum CommitBehavior {
        ALWAYS_COMMIT,
        ONLY_COMMIT_NEWLY_CREATED_TRANSACTIONS;

    }

    public static enum TransactionRequirement {
        CREATE_ONLY_WHEN_NEEDED(0),
        THROW_EXCEPTION_IF_NOT_PRESENT(2),
        CREATE_NEW(3);

        private final int propagationId;

        private TransactionRequirement(int propagation) {
            this.propagationId = propagation;
        }
    }
}

