/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.context;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import jeeves.monitor.MonitorManager;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.fao.geonet.Logger;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.Log;
import org.springframework.context.ConfigurableApplicationContext;

public class BasicContext
implements Logger {
    private final ConfigurableApplicationContext jeevesApplicationContext;
    protected Logger logger = Log.createLogger((String)"jeeves");
    protected Map<String, Object> htContexts;
    private String baseUrl;
    private EntityManager entityManager;

    public BasicContext(ConfigurableApplicationContext jeevesApplicationContext, Map<String, Object> contexts, EntityManager entityManager) {
        this.jeevesApplicationContext = jeevesApplicationContext;
        this.htContexts = Collections.unmodifiableMap(contexts);
        this.entityManager = entityManager;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String name) {
        this.baseUrl = name;
    }

    public Path getAppPath() {
        return ((GeonetworkDataDirectory)this.jeevesApplicationContext.getBean(GeonetworkDataDirectory.class)).getWebappDir();
    }

    public Object getHandlerContext(String contextName) {
        return this.htContexts.get(contextName);
    }

    public MonitorManager getMonitorManager() {
        return this.getBean(MonitorManager.class);
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.jeevesApplicationContext;
    }

    @Nonnull
    public <T> T getBean(Class<T> beanType) {
        return (T)this.jeevesApplicationContext.getBean(beanType);
    }

    @Nonnull
    public <T> T getBean(String name, Class<T> beanType) {
        return (T)this.jeevesApplicationContext.getBean(name, beanType);
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String message) {
        this.logger.debug(message);
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void warning(String message) {
        this.logger.warning(message);
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public void error(Throwable ex) {
        this.logger.error(ex);
    }

    public void fatal(String message) {
        this.logger.fatal(message);
    }

    public String getModule() {
        return this.logger.getModule();
    }

    public void setAppender(FileAppender fa) {
        this.logger.setAppender(fa);
    }

    public String getFileAppender() {
        return this.logger.getFileAppender();
    }

    public Level getThreshold() {
        return this.logger.getThreshold();
    }

    public String getNodeId() {
        try {
            return ((NodeInfo)this.jeevesApplicationContext.getBean(NodeInfo.class)).getId();
        }
        catch (Exception exception) {
            return "srv";
        }
    }
}

