/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.SettingDataType;
import org.fao.geonet.domain.SettingToObjectSerializer;
import org.fao.geonet.entitylistener.SettingEntityListenerManager;
import org.hibernate.annotations.Type;

@Entity
@Table(name="Settings")
@Cacheable
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={SettingEntityListenerManager.class})
@JsonSerialize(using=SettingToObjectSerializer.class)
public class Setting
extends GeonetEntity {
    private String name;
    private String value;
    private SettingDataType dataType = SettingDataType.STRING;
    private int position = 0;
    private char internal = (char)121;

    @Id
    @Column(name="name", nullable=false, length=255)
    public String getName() {
        return this.name;
    }

    public Setting setName(String name) {
        this.name = name;
        return this;
    }

    @Lob
    @Column(name="value", nullable=true)
    @Type(type="org.hibernate.type.StringClobType")
    public String getValue() {
        return this.value;
    }

    public Setting setValue(String value) {
        this.value = value;
        return this;
    }

    @Column(name="datatype")
    public SettingDataType getDataType() {
        return this.dataType;
    }

    public Setting setDataType(SettingDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Column(name="position", nullable=false, columnDefinition="int default 0")
    public int getPosition() {
        return this.position;
    }

    public Setting setPosition(int position) {
        this.position = position;
        return this;
    }

    @Column(name="internal", nullable=false, length=1, columnDefinition="char default 'y'")
    protected char getInternal_JpaWorkaround() {
        return this.internal;
    }

    protected void setInternal_JpaWorkaround(char internalValue) {
        this.internal = internalValue;
    }

    @Transient
    public boolean isInternal() {
        return Constants.toBoolean_fromYNChar(this.getInternal_JpaWorkaround());
    }

    public Setting setInternal(boolean internal) {
        this.setInternal_JpaWorkaround(Constants.toYN_EnabledChar(internal));
        return this;
    }

    public String toString() {
        return "Setting{'" + this.name + "' = '" + this.value + "'}";
    }
}

