/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.MetadataNotificationAction;
import org.fao.geonet.domain.MetadataNotificationId;
import org.fao.geonet.entitylistener.MetadataNotificationEntityListenerManager;
import org.hibernate.annotations.Type;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="MetadataNotifications")
@EntityListeners(value={MetadataNotificationEntityListenerManager.class})
public class MetadataNotification
extends GeonetEntity {
    private MetadataNotificationId _id;
    private char _notified = (char)110;
    private String _metadataUuid;
    private MetadataNotificationAction _action;
    private String _errorMessage;

    @EmbeddedId
    public MetadataNotificationId getId() {
        return this._id;
    }

    public MetadataNotification setId(MetadataNotificationId id) {
        this._id = id;
        return this;
    }

    @Column(name="notified", length=1, nullable=false)
    protected char getNotified_JPAWorkaround() {
        return this._notified;
    }

    protected void setNotified_JPAWorkaround(char notified) {
        this._notified = notified;
    }

    @Transient
    public boolean isNotified() {
        return Constants.toBoolean_fromYNChar(this.getNotified_JPAWorkaround());
    }

    public MetadataNotification setNotified(boolean notified) {
        this.setNotified_JPAWorkaround(Constants.toYN_EnabledChar(notified));
        return this;
    }

    @Column(name="metadataUuid", nullable=false)
    public String getMetadataUuid() {
        return this._metadataUuid;
    }

    public MetadataNotification setMetadataUuid(String metadataUuid) {
        this._metadataUuid = metadataUuid;
        return this;
    }

    @Column(length=1, nullable=false)
    public MetadataNotificationAction getAction() {
        return this._action;
    }

    public MetadataNotification setAction(MetadataNotificationAction action) {
        this._action = action;
        return this;
    }

    @Lob
    @Column(name="errormsg")
    @Type(type="org.hibernate.type.StringClobType")
    public String getErrorMessage() {
        return this._errorMessage;
    }

    public MetadataNotification setErrorMessage(String errorMessage) {
        this._errorMessage = errorMessage;
        return this;
    }
}

