/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.geotools.data.wfs.WFSServiceInfo;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_DataStore;
import org.geotools.util.logging.Logging;

final class CapabilitiesServiceInfo
implements WFSServiceInfo {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");
    private static URI WFS_1_1_0_SCHEMA_URI;
    private WFS_1_1_0_DataStore wfs;

    public CapabilitiesServiceInfo(WFS_1_1_0_DataStore service) {
        this.wfs = service;
    }

    @Override
    public String getDescription() {
        return this.wfs.getServiceAbstract();
    }

    public Icon getIcon() {
        return null;
    }

    @Override
    public Set<String> getKeywords() {
        return this.wfs.getServiceKeywords();
    }

    @Override
    public URI getPublisher() {
        return this.wfs.getServiceProviderUri();
    }

    @Override
    public URI getSchema() {
        return WFS_1_1_0_SCHEMA_URI;
    }

    @Override
    public URI getSource() {
        URL url = this.wfs.getCapabilitiesURL();
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "converting to URI: " + url.toExternalForm());
            return null;
        }
    }

    @Override
    public String getTitle() {
        return this.wfs.getServiceTitle();
    }

    @Override
    public String getVersion() {
        return this.wfs.getServiceVersion();
    }

    static {
        try {
            WFS_1_1_0_SCHEMA_URI = new URI("http://schemas.opengis.net/wfs/1.1.0/wfs.xsd");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

