/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.opts;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pvalsecc.opts.InvalidOption;
import org.pvalsecc.opts.Option;

public class GetOptions {
    private static Pattern BOOLEAN = Pattern.compile("^--([^=]+)$");
    private static Pattern OTHER = Pattern.compile("^--([^=]+)=(.+)$");

    public static List<String> parse(String[] args, Object dest) throws InvalidOption {
        ArrayList<String> remaining = new ArrayList<String>(5);
        HashSet<String> seen = new HashSet<String>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String name;
                String arg = args[i];
                Matcher bool = BOOLEAN.matcher(arg);
                Matcher other = OTHER.matcher(arg);
                if (bool.matches()) {
                    name = bool.group(1);
                    GetOptions.handleBoolean(dest, name);
                    seen.add(name);
                    continue;
                }
                if (other.matches()) {
                    name = other.group(1);
                    String value = other.group(2);
                    GetOptions.handleOther(dest, name, value);
                    seen.add(name);
                    continue;
                }
                remaining.add(arg);
            }
        }
        GetOptions.checkMandatory(dest, dest.getClass(), seen);
        return remaining;
    }

    public static String getShortList(Object dest) {
        StringBuilder result = new StringBuilder();
        Class<?> aClass = dest.getClass();
        GetOptions.getShortList(result, aClass);
        return result.toString();
    }

    public static String getLongList(Object dest) throws IllegalAccessException {
        StringBuilder result = new StringBuilder();
        Class<?> aClass = dest.getClass();
        GetOptions.getLongList(dest, result, aClass);
        return result.toString();
    }

    private static void checkMandatory(Object dest, Class<?> aClass, Set<String> seen) throws InvalidOption {
        if (aClass == Object.class) {
            return;
        }
        GetOptions.checkMandatory(dest, aClass.getSuperclass(), seen);
        for (Field field : aClass.getDeclaredFields()) {
            Option annotation = field.getAnnotation(Option.class);
            String name = field.getName();
            if (annotation == null || seen.contains(name)) continue;
            if (annotation.environment().length() == 0) {
                if (!annotation.mandatory()) continue;
                throw new InvalidOption("Mandatory option missing: " + name);
            }
            String env = System.getenv(annotation.environment());
            if (env != null) {
                GetOptions.handleOther(dest, field.getName(), env);
                continue;
            }
            if (!annotation.mandatory()) continue;
            throw new InvalidOption("Mandatory option missing: " + name);
        }
    }

    private static void getShortList(StringBuilder result, Class<?> aClass) {
        if (aClass == Object.class) {
            return;
        }
        GetOptions.getShortList(result, aClass.getSuperclass());
        for (Field field : aClass.getDeclaredFields()) {
            Option annotation = field.getAnnotation(Option.class);
            if (annotation == null) continue;
            if (result.length() > 0) {
                result.append(' ');
            }
            if (!annotation.mandatory()) {
                result.append("[");
            }
            if (field.getType() == Boolean.TYPE) {
                result.append("--").append(field.getName());
            } else {
                result.append("--").append(field.getName()).append("={value}");
            }
            if (annotation.mandatory()) continue;
            result.append("]");
        }
    }

    private static void getLongList(Object dest, StringBuilder result, Class<?> aClass) throws IllegalAccessException {
        if (aClass == Object.class) {
            return;
        }
        GetOptions.getLongList(dest, result, aClass.getSuperclass());
        for (Field field : aClass.getDeclaredFields()) {
            Option annotation = field.getAnnotation(Option.class);
            if (annotation == null) continue;
            if (result.length() > 0) {
                result.append('\n');
            }
            if (field.getType() == Boolean.TYPE) {
                result.append("  --").append(field.getName());
            } else {
                result.append("  --").append(field.getName()).append("={").append(field.getType().getSimpleName()).append("}");
            }
            result.append(": ").append(annotation.desc());
            if (annotation.mandatory()) continue;
            field.setAccessible(true);
            result.append(" (defaults to [").append(field.get(dest)).append("])");
        }
    }

    private static void handleBoolean(Object dest, String name) throws InvalidOption {
        try {
            Field opt = GetOptions.getField(dest, name);
            if (opt.getAnnotation(Option.class) == null) {
                throw new InvalidOption("'" + name + "' is not an option");
            }
            opt.setAccessible(true);
            opt.setBoolean(dest, true);
        }
        catch (Exception e) {
            throw new InvalidOption("Unknown option '" + name + "'", e);
        }
    }

    private static void handleOther(Object dest, String name, String value) throws InvalidOption {
        block16: {
            try {
                Field opt = GetOptions.getField(dest, name);
                if (opt.getAnnotation(Option.class) == null) {
                    throw new InvalidOption("'" + name + "' is not an option");
                }
                opt.setAccessible(true);
                if (opt.getType() == Integer.TYPE) {
                    opt.setInt(dest, Integer.parseInt(value));
                    break block16;
                }
                if (opt.getType() == Double.TYPE) {
                    opt.setDouble(dest, Double.parseDouble(value));
                    break block16;
                }
                if (opt.getType() == Float.TYPE) {
                    opt.setFloat(dest, Float.parseFloat(value));
                    break block16;
                }
                if (opt.getType() == Boolean.TYPE) {
                    opt.setBoolean(dest, Boolean.parseBoolean(value));
                    break block16;
                }
                if (opt.getType() == String.class) {
                    opt.set(dest, value);
                    break block16;
                }
                if (opt.getType() == Integer.class) {
                    if (value.equalsIgnoreCase("null")) {
                        opt.set(dest, null);
                    } else {
                        opt.set(dest, Integer.parseInt(value));
                    }
                    break block16;
                }
                if (Enum.class.isAssignableFrom(opt.getType())) {
                    opt.set(dest, Enum.valueOf(opt.getType(), value.toUpperCase()));
                    break block16;
                }
                if (Collection.class.isAssignableFrom(opt.getType())) {
                    ((Collection)opt.get(dest)).add(value);
                    break block16;
                }
                throw new InvalidOption("Unknown type for option " + name + ": " + opt.getType());
            }
            catch (NoSuchFieldException e) {
                throw new InvalidOption("Unknown option " + name, e);
            }
            catch (IllegalAccessException e) {
                throw new InvalidOption("Unknown option " + name, e);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidOption("Unknown value [" + value + "] for option " + name, e);
            }
            catch (RuntimeException e) {
                throw new InvalidOption("Unknown option " + name, e);
            }
        }
    }

    private static Field getField(Object dest, String name) throws NoSuchFieldException {
        Field field = GetOptions.getField(name, dest.getClass());
        if (field == null) {
            throw new NoSuchFieldException("name");
        }
        return field;
    }

    private static Field getField(String name, Class<?> aClass) {
        Field result = null;
        try {
            result = aClass.getDeclaredField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (result == null && aClass != Object.class) {
            result = GetOptions.getField(name, aClass.getSuperclass());
        }
        return result;
    }
}

