/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class FileUtilities {
    public static String readWholeTextStream(InputStream in) throws IOException {
        int actual;
        int size = in.available();
        StringBuilder result = new StringBuilder(size);
        byte[] b = new byte[size];
        while ((actual = in.read(b, 0, size)) >= 0) {
            if (actual <= 0) continue;
            result.append(new String(b, 0, actual));
        }
        return result.toString();
    }

    public static String readWholeTextStream(InputStream in, String encoding) throws IOException {
        int actual;
        int size = 1024;
        StringBuilder result = new StringBuilder(1024);
        byte[] b = new byte[1024];
        while ((actual = in.read(b, 0, 1024)) >= 0) {
            if (actual <= 0) continue;
            result.append(new String(b, 0, actual, encoding));
        }
        return result.toString();
    }

    public static String readWholeTextFile(File file) throws IOException {
        return FileUtilities.readWholeTextStream(new FileInputStream(file));
    }

    public static String readWholeTextFile(File file, String encoding) throws IOException {
        return FileUtilities.readWholeTextStream(new FileInputStream(file), encoding);
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int size;
        byte[] b = new byte[4096];
        while ((size = in.read(b)) > 0) {
            out.write(b, 0, size);
        }
    }
}

