/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.javascript.jscomp.newtypes.PersistentSet;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;

final class ClojurePersistentHashSet<K>
extends PersistentSet<K> {
    private static Method cons;
    private static Method disjoin;
    private final Set set;

    private ClojurePersistentHashSet(Set s) {
        this.set = s;
    }

    public static <K> PersistentSet<K> create(Class<? extends Set> cls) {
        try {
            cons = cls.getDeclaredMethod("cons", Object.class);
            disjoin = cls.getDeclaredMethod("disjoin", Object.class);
            Set m = (Set)cls.getDeclaredField("EMPTY").get(null);
            return new ClojurePersistentHashSet<K>(m);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PersistentSet<K> with(K key) {
        try {
            Set s = (Set)cons.invoke((Object)this.set, key);
            return new ClojurePersistentHashSet<K>(s);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PersistentSet<K> without(K key) {
        try {
            Set s = (Set)disjoin.invoke((Object)this.set, key);
            return new ClojurePersistentHashSet<K>(s);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean contains(Object key) {
        return this.set.contains(key);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<K> iterator() {
        return this.set.iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ClojurePersistentHashSet) {
            ClojurePersistentHashSet ps = (ClojurePersistentHashSet)o;
            return this.set.equals(ps.set);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }
}

