/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import java.net.Socket;
import java.util.Vector;

class ChannelForwardedTCPIP
extends Channel {
    static Vector pool = new Vector();
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    String host;
    int lport;
    int rport;

    ChannelForwardedTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
    }

    void init() {
        try {
            Socket socket = new Socket(this.host, this.lport);
            socket.setTcpNoDelay(true);
            this.io = new IO();
            this.io.setInputStream(socket.getInputStream());
            this.io.setOutputStream(socket.getOutputStream());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void run() {
        this.thread = this;
        Buffer buffer = new Buffer(this.rmpsize);
        Packet packet = new Packet(buffer);
        int n = 0;
        try {
            while (this.thread != null && this.io.in != null && (n = this.io.in.read(buffer.buffer, 14, buffer.buffer.length - 14 - 16 - 20)) > 0) {
                packet.reset();
                if (!this.close) {
                    buffer.putByte((byte)94);
                    buffer.putInt(this.recipient);
                    buffer.putInt(n);
                    buffer.skip(n);
                    this.session.write(packet, this, n);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.thread = null;
        this.eof();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getData(Buffer buffer) {
        this.setRecipient(buffer.getInt());
        this.setRemoteWindowSize(buffer.getInt());
        this.setRemotePacketSize(buffer.getInt());
        byte[] byArray = buffer.getString();
        int n = buffer.getInt();
        byte[] byArray2 = buffer.getString();
        int n2 = buffer.getInt();
        Vector vector = pool;
        synchronized (vector) {
            for (int i = 0; i < pool.size(); ++i) {
                Object[] objectArray = (Object[])pool.elementAt(i);
                if (objectArray[0] != this.session || (Integer)objectArray[1] != n) continue;
                this.rport = n;
                this.host = (String)objectArray[2];
                this.lport = (Integer)objectArray[3];
                break;
            }
            if (this.host == null) {
                System.out.println("??");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object[] getPort(Session session, int n) {
        Vector vector = pool;
        synchronized (vector) {
            Object var3_3 = null;
            for (int i = 0; i < pool.size(); ++i) {
                Object[] objectArray = (Object[])pool.elementAt(i);
                if (objectArray[0] != session || (Integer)objectArray[1] != n) continue;
                return objectArray;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = pool;
        synchronized (pool) {
            int n;
            for (n = 0; n < pool.size(); ++n) {
                Object[] objectArray = (Object[])pool.elementAt(n);
                if (objectArray[0] != session) continue;
                vector.addElement(objectArray[1] + ":" + objectArray[2] + ":" + objectArray[3]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, int n, String string, int n2) throws JSchException {
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, n) != null) {
                throw new JSchException("PortForwardingR: remote port " + n + " is already registered.");
            }
            Object[] objectArray = new Object[]{session, new Integer(n), string, new Integer(n2)};
            pool.addElement(objectArray);
        }
    }

    static void delPort(ChannelForwardedTCPIP channelForwardedTCPIP) {
        ChannelForwardedTCPIP.delPort(channelForwardedTCPIP.session, channelForwardedTCPIP.rport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session, int n) {
        Object object;
        Object object2 = pool;
        synchronized (object2) {
            object = null;
            for (int i = 0; i < pool.size(); ++i) {
                Object[] objectArray = (Object[])pool.elementAt(i);
                if (objectArray[0] != session || (Integer)objectArray[1] != n) continue;
                object = objectArray;
                break;
            }
            if (object == null) {
                return;
            }
            pool.removeElement(object);
        }
        object2 = new Buffer(100);
        object = new Packet((Buffer)object2);
        try {
            ((Packet)object).reset();
            ((Buffer)object2).putByte((byte)80);
            ((Buffer)object2).putString("cancel-tcpip-forward".getBytes());
            ((Buffer)object2).putByte((byte)0);
            ((Buffer)object2).putString("0.0.0.0".getBytes());
            ((Buffer)object2).putInt(n);
            session.write((Packet)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void delPort(Session session) {
        for (int i = 0; i < pool.size(); ++i) {
            Object[] objectArray = (Object[])pool.elementAt(i);
            if (objectArray[0] != session) continue;
            pool.removeElement(objectArray);
            --i;
        }
    }
}

