/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.ChannelSubsystem;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.RequestSignal;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

public abstract class Channel
implements Runnable {
    static int index = 0;
    private static Vector pool = new Vector();
    int id;
    int recipient = -1;
    byte[] type = "foo".getBytes();
    int lwsize_max;
    int lwsize = this.lwsize_max = 0x100000;
    int lmpsize = 16384;
    int rwsize = 0;
    int rmpsize = 0;
    IO io = null;
    Runnable thread = null;
    boolean eof = false;
    boolean close = false;
    int exitstatus = -1;
    Session session;

    static Channel getChannel(String string) {
        if (string.equals("session")) {
            return new ChannelSession();
        }
        if (string.equals("shell")) {
            return new ChannelShell();
        }
        if (string.equals("exec")) {
            return new ChannelExec();
        }
        if (string.equals("x11")) {
            return new ChannelX11();
        }
        if (string.equals("direct-tcpip")) {
            return new ChannelDirectTCPIP();
        }
        if (string.equals("forwarded-tcpip")) {
            return new ChannelForwardedTCPIP();
        }
        if (string.equals("sftp")) {
            return new ChannelSftp();
        }
        if (string.equals("subsystem")) {
            return new ChannelSubsystem();
        }
        return null;
    }

    static Channel getChannel(int n, Session session) {
        for (int i = 0; i < pool.size(); ++i) {
            Channel channel = (Channel)pool.elementAt(i);
            if (channel.id != n || channel.session != session) continue;
            return channel;
        }
        return null;
    }

    static void del(Channel channel) {
        pool.removeElement(channel);
    }

    Channel() {
        this.id = index++;
        pool.addElement(this);
    }

    void setRecipient(int n) {
        this.recipient = n;
    }

    int getRecipient() {
        return this.recipient;
    }

    void init() {
    }

    public void connect() throws JSchException {
        block8: {
            if (!this.session.isConnected()) {
                throw new JSchException("session is down");
            }
            try {
                int n;
                Buffer buffer = new Buffer(100);
                Packet packet = new Packet(buffer);
                packet.reset();
                buffer.putByte((byte)90);
                buffer.putString(this.type);
                buffer.putInt(this.id);
                buffer.putInt(this.lwsize);
                buffer.putInt(this.lmpsize);
                this.session.write(packet);
                for (n = 100; this.getRecipient() == -1 && this.session.isConnected() && n > 0; --n) {
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!this.session.isConnected()) {
                    throw new JSchException("session is down");
                }
                if (n == 0) {
                    throw new JSchException("channel is not opened.");
                }
                this.start();
            }
            catch (Exception exception) {
                if (!(exception instanceof JSchException)) break block8;
                throw (JSchException)exception;
            }
        }
    }

    public void setXForwarding(boolean bl) {
    }

    void start() {
    }

    public boolean isEOF() {
        return this.eof;
    }

    void getData(Buffer buffer) {
        this.setRecipient(buffer.getInt());
        this.setRemoteWindowSize(buffer.getInt());
        this.setRemotePacketSize(buffer.getInt());
    }

    public void setInputStream(InputStream inputStream) {
        this.io.setInputStream(inputStream);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.io.setOutputStream(outputStream);
    }

    public InputStream getInputStream() throws IOException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        this.io.setOutputStream(new PassiveOutputStream(pipedInputStream));
        return pipedInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        this.io.setInputStream(new PassiveInputStream(pipedOutputStream));
        return pipedOutputStream;
    }

    void setLocalWindowSizeMax(int n) {
        this.lwsize_max = n;
    }

    void setLocalWindowSize(int n) {
        this.lwsize = n;
    }

    void setLocalPacketSize(int n) {
        this.lmpsize = n;
    }

    void setRemoteWindowSize(int n) {
        this.rwsize = n;
    }

    void addRemoteWindowSize(int n) {
        this.rwsize += n;
    }

    void setRemotePacketSize(int n) {
        this.rmpsize = n;
    }

    public void run() {
    }

    void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.eof) {
            return;
        }
        if (this.io.out != null) {
            this.io.put(byArray, n, n2);
        }
    }

    void eof() {
        if (this.eof) {
            return;
        }
        this.eof = true;
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)96);
            buffer.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void close() {
        if (this.close) {
            return;
        }
        this.close = true;
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)97);
            buffer.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void eof(Session session) {
        for (int i = 0; i < pool.size(); ++i) {
            try {
                Channel channel = (Channel)pool.elementAt(i);
                if (channel.session != session) continue;
                channel.eof();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void disconnect() {
        block8: {
            this.close();
            this.thread = null;
            try {
                if (this.io == null) break block8;
                try {
                    if (this.io.in != null && this.io.in instanceof PassiveInputStream) {
                        this.io.in.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.io.out != null && this.io.out instanceof PassiveOutputStream) {
                        this.io.out.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.io = null;
        Channel.del(this);
    }

    public void sendSignal(String string) throws Exception {
        RequestSignal requestSignal = new RequestSignal();
        requestSignal.setSignal(string);
        requestSignal.request(this.session, this);
    }

    void setExitStatus(int n) {
        this.exitstatus = n;
    }

    public int getExitStatus() {
        return this.exitstatus;
    }

    void setSession(Session session) {
        this.session = session;
    }

    class PassiveOutputStream
    extends PipedOutputStream {
        PassiveOutputStream(PipedInputStream pipedInputStream) throws IOException {
            super(pipedInputStream);
        }
    }

    class PassiveInputStream
    extends PipedInputStream {
        PipedOutputStream out;

        PassiveInputStream(PipedOutputStream pipedOutputStream) throws IOException {
            super(pipedOutputStream);
            this.out = pipedOutputStream;
        }

        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
    }
}

