/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.util.HashMap;
import java.util.Map;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.builder.AbstractStyleBuilder;
import org.geotools.styling.builder.StyleBuilder;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ContrastMethod;

public class ContrastEnhancementBuilder
extends AbstractStyleBuilder<ContrastEnhancement> {
    private Expression gamma = null;
    private ContrastMethod method;
    private Map<String, Expression> options = new HashMap<String, Expression>();

    public ContrastEnhancementBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public ContrastEnhancementBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public ContrastEnhancementBuilder gamma(Expression gamma) {
        this.gamma = gamma;
        this.unset = false;
        return this;
    }

    public ContrastEnhancementBuilder gamma(double gamma) {
        return this.gamma(this.literal(gamma));
    }

    public ContrastEnhancementBuilder normalize(Map<String, Expression> constrastParameters) {
        return this.contrastMethod("normalize", constrastParameters);
    }

    public ContrastEnhancementBuilder histogram(Map<String, Expression> constrastParameters) {
        return this.contrastMethod("histogram", constrastParameters);
    }

    public ContrastEnhancementBuilder exponential(Map<String, Expression> constrastParameters) {
        return this.contrastMethod("exponential", constrastParameters);
    }

    public ContrastEnhancementBuilder logarithmic(Map<String, Expression> constrastParameters) {
        return this.contrastMethod("logarithm", constrastParameters);
    }

    private ContrastEnhancementBuilder contrastMethod(String name, Map<String, Expression> constrastParameters) {
        this.method = ContrastMethod.valueOf((String)name);
        if (constrastParameters != null) {
            this.options = constrastParameters;
        }
        this.unset = false;
        return this;
    }

    public ContrastEnhancementBuilder gamma(String cqlExpression) {
        return this.gamma(this.cqlExpression(cqlExpression));
    }

    @Override
    public ContrastEnhancement build() {
        if (this.unset) {
            return null;
        }
        ContrastEnhancement contrastEnhancement = this.sf.contrastEnhancement(this.gamma, this.method);
        contrastEnhancement.setOptions(this.options);
        return contrastEnhancement;
    }

    public ContrastEnhancementBuilder reset() {
        this.gamma = null;
        this.method = null;
        this.unset = false;
        return this;
    }

    public ContrastEnhancementBuilder reset(ContrastEnhancement contrastEnhancement) {
        if (contrastEnhancement == null) {
            return this.reset();
        }
        this.gamma = contrastEnhancement.getGammaValue();
        this.method = contrastEnhancement.getMethod();
        this.options = contrastEnhancement.getOptions();
        this.unset = false;
        return this;
    }

    @Override
    public ContrastEnhancementBuilder unset() {
        return (ContrastEnhancementBuilder)super.unset();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        throw new UnsupportedOperationException("Cannot build a meaningful style out of a contrast enhancement alone");
    }

    public ContrastEnhancementBuilder normalize() {
        return this.contrastMethod("normalize", null);
    }

    public ContrastEnhancementBuilder histogram() {
        return this.contrastMethod("histogram", null);
    }

    public ContrastEnhancementBuilder logarithmic() {
        return this.contrastMethod("logarithmic", null);
    }

    public ContrastEnhancementBuilder exponential() {
        return this.contrastMethod("exponential", null);
    }
}

