/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.util.xml.SimpleSAXListener;
import org.openrdf.util.xml.XMLReaderFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleSAXParser {
    private XMLReader _xmlReader;
    private SimpleSAXListener _listener;

    public SimpleSAXParser(XMLReader xmlReader) {
        this._xmlReader = xmlReader;
    }

    public SimpleSAXParser() throws SAXException {
        this(XMLReaderFactory.createXMLReader());
    }

    public void setListener(SimpleSAXListener listener) {
        this._listener = listener;
    }

    public SimpleSAXListener getListener() {
        return this._listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File file) throws SAXException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            this.parse(in);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void parse(InputStream in) throws SAXException, IOException {
        this._parse(new InputSource(in));
    }

    public void parse(Reader reader) throws SAXException, IOException {
        this._parse(new InputSource(reader));
    }

    private synchronized void _parse(InputSource inputSource) throws SAXException, IOException {
        this._xmlReader.setContentHandler(new SimpleSAXDefaultHandler());
        this._xmlReader.parse(inputSource);
    }

    class SimpleSAXDefaultHandler
    extends DefaultHandler {
        private StringBuffer _charBuf = new StringBuffer(512);
        private String _deferredStartTag = null;
        private Map _deferredAttributes = null;

        public void startDocument() throws SAXException {
            SimpleSAXParser.this._listener.startDocument();
        }

        public void endDocument() throws SAXException {
            SimpleSAXParser.this._listener.endDocument();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this._charBuf.append(ch, start, length);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
            if (this._deferredStartTag != null) {
                this._reportDeferredStartElement();
            }
            this._deferredStartTag = qName;
            int attCount = attributes.getLength();
            if (attCount == 0) {
                this._deferredAttributes = Collections.EMPTY_MAP;
            } else {
                this._deferredAttributes = new HashMap(attCount * 2);
                for (int i = 0; i < attCount; ++i) {
                    this._deferredAttributes.put(attributes.getQName(i), attributes.getValue(i));
                }
            }
            this._charBuf.setLength(0);
        }

        private void _reportDeferredStartElement() throws SAXException {
            SimpleSAXParser.this._listener.startTag(this._deferredStartTag, this._deferredAttributes, "");
            this._deferredStartTag = null;
            this._deferredAttributes = null;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this._deferredStartTag != null) {
                String text = this._charBuf.toString().trim();
                SimpleSAXParser.this._listener.startTag(this._deferredStartTag, this._deferredAttributes, text);
                this._deferredStartTag = null;
                this._deferredAttributes = null;
            }
            SimpleSAXParser.this._listener.endTag(qName);
            this._charBuf.setLength(0);
        }
    }
}

