/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import org.dlib.gui.CustomLook;

public class TTextArea
extends JScrollPane {
    private JTextArea txtArea;

    public TTextArea() {
        this(10, 10);
    }

    public TTextArea(int n, int n2) {
        this("", n, n2);
    }

    public TTextArea(String string, int n, int n2) {
        this(string, n, n2, false);
    }

    public TTextArea(String string, int n, int n2, boolean bl) {
        this.txtArea = new JTextArea("", n, n2){

            public void paintComponent(Graphics graphics) {
                CustomLook.setup(graphics);
                super.paintComponent(graphics);
            }
        };
        this.setViewportView(this.txtArea);
        this.txtArea.setTabSize(3);
        this.txtArea.setLineWrap(true);
        this.txtArea.setWrapStyleWord(true);
        this.txtArea.setFont(CustomLook.defaultFont);
        this.setBorder(BorderFactory.createEtchedBorder(Color.white, Color.gray));
        this.setText(string);
        if (bl) {
            this.setEditable(false);
            this.setTextBackground(new Color(204, 204, 204));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
    }

    public void setToolTipText(String string) {
        this.txtArea.setToolTipText(string);
    }

    public void scrollToTop() {
        this.getViewport().scrollRectToVisible(new Rectangle(0, 0, 10, 10));
    }

    public void setText(String string) {
        this.txtArea.setText(string);
    }

    public String getText() {
        return this.txtArea.getText();
    }

    public void append(String string) {
        this.txtArea.append(string);
    }

    public void setEditable(boolean bl) {
        this.txtArea.setEditable(bl);
    }

    public void setLineWrap(boolean bl) {
        this.txtArea.setLineWrap(bl);
    }

    public void setTextBackground(Color color) {
        this.txtArea.setBackground(color);
    }

    public void setFont(Font font) {
        if (this.txtArea != null) {
            this.txtArea.setFont(font);
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        this.txtArea.addKeyListener(keyListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.txtArea.removeKeyListener(keyListener);
    }

    public JTextArea getTextArea() {
        return this.txtArea;
    }

    public Document getDocument() {
        return this.txtArea.getDocument();
    }
}

