/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.resources.handlers;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Util;
import org.fao.geonet.api.records.attachments.AttachmentsApi;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataFileDownload;
import org.fao.geonet.domain.MetadataFileUpload;
import org.fao.geonet.repository.MetadataFileDownloadRepository;
import org.fao.geonet.repository.MetadataFileUploadRepository;
import org.fao.geonet.services.resources.handlers.IResourceDownloadHandler;
import org.fao.geonet.services.resources.handlers.ResourceHandlerException;
import org.fao.geonet.util.ThreadPool;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.NativeWebRequest;

public class DefaultResourceDownloadHandler
implements IResourceDownloadHandler {
    @Autowired
    private ThreadPool threadPool;

    @Override
    public HttpEntity<byte[]> onDownload(ServiceContext context, NativeWebRequest request, int metadataId, String fileName, Path file) throws ResourceHandlerException {
        try {
            String requesterName = this.getParam(request, "name", "");
            String requesterMail = this.getParam(request, "email", "");
            String requesterOrg = this.getParam(request, "org", "");
            String requesterComments = this.getParam(request, "comments", "");
            String downloadDate = new ISODate().toString();
            this.storeFileDownloadRequest(context, metadataId, fileName, requesterName, requesterMail, requesterOrg, requesterComments, downloadDate);
            if (Files.exists(file, new LinkOption[0]) && request.checkNotModified(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis())) {
                return null;
            }
            HttpHeaders headers = new HttpHeaders();
            headers.add((Object)"Content-Disposition", (Object)("inline; filename=\"" + fileName + "\""));
            headers.add((Object)"Cache-Control", (Object)"no-cache");
            headers.add((Object)"Content-Type", (Object)AttachmentsApi.getFileContentType(file));
            return new HttpEntity((Object)Files.readAllBytes(file), (MultiValueMap)headers);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.resources", (Object)("DefaultResourceDownloadHandler (onDownload): " + ex.getMessage()), (Throwable)ex);
            throw new ResourceHandlerException(ex);
        }
    }

    private String getParam(NativeWebRequest request, String paramName, String defaultVal) {
        String val = request.getParameter(paramName);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    @Override
    public Element onDownloadMultiple(ServiceContext context, Element params, int metadataId, List<Element> files) throws ResourceHandlerException {
        try {
            String requesterName = Util.getParam((Element)params, (String)"name", (String)"");
            String requesterMail = Util.getParam((Element)params, (String)"email", (String)"");
            String requesterOrg = Util.getParam((Element)params, (String)"org", (String)"");
            String requesterComments = Util.getParam((Element)params, (String)"comments", (String)"");
            String fileList = "";
            Iterator<Element> iterator = files.iterator();
            while (iterator.hasNext()) {
                Element o;
                Element elem = o = iterator.next();
                String fname = elem.getText();
                if (StringUtils.isEmpty((String)fileList)) {
                    fileList = fname;
                    continue;
                }
                fileList = fileList + "~" + fname;
            }
            String downloadDate = new ISODate().toString();
            Iterator<Element> iterator2 = files.iterator();
            while (iterator2.hasNext()) {
                Element o;
                Element elem = o = iterator2.next();
                String fname = elem.getText();
                this.storeFileDownloadRequest(context, metadataId, fname, requesterName, requesterMail, requesterOrg, requesterComments, downloadDate);
            }
            return null;
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.resources", (Object)("DefaultResourceDownloadHandler (onDownloadMultiple): " + ex.getMessage()), (Throwable)ex);
            throw new ResourceHandlerException(ex);
        }
    }

    private void storeFileDownloadRequest(ServiceContext context, final int metadataId, final String fname, final String requesterName, final String requesterMail, final String requesterOrg, final String requesterComments, final String downloadDate) {
        final MetadataFileUploadRepository uploadRepository = (MetadataFileUploadRepository)context.getBean(MetadataFileUploadRepository.class);
        final MetadataFileDownloadRepository repo = (MetadataFileDownloadRepository)context.getBean(MetadataFileDownloadRepository.class);
        final String userName = context.getUserSession().getUsername();
        this.threadPool.runTask(new Runnable(){

            @Override
            public void run() {
                MetadataFileUpload metadataFileUpload;
                try {
                    metadataFileUpload = uploadRepository.findByMetadataIdAndFileNameNotDeleted(metadataId, fname);
                }
                catch (EmptyResultDataAccessException ex) {
                    metadataFileUpload = null;
                }
                if (metadataFileUpload != null) {
                    MetadataFileDownload metadataFileDownload = new MetadataFileDownload();
                    metadataFileDownload.setMetadataId(metadataId);
                    metadataFileDownload.setFileName(fname);
                    metadataFileDownload.setRequesterName(requesterName);
                    metadataFileDownload.setRequesterMail(requesterMail);
                    metadataFileDownload.setRequesterOrg(requesterOrg);
                    metadataFileDownload.setRequesterComments(requesterComments);
                    metadataFileDownload.setDownloadDate(downloadDate);
                    metadataFileDownload.setUserName(userName);
                    metadataFileDownload.setFileUploadId(metadataFileUpload.getId());
                    repo.save((Object)metadataFileDownload);
                }
            }
        });
    }
}

