/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.category;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.exceptions.MissingParameterEx;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.services.category.CategoryUpdateResponse;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="admin.category.update")
@ReadWriteController
@Deprecated
public class Update {
    @RequestMapping(value={"/{portal}/{lang}/admin.category.update"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public CategoryUpdateResponse exec(@RequestParam Integer id, final @RequestParam String name) throws Exception {
        if (name == null) {
            throw new MissingParameterEx("name");
        }
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        MetadataCategoryRepository categoryRepository = (MetadataCategoryRepository)appContext.getBean(MetadataCategoryRepository.class);
        LanguageRepository langRepository = (LanguageRepository)appContext.getBean(LanguageRepository.class);
        CategoryUpdateResponse response = new CategoryUpdateResponse();
        if (id == null) {
            MetadataCategory category = new MetadataCategory();
            category.setName(name);
            List allLanguages = langRepository.findAll();
            for (Language l : allLanguages) {
                category.getLabelTranslations().put(l.getId(), name);
            }
            categoryRepository.save((Object)category);
            response.addOperation(CategoryUpdateResponse.Operation.added);
        } else {
            categoryRepository.update((Serializable)id, (Updater)new Updater<MetadataCategory>(){

                public void apply(@Nonnull MetadataCategory entity) {
                    entity.setName(name);
                }
            });
            response.addOperation(CategoryUpdateResponse.Operation.updated);
        }
        return response;
    }
}

