/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.tools.i18n;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.IsoLanguageRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.OperationRepository;
import org.fao.geonet.repository.SchematronRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.StatusValueRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/{portal}/api/tools/i18n", "/{portal}/api/0.1/tools/i18n"})
@Api(value="tools", tags={"tools"})
@Controller(value="translation")
public class TranslationApi
implements ApplicationContextAware {
    private static final List<String> TRANSLATION_TABLES = Arrays.asList("StatusValue", "MetadataCategory", "Group", "Operation", "Source", "Schematron", "IsoLanguage");
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    StatusValueRepository statusValueRepository;
    @Autowired
    MetadataCategoryRepository categoryRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    OperationRepository operationRepository;
    @Autowired
    SourceRepository sourceRepository;
    @Autowired
    SchematronRepository schematronRepository;
    @Autowired
    IsoLanguageRepository isoLanguageRepository;
    private ApplicationContext context;

    public synchronized void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @ApiOperation(value="List translations for database description table", nickname="getTranslations")
    @RequestMapping(value={"/db"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> getTranslations(@RequestParam(required=false) List<String> type, ServletRequest request) throws Exception {
        LinkedHashMap<String, String> response = new LinkedHashMap<String, String>();
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        this.validateParameters(type);
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        String language = LanguageUtils.locale2gnCode(locale.getISO3Language());
        if (type == null || type.contains("StatusValue")) {
            List valueList = this.statusValueRepository.findAll();
            for (StatusValue entity : valueList) {
                response.put("status-" + entity.getId() + "", this.getLabelOrKey((Localized)entity, language, entity.getId() + ""));
            }
        }
        if (type == null || type.contains("MetadataCategory")) {
            List metadataCategoryList = this.categoryRepository.findAll();
            for (StatusValue entity : metadataCategoryList) {
                response.put("cat-" + entity.getName() + "", this.getLabelOrKey((Localized)entity, language, entity.getName()));
            }
        }
        if (type == null || type.contains("Group")) {
            List groupList = this.groupRepository.findAll();
            for (StatusValue entity : groupList) {
                response.put("group-" + entity.getId() + "", this.getLabelOrKey((Localized)entity, language, entity.getName()));
            }
        }
        if (type == null || type.contains("Operation")) {
            List operationList = this.operationRepository.findAll();
            for (StatusValue entity : operationList) {
                response.put("op-" + entity.getId() + "", this.getLabelOrKey((Localized)entity, language, entity.getId() + ""));
                response.put("op-" + entity.getName() + "", this.getLabelOrKey((Localized)entity, language, entity.getName()));
            }
        }
        if (type == null || type.contains("Source")) {
            List sourceList = this.sourceRepository.findAll();
            for (StatusValue entity : sourceList) {
                response.put("source-" + entity.getUuid() + "", this.getLabelOrKey((Localized)entity, language, entity.getUuid()));
            }
        }
        if (type == null || type.contains("Schematron")) {
            List schematronList = this.schematronRepository.findAll();
            for (StatusValue entity : schematronList) {
                response.put("sch-" + entity.getRuleName() + "", this.getLabelOrKey((Localized)entity, language, entity.getRuleName()));
            }
        }
        if (type == null || type.contains("IsoLanguage")) {
            List isoLanguageList = this.isoLanguageRepository.findAll();
            for (StatusValue entity : isoLanguageList) {
                response.put("lang-" + entity.getCode() + "", this.getLabelOrKey((Localized)entity, language, entity.getCode()));
            }
        }
        return response;
    }

    private String getLabelOrKey(Localized entity, String language, String defaultValue) {
        String value = entity.getLabel(language);
        return value != null ? value : defaultValue;
    }

    private void validateParameters(List<String> type) {
        if (type != null) {
            if (type.size() == 0) {
                throw new IllegalArgumentException(String.format("Empty type is not allowed. Remove the parameter or choose one or more types in %s", TRANSLATION_TABLES));
            }
            for (String value : type) {
                if (TRANSLATION_TABLES.contains(value)) continue;
                throw new IllegalArgumentException(String.format("Type '%s' is not allowed. Choose one or more types in %s", value, TRANSLATION_TABLES));
            }
        }
    }
}

