/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.site;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.fao.geonet.api.site.model.ListLogFilesResponse;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.util.FileUtil;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/site/logging", "/{portal}/api/0.1/site/logging"})
@Api(value="site", tags={"site"}, description="Catalog operations")
@Controller(value="logging")
@PreAuthorize(value="hasRole('Administrator')")
public class LoggingApi {
    private final String regexp = "log4j(-(.*?))?\\.xml";
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    private static final String fileAppenderName = "fileAppender";
    private static final int maxLines = 20000;
    private FileAppender fileAppender = null;

    @ApiOperation(value="Get log files", notes="", nickname="getLogFiles")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<ListLogFilesResponse.LogFileResponse> getLogFiles(HttpServletRequest request) throws Exception {
        ArrayList<ListLogFilesResponse.LogFileResponse> logFileList = new ArrayList<ListLogFilesResponse.LogFileResponse>();
        String classesFolder = this.dataDirectory.getWebappDir() + "/WEB-INF/classes";
        File folder = new File(classesFolder);
        if (folder != null && folder.isDirectory()) {
            Pattern pattern = Pattern.compile("log4j(-(.*?))?\\.xml", 2);
            for (File file : folder.listFiles()) {
                String fileName = file.getName();
                Matcher matcher = pattern.matcher(fileName);
                if (!matcher.matches()) continue;
                String key = matcher.group(2);
                if (StringUtils.isEmpty((Object)key)) {
                    key = "prod";
                }
                logFileList.add(new ListLogFilesResponse.LogFileResponse(key.toUpperCase(), fileName));
            }
        }
        return logFileList;
    }

    @ApiOperation(value="Get last activity", notes="", nickname="getLastActivity")
    @RequestMapping(value={"/activity"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getLastActivity(@ApiParam(value="Number of lines to return", required=false) @RequestParam(value="lines", required=false, defaultValue="2000") int lines) {
        String lastActivity = null;
        if (!this.isAppenderLogFileLoaded()) {
            throw new RuntimeException("No log file found. Check logger configuration.");
        }
        lastActivity = FileUtil.readLastLines((File)new File(this.fileAppender.getFile()), (int)Math.min(lines, 20000));
        return lastActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Get last activity in a ZIP", notes="", nickname="getLastActivityInAZip")
    @RequestMapping(value={"/activity/zip"}, method={RequestMethod.GET}, produces={"application/zip"})
    @ResponseBody
    public void getLastActivityInAZip(HttpServletResponse response) throws IOException {
        ZipOutputStream zos;
        block6: {
            block5: {
                if (!this.isAppenderLogFileLoaded()) break block5;
                File file = new File(this.fileAppender.getFile());
                String fname = String.valueOf(Calendar.getInstance().getTimeInMillis());
                response.setContentType("application/zip");
                String headerKey = "Content-Disposition";
                String headerValue = String.format("attachment; filename=\"catalog-log-%s-%s.zip\"", fname, new SimpleDateFormat("ddMMyyyyHHmmss").format(new Date()));
                response.setHeader(headerKey, headerValue);
                int read = 0;
                byte[] bytes = new byte[1024];
                zos = null;
                FileInputStream in = null;
                try {
                    zos = new ZipOutputStream((OutputStream)response.getOutputStream());
                    ZipEntry ze = new ZipEntry(file.getName());
                    zos.putNextEntry(ze);
                    in = new FileInputStream(file);
                    while ((read = ((InputStream)in).read(bytes)) != -1) {
                        zos.write(bytes, 0, read);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    if (zos != null) {
                        zos.flush();
                    }
                    IOUtils.closeQuietly((OutputStream)zos);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                if (zos != null) {
                    zos.flush();
                }
                break block6;
            }
            throw new RuntimeException("No log file found for download. Check logger configuration.");
        }
        IOUtils.closeQuietly((OutputStream)zos);
    }

    private boolean isAppenderLogFileLoaded() {
        if (this.fileAppender == null || this.fileAppender.getFile() == null) {
            this.fileAppender = (FileAppender)Logger.getLogger((String)"geonetwork").getAppender(fileAppenderName);
            if (this.fileAppender == null) {
                this.fileAppender = (FileAppender)Logger.getLogger((String)"jeeves").getAppender(fileAppenderName);
            }
            if (this.fileAppender == null) {
                Log.error((String)"geonetwork", (Object)"Error when getting appender named 'fileAppender'. Check your log configuration file. No appender found.");
                return false;
            }
            String logFileName = this.fileAppender.getFile();
            if (logFileName == null) {
                Log.error((String)"geonetwork", (Object)"Error when getting logger file for the appender named 'fileAppender'. Check your log configuration file. A FileAppender is required to return last activity to the user interface.Appender file not found.");
                return false;
            }
        }
        return true;
    }
}

