/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.regions;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Collections;
import org.fao.geonet.api.records.extent.MapRenderer;
import org.fao.geonet.api.regions.metadata.MetadataRegionSearchRequest;
import org.fao.geonet.kernel.region.Region;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class MetadataRegion
extends Region {
    private Geometry geometry;

    public MetadataRegion(MetadataRegionSearchRequest.Id mdId, String id, Geometry geometry) {
        super("metadata" + mdId.getIdentifiedId() + ":" + id, Collections.emptyMap(), "metadata", Collections.emptyMap(), true, new ReferencedEnvelope(geometry.getEnvelopeInternal(), WGS84));
        this.geometry = geometry;
    }

    public Geometry getGeometry(CoordinateReferenceSystem projection) throws Exception {
        boolean differentCrsCode;
        CoordinateReferenceSystem coordinateReferenceSystem = this.getBBox().getCoordinateReferenceSystem();
        Integer sourceCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)coordinateReferenceSystem, (boolean)false);
        Integer desiredCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)projection, (boolean)false);
        boolean bl = differentCrsCode = sourceCode == null || desiredCode == null || desiredCode.intValue() != sourceCode.intValue();
        if (differentCrsCode && !CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem, (Object)projection)) {
            this.geometry = MapRenderer.computeGeomInDomainOfValidity(this.geometry, projection);
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)projection, (boolean)true);
            return JTS.transform((Geometry)this.geometry, (MathTransform)transform);
        }
        return this.geometry;
    }
}

