/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.backup;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.io.FileFilter;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.backup.ArchiveAllMetadataJob;
import org.fao.geonet.utils.Log;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records/backups", "/{portal}/api/0.1/records/backups"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller
public class BackupArchiveApi {
    @Autowired
    ArchiveAllMetadataJob archiveAllMetadataJob;

    @ApiOperation(value="Download MEF backup archive", notes="The backup contains all metadata not harvested including templates.", nickname="downloadBackup")
    @PreAuthorize(value="hasRole('Administrator')")
    @RequestMapping(value={"/latest"}, method={RequestMethod.GET}, produces={"application/zip"})
    @ApiResponses(value={@ApiResponse(code=404, message="Resource not found.")})
    @ResponseBody
    public ResponseEntity<FileSystemResource> exec(HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)appContext.getBean(GeonetworkDataDirectory.class);
        ServiceManager serviceManager = (ServiceManager)appContext.getBean(ServiceManager.class);
        Log.info((String)"geonetwork.backup", (Object)("User " + context.getUserSession().getUsername() + " from IP: " + context.getIpAddress() + " has started to download backup archive"));
        File backupDir = dataDirectory.getBackupDir().resolve("backup_archive").toFile();
        if (!backupDir.exists()) {
            throw new ResourceNotFoundException("Backup archive folder does not exist");
        }
        File[] files = backupDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new ResourceNotFoundException("Backup archive file does not yet exist");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add((Object)"content-disposition", (Object)("attachment; filename=" + files[0].getName()));
        ResponseEntity response = new ResponseEntity((Object)new FileSystemResource(files[0]), (MultiValueMap)headers, HttpStatus.OK);
        return response;
    }

    @ApiOperation(value="Trigger MEF backup archive", notes="The backup contains all metadata not harvested including templates.", nickname="triggerBackup")
    @RequestMapping(method={RequestMethod.PUT}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Administrator')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Return succeed message.")})
    @ResponseBody
    public String trigger(HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        Trigger trigger = TriggerBuilder.newTrigger().forJob("archiveAllMetadata", "gnBackgroundTasks").startNow().build();
        ((Scheduler)context.getBean("gnBackgroundJobScheduler", Scheduler.class)).scheduleJob(trigger);
        return "{\"success\":true}";
    }
}

