/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.groups;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.attachments.AttachmentsApi;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Group_;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.OperationAllowedId_;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroupId_;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.GroupSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/groups", "/{portal}/api/0.1/groups"})
@Api(value="groups", tags={"groups"}, description="Groups operations")
@Controller(value="groups")
public class GroupsApi {
    private static final String API_GET_LOGO_NOTE = "If last-modified header is present it is used to check if the logo has been modified since the header date. If it hasn't been modified returns an empty 304 Not Modified response. If modified returns the image. If the group has no logo then returns a transparent 1x1 px PNG image.";
    public static final String LOGGER = "geonetwork.api.groups";
    private static final int SIX_HOURS = 21600;
    private static final String TRANSPARENT_1_X_1_PNG_BASE64 = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mP8/5+hHgAHggJ/PchI7wAAAABJRU5ErkJggg==";
    private static final byte[] TRANSPARENT_1_X_1_PNG = Base64.decodeBase64((String)"iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mP8/5+hHgAHggJ/PchI7wAAAABJRU5ErkJggg==");
    public static final String API_PARAM_GROUP_DETAILS = "Group details";
    public static final String API_PARAM_GROUP_IDENTIFIER = "Group identifier";
    public static final String MSG_GROUP_WITH_IDENTIFIER_NOT_FOUND = "Group with identifier '%d' not found";
    @Autowired
    @Qualifier(value="apiMessages")
    private ResourceBundleMessageSource messages;
    @Autowired
    private LanguageUtils languageUtils;
    @Autowired
    private LanguageRepository langRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private OperationAllowedRepository operationAllowedRepo;
    @Autowired
    private UserGroupRepository userGroupRepository;
    @Autowired
    private DataManager dm;

    @ApiOperation(value="Get the group logo image.", nickname="get", notes="If last-modified header is present it is used to check if the logo has been modified since the header date. If it hasn't been modified returns an empty 304 Not Modified response. If modified returns the image. If the group has no logo then returns a transparent 1x1 px PNG image.")
    @RequestMapping(value={"/{groupId}/logo"}, method={RequestMethod.GET})
    public void getGroupLogo(@ApiParam(value="Group identifier", required=true) @PathVariable(value="groupId") Integer groupId, @ApiIgnore WebRequest webRequest, HttpServletRequest request, HttpServletResponse response) throws ResourceNotFoundException {
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ConfigurableApplicationContext context = ApplicationContextHolder.get();
        ServiceContext serviceContext = ApiUtils.createServiceContext(request, locale.getISO3Country());
        if (context == null) {
            throw new RuntimeException("ServiceContext not available");
        }
        Group group = (Group)this.groupRepository.findOne((Serializable)groupId);
        if (group == null) {
            throw new ResourceNotFoundException(this.messages.getMessage("api.groups.group_not_found", new Object[]{groupId}, locale));
        }
        try {
            FileTime lastModifiedTime;
            Resources resources = (Resources)context.getBean(Resources.class);
            String logoUUID = group.getLogo();
            if (StringUtils.isNotBlank((String)logoUUID) && !logoUUID.startsWith("http://") && !logoUUID.startsWith("https//")) {
                try (Resources.ResourceHolder image = GroupsApi.getImage(resources, serviceContext, group);){
                    if (image != null) {
                        FileTime lastModifiedTime2 = image.getLastModifiedTime();
                        response.setDateHeader("Expires", System.currentTimeMillis() + 21600000L);
                        if (webRequest.checkNotModified(lastModifiedTime2.toMillis())) {
                            return;
                        }
                        response.setContentType(AttachmentsApi.getFileContentType(image.getPath()));
                        response.setContentLength((int)Files.size(image.getPath()));
                        response.addHeader("Cache-Control", "max-age=21600, public");
                        FileUtils.copyFile((File)image.getPath().toFile(), (OutputStream)response.getOutputStream());
                        return;
                    }
                }
            }
            if (webRequest.checkNotModified((lastModifiedTime = FileTime.fromMillis(0L)).toMillis())) {
                return;
            }
            response.setContentType("image/png");
            response.setContentLength(TRANSPARENT_1_X_1_PNG.length);
            response.addHeader("Cache-Control", "max-age=21600, public");
            response.getOutputStream().write(TRANSPARENT_1_X_1_PNG);
        }
        catch (IOException e) {
            Log.error((String)LOGGER, (Object)String.format("There was an error accessing the logo of the group with id '%d'", groupId));
            throw new RuntimeException(e);
        }
    }

    private static Resources.ResourceHolder getImage(Resources resources, ServiceContext serviceContext, Group group) throws IOException {
        Path logosDir = resources.locateLogosDir(serviceContext);
        Path harvesterLogosDir = resources.locateHarvesterLogosDir(serviceContext);
        String logoUUID = group.getLogo();
        Resources.ResourceHolder image = null;
        if (StringUtils.isNotBlank((String)logoUUID) && !logoUUID.startsWith("http://") && !logoUUID.startsWith("https//") && (image = resources.getImage(serviceContext, logoUUID, logosDir)) == null) {
            image = resources.getImage(serviceContext, logoUUID, harvesterLogosDir);
        }
        return image;
    }

    @ApiOperation(value="Get groups", notes="The catalog contains one or more groups. By default, there is 3 reserved groups (Internet, Intranet, Guest) and a sample group.<br/>This service returns all catalog groups when not authenticated or when current is user is an administrator. The list can contains or not reserved groups depending on the parameters.<br/>When authenticated, return user groups optionally filtered on a specific user profile.", nickname="getGroups")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<Group> getGroups(@ApiParam(value="Including Internet, Intranet, Guest groups or not") @RequestParam(required=false, defaultValue="false") boolean withReservedGroup, @ApiParam(value="For a specific profile") @RequestParam(required=false) String profile, @ApiIgnore HttpSession httpSession) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        if (!session.isAuthenticated() || profile == null) {
            return this.getGroups(session, null, withReservedGroup, !withReservedGroup);
        }
        return this.getGroups(session, Profile.findProfileIgnoreCase((String)profile), false, false);
    }

    @ApiOperation(value="Add a group", notes="Return the identifier of the group created.", authorizations={@Authorization(value="basicAuth")}, nickname="addGroup")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ApiResponses(value={@ApiResponse(code=201, message="Group created."), @ApiResponse(code=400, message="Group with that id or name already exist."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public ResponseEntity<Integer> addGroup(@ApiParam(value="Group details") @RequestBody Group group) throws Exception {
        Group existingId = (Group)this.groupRepository.findOne((Serializable)Integer.valueOf(group.getId()));
        if (existingId != null) {
            throw new IllegalArgumentException(String.format("A group with id '%d' already exist.", group.getId()));
        }
        Group existingName = this.groupRepository.findByName(group.getName());
        if (existingName != null) {
            throw new IllegalArgumentException(String.format("A group with name '%s' already exist.", group.getName()));
        }
        List allLanguages = this.langRepository.findAll();
        Map labelTranslations = group.getLabelTranslations();
        for (Language l : allLanguages) {
            String label = (String)labelTranslations.get(l.getId());
            group.getLabelTranslations().put(l.getId(), label == null ? group.getName() : label);
        }
        try {
            group = (Group)this.groupRepository.saveAndFlush((Object)group);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.api", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
            throw new RuntimeException(ex.getMessage());
        }
        return new ResponseEntity((Object)group.getId(), HttpStatus.CREATED);
    }

    @ApiOperation(value="Get group", notes="Return the requested group details.", nickname="getGroup")
    @RequestMapping(value={"/{groupIdentifier}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=404, message="Resource not found.")})
    @ResponseBody
    public Group getGroup(@ApiParam(value="Group identifier") @PathVariable Integer groupIdentifier) throws Exception {
        Group group = (Group)this.groupRepository.findOne((Serializable)groupIdentifier);
        if (group == null) {
            throw new ResourceNotFoundException(String.format(MSG_GROUP_WITH_IDENTIFIER_NOT_FOUND, groupIdentifier));
        }
        return group;
    }

    @ApiOperation(value="Get group users", notes="", authorizations={@Authorization(value="basicAuth")}, nickname="getGroupUsers")
    @RequestMapping(value={"/{groupIdentifier}/users"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ApiResponses(value={@ApiResponse(code=200, message="List of users in that group."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public List<User> getGroupUsers(@ApiParam(value="Group identifier") @PathVariable Integer groupIdentifier) throws Exception {
        Group group = (Group)this.groupRepository.findOne((Serializable)groupIdentifier);
        if (group == null) {
            throw new ResourceNotFoundException(String.format(MSG_GROUP_WITH_IDENTIFIER_NOT_FOUND, groupIdentifier));
        }
        return this.userRepository.findAllUsersInUserGroups(UserGroupSpecs.hasGroupId((Integer)groupIdentifier));
    }

    @ApiOperation(value="Update a group", notes="", authorizations={@Authorization(value="basicAuth")}, nickname="updateGroup")
    @RequestMapping(value={"/{groupIdentifier}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ApiResponses(value={@ApiResponse(code=204, message="Group updated."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public void updateGroup(@ApiParam(value="Group identifier") @PathVariable Integer groupIdentifier, @ApiParam(value="Group details") @RequestBody Group group) throws Exception {
        Group existing = (Group)this.groupRepository.findOne((Serializable)groupIdentifier);
        if (existing == null) {
            throw new ResourceNotFoundException(String.format(MSG_GROUP_WITH_IDENTIFIER_NOT_FOUND, groupIdentifier));
        }
        try {
            this.groupRepository.saveAndFlush((Object)group);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.api", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
            throw new RuntimeException(ex.getMessage());
        }
    }

    @ApiOperation(value="Remove a group", notes="Remove a group by first removing sharing settings, link to users and finally reindex all affected records.", authorizations={@Authorization(value="basicAuth")}, nickname="deleteGroup")
    @RequestMapping(value={"/{groupIdentifier}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="hasRole('Administrator')")
    @ApiResponses(value={@ApiResponse(code=204, message="Group removed."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public void deleteGroup(@ApiParam(value="Group identifier.") @PathVariable Integer groupIdentifier, @ApiParam(value="Force removal even if records are assigned to that group.") @RequestParam(defaultValue="false") boolean force, @ApiIgnore ServletRequest request) throws Exception {
        Group group = (Group)this.groupRepository.findOne((Serializable)groupIdentifier);
        if (group != null) {
            List reindex = this.operationAllowedRepo.findAllIds(OperationAllowedSpecs.hasGroupId((int)groupIdentifier), OperationAllowedId_.metadataId);
            if (reindex.size() > 0 && force) {
                this.operationAllowedRepo.deleteAllByGroupId(groupIdentifier.intValue());
                this.dm.indexMetadata(Lists.transform((List)reindex, (Function)Functions.toStringFunction()));
            } else if (reindex.size() > 0 && !force) {
                throw new NotAllowedException(String.format("Group %s has privileges associated with %d record(s). Add 'force' parameter to remove it or remove privileges associated with that group first.", group.getName(), reindex.size()));
            }
            List users = this.userGroupRepository.findUserIds((Specification)Specifications.where((Specification)UserGroupSpecs.hasGroupId((Integer)group.getId())));
            if (users.size() > 0 && force) {
                this.userGroupRepository.deleteAllByIdAttribute(UserGroupId_.groupId, Arrays.asList(groupIdentifier));
            } else if (users.size() > 0 && !force) {
                throw new NotAllowedException(String.format("Group %s is associated with %d user(s). Add 'force' parameter to remove it or remove users associated with that group first.", group.getName(), users.size()));
            }
        } else {
            throw new ResourceNotFoundException(String.format(MSG_GROUP_WITH_IDENTIFIER_NOT_FOUND, groupIdentifier));
        }
        this.groupRepository.delete((Serializable)groupIdentifier);
    }

    private List<Group> getGroups(UserSession session, Profile profile, boolean includingSystemGroups, boolean all) throws SQLException {
        Sort sort = SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{Group_.id});
        if (all || !session.isAuthenticated() || Profile.Administrator == session.getProfile()) {
            if (includingSystemGroups) {
                return this.groupRepository.findAll(null, sort);
            }
            return this.groupRepository.findAll((Specification)Specifications.not((Specification)GroupSpecs.isReserved()), sort);
        }
        Specifications spec = Specifications.where((Specification)UserGroupSpecs.hasUserId((int)session.getUserIdAsInt()));
        if (profile != null) {
            spec = spec.and(UserGroupSpecs.hasProfile((Profile)profile));
        }
        HashSet<Integer> ids = new HashSet<Integer>(this.userGroupRepository.findGroupIds((Specification)spec));
        if (includingSystemGroups) {
            for (ReservedGroup reservedGroup : ReservedGroup.values()) {
                ids.add(reservedGroup.getId());
            }
        }
        List groups = this.groupRepository.findAll(null, sort);
        groups.removeIf(g -> !ids.contains(g.getId()));
        return groups;
    }
}

