/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.vectorbin;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jtsexample.geom.ExtendedCoordinate;
import com.vividsolutions.jtsexample.geom.ExtendedCoordinateSequence;
import it.geosolutions.jaiext.vectorbin.LiteShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterFactory;
import javax.media.jai.SourcelessOpImage;

public class VectorBinarizeOpImage
extends SourcelessOpImage {
    private final PreparedGeometry geom;
    private final Shape shape;
    private Raster solidTile;
    private Raster blankTile;
    public static final boolean DEFAULT_ANTIALIASING = false;
    private boolean antiAliasing = false;
    private GeometryFactory gf = new GeometryFactory();

    public VectorBinarizeOpImage(SampleModel sm, Map configuration, int minX, int minY, int width, int height, PreparedGeometry geom, boolean antiAliasing) {
        super(VectorBinarizeOpImage.buildLayout(minX, minY, width, height, sm), configuration, sm, minX, minY, width, height);
        this.geom = geom;
        this.shape = new LiteShape(geom.getGeometry());
        this.antiAliasing = antiAliasing;
    }

    static ImageLayout buildLayout(int minX, int minY, int width, int height, SampleModel sm) {
        ImageLayout il = new ImageLayout();
        il.setMinX(minX);
        il.setMinY(minY);
        il.setWidth(width);
        il.setHeight(height);
        il.setTileWidth(sm.getWidth());
        il.setTileHeight(sm.getHeight());
        il.setSampleModel(sm);
        if (!il.isValid(16)) {
            il.setTileGridXOffset(il.getMinX(null));
        }
        if (!il.isValid(32)) {
            il.setTileGridYOffset(il.getMinY(null));
        }
        return il;
    }

    public Raster computeTile(int tileX, int tileY) {
        int x = this.tileXToX(tileX);
        int y = this.tileYToY(tileY);
        Raster tile = this.getTileRaster(x, y);
        Raster result = tile.createChild(0, 0, this.tileWidth, this.tileHeight, x, y, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Raster getTileRaster(int minX, int minY) {
        Polygon testRect = this.getTestRect(minX, minY);
        try {
            PreparedGeometry preparedGeometry = this.geom;
            synchronized (preparedGeometry) {
                if (this.geom.contains((Geometry)testRect)) {
                    return this.getSolidTile();
                }
                if (this.geom.disjoint((Geometry)testRect)) {
                    return this.getBlankTile();
                }
            }
        }
        catch (TopologyException topologyException) {
            // empty catch block
        }
        return this.drawGeometry(minX, minY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Raster drawGeometry(int minX, int minY) {
        int offset = this.antiAliasing ? 2 : 0;
        SampleModel tileSampleModel = this.sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)tileSampleModel, (Point)new Point(0, 0));
        BufferedImage bi = new BufferedImage(this.colorModel, raster, false, null);
        Graphics2D graphics = null;
        try {
            graphics = bi.createGraphics();
            graphics.setClip(-offset, -offset, this.tileWidth + offset * 2, this.tileHeight + offset * 2);
            graphics.translate(-minX, -minY);
            if (this.antiAliasing) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            graphics.setColor(Color.WHITE);
            graphics.fill(this.shape);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return raster;
    }

    private Raster getSolidTile() {
        if (this.solidTile == null) {
            this.solidTile = this.constantTile(1);
        }
        return this.solidTile;
    }

    private Raster getBlankTile() {
        if (this.blankTile == null) {
            this.blankTile = this.constantTile(0);
        }
        return this.blankTile;
    }

    private Raster constantTile(int value) {
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)this.sampleModel, (Point)new Point(0, 0));
        int dataType = this.sampleModel.getTransferType();
        int numBands = this.sampleModel.getNumBands();
        if (dataType != 0) {
            throw new IllegalArgumentException("The code works only if the sample model data type is BYTE");
        }
        if (numBands != 1) {
            throw new IllegalArgumentException("The code works only for single band rasters!");
        }
        int w = this.sampleModel.getWidth();
        int h = this.sampleModel.getHeight();
        int[] data = new int[w * h];
        Arrays.fill(data, value);
        raster.setSamples(0, 0, w, h, 0, data);
        return raster;
    }

    private Polygon getTestRect(int x, int y) {
        ExtendedCoordinate[] copyCoords = new ExtendedCoordinate[5];
        for (int i = 0; i < 5; ++i) {
            int xx = x;
            int yy = y;
            if (i == 1 || i == 2) {
                yy = y + this.tileHeight;
            }
            if (i == 2 || i == 3) {
                xx = x + this.tileWidth;
            }
            copyCoords[i] = new ExtendedCoordinate((double)xx, (double)yy, 0.0, 0.0);
        }
        ExtendedCoordinateSequence seq = new ExtendedCoordinateSequence(copyCoords);
        return this.gf.createPolygon(this.gf.createLinearRing((CoordinateSequence)seq), null);
    }
}

