/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgWcToWcCopy;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnScheduleForAddition;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgReposToWcCopy
extends SvnNgOperationRunner<Void, SvnCopy> {
    @Override
    public boolean isApplicable(SvnCopy operation, SvnWcGeneration wcGeneration) throws SVNException {
        return this.areAllSourcesRemote(operation) && operation.getFirstTarget().isLocal();
    }

    private boolean areAllSourcesRemote(SvnCopy operation) {
        for (SvnCopySource source : operation.getSources()) {
            if (!source.getSource().isFile()) continue;
            if (operation.isMove()) {
                return false;
            }
            if (!this.isLocalRevision(source.getRevision()) || !this.isLocalRevision(source.getSource().getResolvedPegRevision())) continue;
            return false;
        }
        return true;
    }

    private boolean isLocalRevision(SVNRevision revision) {
        return revision == SVNRevision.WORKING || revision == SVNRevision.UNDEFINED;
    }

    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        SVNErrorMessage err;
        if (((SvnCopy)this.getOperation()).isMove()) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Moves between the working copy and the repository are not supported");
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        Collection<SvnCopySource> sources = this.expandCopySources(((SvnCopy)this.getOperation()).getSources());
        ArrayList<SvnCopyPair> copyPairs = new ArrayList<SvnCopyPair>();
        boolean srcsAreUrls = sources.iterator().next().getSource().isURL();
        if (sources.size() > 1) {
            for (SvnCopySource copySource : sources) {
                String baseName;
                SvnCopyPair copyPair = new SvnCopyPair();
                if (copySource.getSource().isFile()) {
                    copyPair.sourceFile = copySource.getSource().getFile();
                    baseName = copyPair.sourceFile.getName();
                    if (srcsAreUrls) {
                        err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot mix repository and working copy sources");
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    if (copySource.getSource().getResolvedPegRevision() == SVNRevision.WORKING) {
                        Structure<SvnRepositoryAccess.RevisionsPair> pair = this.getRepositoryAccess().getRevisionNumber(null, copySource.getSource(), copySource.getSource().getResolvedPegRevision(), null);
                        copyPair.sourcePegRevision = SVNRevision.create(pair.lng(SvnRepositoryAccess.RevisionsPair.revNumber));
                        pair.release();
                    } else {
                        copyPair.sourcePegRevision = copySource.getSource().getResolvedPegRevision();
                    }
                    copyPair.sourceRevision = copySource.getRevision();
                } else {
                    copyPair.source = copySource.getSource().getURL();
                    baseName = SVNPathUtil.tail(copyPair.source.getPath());
                    copyPair.sourcePegRevision = copySource.getSource().getResolvedPegRevision();
                    copyPair.sourceRevision = copySource.getRevision();
                }
                copyPair.dst = new File(this.getFirstTarget(), baseName);
                copyPairs.add(copyPair);
            }
        } else if (sources.size() == 1) {
            String baseName;
            SvnCopyPair copyPair = new SvnCopyPair();
            SvnCopySource source = sources.iterator().next();
            if (source.getSource().isFile()) {
                copyPair.sourceFile = source.getSource().getFile();
                baseName = copyPair.sourceFile.getName();
            } else {
                copyPair.source = source.getSource().getURL();
                baseName = SVNPathUtil.tail(copyPair.source.getPath());
            }
            if (source.getSource().getResolvedPegRevision() == SVNRevision.WORKING) {
                Structure<SvnRepositoryAccess.RevisionsPair> pair = this.getRepositoryAccess().getRevisionNumber(null, source.getSource(), source.getSource().getResolvedPegRevision(), null);
                copyPair.sourcePegRevision = SVNRevision.create(pair.lng(SvnRepositoryAccess.RevisionsPair.revNumber));
                pair.release();
            } else {
                copyPair.sourcePegRevision = source.getSource().getResolvedPegRevision();
            }
            copyPair.sourceRevision = source.getRevision();
            copyPair.dst = this.getFirstTarget();
            if (!((SvnCopy)this.getOperation()).isFailWhenDstExists() && SVNFileType.getType(copyPair.dst) != SVNFileType.NONE) {
                copyPair.dst = new File(copyPair.dst, baseName);
            }
            copyPairs.add(copyPair);
        }
        if (!srcsAreUrls) {
            for (SvnCopyPair pair : copyPairs) {
                Structure<StructureFields.NodeOriginInfo> no;
                File src = pair.sourceFile;
                File dst = pair.dst;
                if (SVNWCUtils.isChild(src, dst)) {
                    err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy path ''{0}'' into its own child ''{1}''", src, dst);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if ((no = this.getWcContext().getNodeOrigin(src, true, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl, StructureFields.NodeOriginInfo.revision)).get(StructureFields.NodeOriginInfo.reposRelpath) != null) {
                    pair.source = ((SVNURL)no.get(StructureFields.NodeOriginInfo.reposRootUrl)).appendPath(SVNFileUtil.getFilePath((File)no.get(StructureFields.NodeOriginInfo.reposRelpath)), false);
                } else {
                    SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' does not have an URL associated with it", (Object)src);
                    SVNErrorManager.error(err3, SVNLogType.WC);
                }
                if (pair.sourcePegRevision == SVNRevision.BASE) {
                    pair.sourcePegRevision = SVNRevision.create(no.lng(StructureFields.NodeOriginInfo.revision));
                }
                if (pair.sourceRevision != SVNRevision.BASE) continue;
                pair.sourceRevision = SVNRevision.create(no.lng(StructureFields.NodeOriginInfo.revision));
            }
        }
        return this.copy(copyPairs, ((SvnCopy)this.getOperation()).isMakeParents(), ((SvnCopy)this.getOperation()).isIgnoreExternals());
    }

    protected Collection<SvnCopySource> expandCopySources(Collection<SvnCopySource> sources) throws SVNException {
        ArrayList<SvnCopySource> expanded = new ArrayList<SvnCopySource>(sources.size());
        for (SvnCopySource source : sources) {
            if (source.isCopyContents() && source.getSource().isURL()) {
                SVNRevision startRevision;
                SVNRevision pegRevision = source.getSource().getResolvedPegRevision();
                if (!pegRevision.isValid()) {
                    pegRevision = SVNRevision.HEAD;
                }
                if (!(startRevision = source.getRevision()).isValid()) {
                    startRevision = pegRevision;
                }
                SVNRepository svnRepository = this.getRepositoryAccess().createRepository(source.getSource().getURL(), null, true);
                Structure<SvnRepositoryAccess.LocationsInfo> locations = this.getRepositoryAccess().getLocations(svnRepository, source.getSource(), pegRevision, startRevision, SVNRevision.UNDEFINED);
                long revision = locations.lng(SvnRepositoryAccess.LocationsInfo.startRevision);
                ArrayList entries = new ArrayList();
                svnRepository.getDir("", revision, null, 0, entries);
                for (SVNDirEntry entry : entries) {
                    expanded.add(SvnCopySource.create(SvnTarget.fromURL(entry.getURL()), source.getRevision()));
                }
                continue;
            }
            expanded.add(source);
        }
        return expanded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void copy(Collection<SvnCopyPair> copyPairs, boolean makeParents, boolean ignoreExternals) throws SVNException {
        for (SvnCopyPair pair : copyPairs) {
            Structure<SvnRepositoryAccess.LocationsInfo> locations = this.getRepositoryAccess().getLocations(null, pair.sourceFile != null ? SvnTarget.fromFile(pair.sourceFile) : SvnTarget.fromURL(pair.source), pair.sourcePegRevision, pair.sourceRevision, SVNRevision.UNDEFINED);
            pair.sourceOriginal = pair.source;
            pair.source = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.startUrl);
            locations.release();
        }
        SVNURL topSrcUrl = this.getCommonCopyAncestor(copyPairs);
        File topDst = this.getCommonCopyDst(copyPairs);
        if (copyPairs.size() == 1) {
            topSrcUrl = topSrcUrl.removePathTail();
            topDst = SVNFileUtil.getParentFile(topDst);
        }
        SVNRepository repository = this.getRepositoryAccess().createRepository(topSrcUrl, null);
        Structure<SvnRepositoryAccess.RevisionsPair> revisionPair = null;
        for (SvnCopyPair pair : copyPairs) {
            revisionPair = this.getRepositoryAccess().getRevisionNumber(repository, SvnTarget.fromURL(pair.source), pair.sourceRevision, revisionPair);
            pair.revNum = revisionPair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        }
        for (SvnCopyPair pair : copyPairs) {
            String relativePath = SVNURLUtil.getRelativeURL(topSrcUrl, pair.source, false);
            SVNNodeKind sourceKind = repository.checkPath(relativePath = SVNEncodingUtil.uriDecode(relativePath), pair.revNum);
            if (sourceKind == SVNNodeKind.NONE) {
                SVNErrorMessage err;
                if (pair.revNum >= 0L) {
                    err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' not found in revision ''{1}''", pair.source, pair.revNum);
                    SVNErrorManager.error(err, SVNLogType.WC);
                } else {
                    err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' not found in HEAD revision", (Object)pair.source);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            pair.srcKind = sourceKind;
            SVNFileType dstType = SVNFileType.getType(pair.dst);
            if (dstType != SVNFileType.NONE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", (Object)pair.dst);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            File dstParent = SVNFileUtil.getParentFile(pair.dst);
            dstType = SVNFileType.getType(dstParent);
            if (((SvnCopy)this.getOperation()).isMakeParents() && dstType == SVNFileType.NONE) {
                SVNFileUtil.ensureDirectoryExists(dstParent);
                SvnScheduleForAddition add = ((SvnCopy)this.getOperation()).getOperationFactory().createScheduleForAddition();
                add.setSingleTarget(SvnTarget.fromFile(dstParent));
                add.setDepth(SVNDepth.INFINITY);
                add.setIncludeIgnored(true);
                add.setForce(false);
                add.setAddParents(true);
                add.setSleepForTimestamp(false);
                try {
                    add.run();
                    continue;
                }
                catch (SVNException e) {
                    SVNFileUtil.deleteAll(dstParent, true);
                    throw e;
                }
            }
            if (dstType == SVNFileType.DIRECTORY) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' in not a directory", (Object)dstParent);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File locked = this.getWcContext().acquireWriteLock(topDst, false, true);
        try {
            Void void_ = this.copy(copyPairs, topDst, ignoreExternals, repository);
            return void_;
        }
        finally {
            this.getWcContext().releaseWriteLock(locked);
        }
    }

    private Void copy(Collection<SvnCopyPair> copyPairs, File topDst, boolean ignoreExternals, SVNRepository repository) throws SVNException {
        boolean sameRepositories;
        block6: {
            for (SvnCopyPair pair : copyPairs) {
                SVNErrorMessage err;
                SVNNodeKind dstKind = this.getWcContext().readKind(pair.dst, false);
                if (dstKind == SVNNodeKind.NONE) continue;
                Structure<StructureFields.NodeInfo> nodeInfo = this.getWcContext().getDb().readInfo(pair.dst, StructureFields.NodeInfo.status);
                ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status));
                nodeInfo.release();
                if (status == ISVNWCDb.SVNWCDbStatus.Excluded) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", (Object)pair.dst);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if (status == ISVNWCDb.SVNWCDbStatus.ServerExcluded) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", (Object)pair.dst);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if (dstKind == SVNNodeKind.DIR || status == ISVNWCDb.SVNWCDbStatus.Deleted || status == ISVNWCDb.SVNWCDbStatus.NotPresent) continue;
                err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Entry for ''{0}'' exists (though the working file is missing)", (Object)pair.dst);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            sameRepositories = false;
            try {
                String sourceUuid = repository.getRepositoryUUID(true);
                SVNWCContext.SVNWCNodeReposInfo info = this.getWcContext().getNodeReposInfo(topDst);
                String dstUuid = info != null ? info.reposUuid : null;
                sameRepositories = sourceUuid != null && dstUuid != null && sourceUuid.equals(dstUuid);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NO_REPOS_UUID) break block6;
                throw e;
            }
        }
        for (SvnCopyPair pair : copyPairs) {
            this.copy(pair, sameRepositories, ignoreExternals, repository);
        }
        this.sleepForTimestamp();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copy(final SvnCopyPair pair, boolean sameRepositories, boolean ignoreExternals, SVNRepository repository) throws SVNException {
        long rev = -1L;
        SVNURL oldLocation = repository.getLocation();
        repository.setLocation(pair.source, false);
        if (pair.srcKind == SVNNodeKind.DIR) {
            File dstParent = SVNFileUtil.getParentFile(pair.dst);
            final File dstPath = SVNFileUtil.createUniqueFile(dstParent, pair.dst.getName(), ".tmp", false);
            SVNFileUtil.deleteFile(dstPath);
            SVNFileUtil.ensureDirectoryExists(dstPath);
            try {
                SvnCheckout co = ((SvnCopy)this.getOperation()).getOperationFactory().createCheckout();
                co.setSingleTarget(SvnTarget.fromFile(dstPath));
                co.setSource(SvnTarget.fromURL(pair.sourceOriginal, pair.sourcePegRevision));
                co.setRevision(pair.sourceRevision);
                co.setIgnoreExternals(ignoreExternals);
                co.setDepth(SVNDepth.INFINITY);
                co.setAllowUnversionedObstructions(false);
                co.setSleepForTimestamp(false);
                final ISVNEventHandler oldHandler = this.getWcContext().getEventHandler();
                this.getWcContext().pushEventHandler(new ISVNEventHandler(){

                    public void checkCancelled() throws SVNCancelException {
                        if (oldHandler != null) {
                            oldHandler.checkCancelled();
                        }
                    }

                    public void handleEvent(SVNEvent event, double progress) throws SVNException {
                        File path = event.getFile();
                        if (path != null) {
                            if ((path = SVNWCUtils.skipAncestor(dstPath, path)) != null) {
                                path = new File(pair.dst, path.getPath());
                                event.setFile(path);
                            } else if (dstPath.equals(event.getFile())) {
                                event.setFile(pair.dst);
                            }
                        }
                        if (oldHandler != null) {
                            oldHandler.handleEvent(event, progress);
                        }
                    }
                });
                try {
                    rev = (Long)co.run();
                }
                finally {
                    this.getWcContext().popEventHandler();
                }
                if (sameRepositories) {
                    new SvnNgWcToWcCopy().copy(this.getWcContext(), dstPath, pair.dst, true);
                    File dstLock = this.getWcContext().acquireWriteLock(dstPath, false, true);
                    try {
                        this.getWcContext().removeFromRevisionControl(dstPath, false, false);
                    }
                    finally {
                        try {
                            this.getWcContext().releaseWriteLock(dstLock);
                        }
                        catch (SVNException e) {}
                    }
                    SVNFileUtil.rename(dstPath, pair.dst);
                }
                SVNFileUtil.rename(dstPath, pair.dst);
                this.sleepForTimestamp();
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Source URL ''{0}'' is from foreign repository; leaving it as a disjoint WC", (Object)pair.source);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            finally {
                SVNFileUtil.deleteAll(dstPath, true);
            }
        } else {
            String relativePath = "";
            File tmpDir = this.getWcContext().getDb().getWCRootTempDir(pair.dst);
            SVNWCContext.UniqueFileInfo ufInfo = SVNWCContext.openUniqueFile(tmpDir, true);
            SVNProperties newProperties = new SVNProperties();
            try {
                pair.revNum = repository.getFile(relativePath, pair.revNum, newProperties, ufInfo.stream);
            }
            finally {
                SVNFileUtil.closeFile(ufInfo.stream);
            }
            InputStream newContents = SVNFileUtil.openFileForReading(ufInfo.path);
            try {
                SvnNgReposToWcCopy.addFileToWc(this.getWcContext(), pair.dst, newContents, null, newProperties, null, sameRepositories ? pair.source : null, sameRepositories ? pair.revNum : -1L);
            }
            finally {
                SVNFileUtil.closeFile(newContents);
            }
        }
        Map<String, SVNMergeRangeList> mergeInfo = this.calculateTargetMergeInfo(pair.source, pair.revNum, repository);
        repository.setLocation(oldLocation, false);
        String mergeInfoProperty = this.getWcContext().getProperty(pair.dst, "svn:mergeinfo");
        Map<String, SVNMergeRangeList> wcMergeInfo = null;
        if (mergeInfoProperty != null) {
            wcMergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(mergeInfoProperty), null);
        }
        if (wcMergeInfo != null && mergeInfo != null) {
            wcMergeInfo = SVNMergeInfoUtil.mergeMergeInfos(wcMergeInfo, mergeInfo);
        } else if (wcMergeInfo == null) {
            wcMergeInfo = mergeInfo;
        }
        String extendedMergeInfoValue = null;
        if (wcMergeInfo != null) {
            extendedMergeInfoValue = SVNMergeInfoUtil.formatMergeInfoToString(wcMergeInfo, null);
        }
        SvnNgPropertiesManager.setProperty(this.getWcContext(), pair.dst, "svn:mergeinfo", extendedMergeInfoValue != null ? SVNPropertyValue.create(extendedMergeInfoValue) : null, SVNDepth.EMPTY, true, null, null);
        SVNEvent event = SVNEventFactory.createSVNEvent(pair.dst, pair.srcKind, null, pair.revNum, SVNEventAction.COPY, SVNEventAction.COPY, null, null, 1L, 1L);
        this.handleEvent(event);
        return rev;
    }

    private SVNURL getCommonCopyAncestor(Collection<SvnCopyPair> copyPairs) {
        SVNURL ancestor = null;
        for (SvnCopyPair svnCopyPair : copyPairs) {
            if (ancestor == null) {
                ancestor = svnCopyPair.source;
                continue;
            }
            ancestor = SVNURLUtil.getCommonURLAncestor(ancestor, svnCopyPair.source);
        }
        return ancestor;
    }

    private File getCommonCopyDst(Collection<SvnCopyPair> copyPairs) {
        String ancestor = null;
        for (SvnCopyPair svnCopyPair : copyPairs) {
            String path = svnCopyPair.dst.getAbsolutePath().replace(File.separatorChar, '/');
            if (ancestor == null) {
                ancestor = path;
                continue;
            }
            ancestor = SVNPathUtil.getCommonPathAncestor(ancestor, path);
        }
        return new File(ancestor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFileToWc(SVNWCContext context, File path, InputStream newBaseContents, InputStream newContents, SVNProperties newBaseProps, SVNProperties newProps, SVNURL copyFromURL, long copyFromRev) throws SVNException {
        SVNErrorMessage err;
        ISVNWCDb.SVNWCDbStatus status;
        block28: {
            context.writeCheck(path);
            status = null;
            try {
                Structure<StructureFields.NodeInfo> ni = context.getDb().readInfo(path, StructureFields.NodeInfo.status);
                status = (ISVNWCDb.SVNWCDbStatus)((Object)ni.get(StructureFields.NodeInfo.status));
                ni.release();
                switch (status) {
                    case NotPresent: 
                    case Deleted: {
                        break;
                    }
                    default: {
                        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Node ''{0}'' exists", (Object)path);
                        SVNErrorManager.error(err2, SVNLogType.WC);
                        break;
                    }
                }
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block28;
                throw e;
            }
        }
        File dirPath = SVNFileUtil.getParentFile(path);
        Structure<StructureFields.NodeInfo> ni = context.getDb().readInfo(dirPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind);
        status = (ISVNWCDb.SVNWCDbStatus)((Object)ni.get(StructureFields.NodeInfo.status));
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)ni.get(StructureFields.NodeInfo.kind));
        ni.release();
        switch (status) {
            case Normal: 
            case Added: {
                break;
            }
            case Deleted: {
                err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Can''t add ''{0}'' to a parent directory scheduled for deletion", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            default: {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Can''t find parent directory''s node while trying to add ''{0}''", (Object)path);
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
        }
        if (kind != ISVNWCDb.SVNWCDbKind.Dir) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Can''t schedule an addition of ''{0}'' below a not-directory node", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNURL originalURL = null;
        File originalReposPath = null;
        String originalUuid = null;
        if (copyFromURL != null) {
            SVNWCContext.SVNWCNodeReposInfo reposInfo = context.getNodeReposInfo(dirPath);
            if (!SVNURLUtil.isAncestor(reposInfo.reposRootUrl, copyFromURL)) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Copyfrom-url ''{0}'' has different repository root than ''{0}''", copyFromURL, reposInfo.reposRootUrl);
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            originalUuid = reposInfo.reposUuid;
            originalURL = reposInfo.reposRootUrl;
            String reposPath = SVNURLUtil.getRelativeURL(originalURL, copyFromURL, false);
            if (reposPath.startsWith("/")) {
                reposPath = reposPath.substring("/".length());
            }
            originalReposPath = new File(reposPath);
        } else {
            copyFromRev = -1L;
        }
        SVNProperties regularProps = new SVNProperties();
        SVNProperties entryProps = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(newBaseProps, regularProps, entryProps, null);
        newBaseProps = regularProps;
        long changedRev = entryProps.containsName("svn:entry:committed-rev") ? Long.parseLong(entryProps.getStringValue("svn:entry:committed-rev")) : -1L;
        String changedAuthor = entryProps.getStringValue("svn:entry:last-author");
        SVNDate changedDate = entryProps.containsName("svn:entry:committed-rev") ? SVNDate.parseDate(entryProps.getStringValue("svn:entry:committed-date")) : new SVNDate(0L, 0);
        SVNWCContext.WritableBaseInfo wbInfo = context.openWritableBase(path, true, true);
        try {
            SVNTranslator.copy(newBaseContents, wbInfo.stream);
        }
        catch (IOException e) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(err4, SVNLogType.WC);
        }
        finally {
            SVNFileUtil.closeFile(wbInfo.stream);
        }
        File sourcePath = null;
        if (newContents != null) {
            File tempDir = context.getDb().getWCRootTempDir(path);
            SVNWCContext.UniqueFileInfo ufInfo = SVNWCContext.openUniqueFile(tempDir, true);
            try {
                SVNTranslator.copy(newContents, ufInfo.stream);
            }
            catch (IOException e) {
                SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                SVNErrorManager.error(err5, SVNLogType.WC);
            }
            finally {
                SVNFileUtil.closeFile(ufInfo.stream);
            }
            sourcePath = ufInfo.path;
        }
        if (copyFromURL != null) {
            context.getDb().installPristine(wbInfo.tempBaseAbspath, wbInfo.getSHA1Checksum(), wbInfo.getMD5Checksum());
        }
        if (newContents == null && copyFromURL == null) {
            sourcePath = wbInfo.tempBaseAbspath;
        }
        boolean recordFileInfo = newContents == null;
        SVNSkel wi = context.wqBuildFileInstall(path, sourcePath, false, recordFileInfo);
        wi = context.wqMerge(wi, null);
        if (sourcePath != null) {
            SVNSkel remove = context.wqBuildFileRemove(sourcePath);
            wi = context.wqMerge(wi, remove);
        }
        context.getDb().opCopyFile(path, newBaseProps, changedRev, changedDate, changedAuthor, originalReposPath, originalURL, originalUuid, copyFromRev, copyFromURL != null ? wbInfo.getSHA1Checksum() : null, null, null);
        context.getDb().opSetProps(path, newProps, null, false, wi);
        context.wqRun(dirPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, SVNMergeRangeList> calculateTargetMergeInfo(SVNURL srcURL, long srcRevision, SVNRepository repository) throws SVNException {
        SVNURL url = null;
        url = srcURL;
        Map<String, SVNMergeRangeList> targetMergeInfo = null;
        SVNRepository repos = repository;
        if (repos == null) {
            repos = this.getRepositoryAccess().createRepository(url, null, false);
        }
        SVNURL oldLocation = null;
        try {
            String mergeInfoPath = this.getRepositoryAccess().getPathRelativeToSession(url, null, repos);
            if (mergeInfoPath == null) {
                oldLocation = repos.getLocation();
                repos.setLocation(url, false);
                mergeInfoPath = "";
            }
            targetMergeInfo = this.getRepositoryAccess().getReposMergeInfo(repos, mergeInfoPath, srcRevision, SVNMergeInfoInheritance.INHERITED, true);
            if (repository == null) {
                repos.closeSession();
                return targetMergeInfo;
            }
            if (oldLocation == null) return targetMergeInfo;
        }
        catch (Throwable throwable) {
            if (repository == null) {
                repos.closeSession();
                throw throwable;
            } else {
                if (oldLocation == null) throw throwable;
                repos.setLocation(oldLocation, false);
            }
            throw throwable;
        }
        repos.setLocation(oldLocation, false);
        return targetMergeInfo;
    }

    private static class SvnCopyPair {
        SVNNodeKind srcKind;
        long revNum;
        SVNURL sourceOriginal;
        File sourceFile;
        SVNURL source;
        SVNRevision sourceRevision;
        SVNRevision sourcePegRevision;
        File dst;

        private SvnCopyPair() {
        }
    }
}

