/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.webdav;

import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.harvest.harvester.webdav.RemoteFile;
import org.fao.geonet.kernel.harvest.harvester.webdav.WAFRetriever;
import org.fao.geonet.util.Sha1Encoder;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;

class WAFRemoteFile
implements RemoteFile {
    private static String outputSchema = "iso19139";
    private String path;
    private ISODate changeDate;

    public WAFRemoteFile(String path) {
        this.path = path;
    }

    @Override
    public Element getMetadata(SchemaManager schemaMan) throws Exception {
        String type = WAFRetriever.getFileType(this.path);
        if (type.equals("GetCapabilities")) {
            return this.getMdFromService(this.path, schemaMan);
        }
        if (type.equals("xml")) {
            return Xml.loadFile((URL)new URL(this.path));
        }
        return null;
    }

    private Element getMdFromService(String url, SchemaManager schemaMan) throws Exception {
        Element el = null;
        Path styleSheet = this.getStyleSheet(url, schemaMan);
        if (styleSheet == null) {
            return null;
        }
        Element xml = Xml.loadFile((URL)new URL(url));
        String uuid = Sha1Encoder.encodeString((String)url);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uuid", uuid);
        el = Xml.transform((Element)xml, (Path)styleSheet, param);
        return el;
    }

    private Path getStyleSheet(String url, SchemaManager schemaMan) {
        String serviceType = this.getServiceType(url);
        if (serviceType == null) {
            return null;
        }
        return schemaMan.getSchemaDir(outputSchema).resolve("convert/").resolve("OGCWxSGetCapabilitiesto19119").resolve("OGC" + serviceType + "GetCapabilities-to-ISO19119_ISO19139.xsl");
    }

    private String getServiceType(String url) {
        if (url.toUpperCase().contains("SERVICE=WMS")) {
            return "WMS";
        }
        if (url.toUpperCase().contains("SERVICE=WCS")) {
            return "WCS";
        }
        if (url.toUpperCase().contains("SERVICE=WFS")) {
            return "WFS";
        }
        if (url.toUpperCase().contains("SERVICE=WPS")) {
            return "WPS";
        }
        return null;
    }

    @Override
    public boolean isMoreRecentThan(String localChangeDate) {
        ISODate remoteDate = this.changeDate;
        if (remoteDate == null) {
            return true;
        }
        ISODate localDate = new ISODate(localChangeDate);
        return remoteDate.timeDifferenceInSeconds(localDate) > 0L;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public ISODate getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(String date) {
        try {
            this.changeDate = new ISODate(ISODate.parseBasicOrFullDateTime((String)date).getMillis());
        }
        catch (Exception e) {
            this.changeDate = null;
        }
    }

    public static class WXS {
        public static final String WMS = "SERVICE=WMS";
        public static final String WCS = "SERVICE=WCS";
        public static final String WFS = "SERVICE=WFS";
        public static final String WPS = "SERVICE=WPS";
    }
}

