/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class PreparedStatementSQLDialect
extends SQLDialect {
    protected PreparedStatementSQLDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public void prepareGeometryValue(Class<? extends Geometry> gClass, int dimension, int srid, Class binding, StringBuffer sql) {
        sql.append("?");
    }

    public final void prepareGeometryValue(Geometry g, int dimension, int srid, Class binding, StringBuffer sql) {
        this.prepareGeometryValue(g == null ? null : g.getClass(), dimension, srid, binding, sql);
    }

    public void prepareFunctionArgument(Class clazz, StringBuffer sql) {
        sql.append("?");
    }

    public abstract void setGeometryValue(Geometry var1, int var2, int var3, Class var4, PreparedStatement var5, int var6) throws SQLException;

    public void setValue(Object value, Class binding, PreparedStatement ps, int column, Connection cx) throws SQLException {
        Integer sqlType = this.dataStore.getMapping(binding);
        if (value == null) {
            ps.setNull(column, sqlType);
            return;
        }
        switch (sqlType) {
            case 12: {
                ps.setString(column, this.convert(value, String.class));
                break;
            }
            case 16: {
                ps.setBoolean(column, this.convert(value, Boolean.class));
                break;
            }
            case 5: {
                ps.setShort(column, this.convert(value, Short.class));
                break;
            }
            case 4: {
                ps.setInt(column, this.convert(value, Integer.class));
                break;
            }
            case -5: {
                ps.setLong(column, this.convert(value, Long.class));
                break;
            }
            case 7: {
                ps.setFloat(column, this.convert(value, Float.class).floatValue());
                break;
            }
            case 8: {
                ps.setDouble(column, this.convert(value, Double.class));
                break;
            }
            case 2: {
                ps.setBigDecimal(column, this.convert(value, BigDecimal.class));
                break;
            }
            case 91: {
                ps.setDate(column, this.convert(value, Date.class));
                break;
            }
            case 92: {
                ps.setTime(column, this.convert(value, Time.class));
                break;
            }
            case 93: {
                ps.setTimestamp(column, this.convert(value, Timestamp.class));
                break;
            }
            case 2004: {
                ps.setBytes(column, this.convert(value, byte[].class));
                break;
            }
            case 2005: {
                String string = this.convert(value, String.class);
                ps.setCharacterStream(column, (Reader)new StringReader(string), string.length());
                break;
            }
            default: {
                ps.setObject(column, value, 1111);
            }
        }
    }

    <T> T convert(Object value, Class<T> binding) {
        if (value == null) {
            return (T)value;
        }
        if (!binding.isInstance(value)) {
            T converted = Converters.convert(value, binding);
            if (converted != null) {
                value = converted;
            } else {
                this.dataStore.getLogger().warning("Unable to convert " + value + " to " + binding.getName());
            }
        }
        return (T)value;
    }

    public PreparedFilterToSQL createPreparedFilterToSQL() {
        PreparedFilterToSQL f2s = new PreparedFilterToSQL();
        f2s.setCapabilities(BASE_DBMS_CAPABILITIES);
        return f2s;
    }

    public void onSelect(PreparedStatement select, Connection cx, SimpleFeatureType featureType) throws SQLException {
    }

    public void onDelete(PreparedStatement delete, Connection cx, SimpleFeatureType featureType) throws SQLException {
    }

    public void onInsert(PreparedStatement insert, Connection cx, SimpleFeatureType featureType) throws SQLException {
    }

    public void onUpdate(PreparedStatement update, Connection cx, SimpleFeatureType featureType) throws SQLException {
    }
}

