/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.marc4j.MarcException;
import org.marc4j.converter.impl.CodeTableTracker;
import org.marc4j.converter.impl.ReverseCodeTableHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ReverseCodeTable {
    protected static Hashtable charset = null;
    protected static Vector combining = null;

    public boolean isCombining(Character c) {
        return combining.contains(c);
    }

    public Hashtable codeTableHash(Character c) {
        Hashtable chars = (Hashtable)charset.get(c);
        if (chars == null) {
            System.err.println("Not Found: " + c);
            return chars;
        }
        return chars;
    }

    public static boolean inPreviousCharCodeTable(Character c, CodeTableTracker ctt) {
        Hashtable chars = (Hashtable)charset.get(c);
        if (chars == null) {
            System.out.println("Not Found: " + c);
            return false;
        }
        if (chars.get(ctt.getPrevious((byte)0)) != null || chars.get(ctt.getPrevious((byte)1)) != null) {
            ctt.makePreviousCurrent();
            return true;
        }
        return false;
    }

    public static char getChar(Character c, CodeTableTracker ctt) {
        Hashtable chars = (Hashtable)charset.get(c);
        Integer marc = (Integer)chars.get(ctt.getCurrent((byte)0));
        if (marc != null) {
            return (char)marc.intValue();
        }
        marc = (Integer)chars.get(ctt.getCurrent((byte)1));
        if (marc != null) {
            return (char)marc.intValue();
        }
        return ' ';
    }

    public ReverseCodeTable(InputStream byteStream) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            InputSource src = new InputSource(byteStream);
            ReverseCodeTableHandler saxUms = new ReverseCodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charset = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }

    public ReverseCodeTable(String filename) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            File file = new File(filename);
            InputSource src = new InputSource(new FileInputStream(file));
            ReverseCodeTableHandler saxUms = new ReverseCodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charset = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }

    public ReverseCodeTable(URI uri) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            InputSource src = new InputSource(uri.toURL().openStream());
            ReverseCodeTableHandler saxUms = new ReverseCodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charset = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }
}

